/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.entity.projectile.MagicBulletEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagicBulletRenderer
extends EntityRenderer<MagicBulletEntity> {
    private static final ResourceLocation TEX0 = new ResourceLocation("hmag", "textures/entity/projectile/magic_bullet_0.png");
    private static final ResourceLocation TEX1 = new ResourceLocation("hmag", "textures/entity/projectile/magic_bullet_1.png");
    private static final ResourceLocation TEX2 = new ResourceLocation("hmag", "textures/entity/projectile/magic_bullet_2.png");

    public MagicBulletRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    protected int getBlockLightLevel(MagicBulletEntity entityIn, BlockPos pos) {
        switch (entityIn.getVariant()) {
            case 1: {
                return MathHelper.func_76125_a((int)(super.func_225624_a_((Entity)entityIn, pos) + 7), (int)0, (int)15);
            }
        }
        return 15;
    }

    public void render(MagicBulletEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(2.0f, 2.0f, 2.0f);
        matrixStackIn.func_227863_a_(this.field_76990_c.func_229098_b_());
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float f = (float)entityIn.field_70173_aa + partialTicks;
        float f1 = 0.5f + (entityIn.getVariant() == 2 ? MathHelper.func_76126_a((float)(f * 0.8f)) * 0.03f : MathHelper.func_76126_a((float)(f * 0.4f)) * 0.09f);
        matrixStackIn.func_227862_a_(f1, f1, f1);
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation(entityIn)));
        this.drawVertex(ivertexbuilder, matrix4f, matrix3f, packedLightIn, 0.0f, 0, 0, 1);
        this.drawVertex(ivertexbuilder, matrix4f, matrix3f, packedLightIn, 1.0f, 0, 1, 1);
        this.drawVertex(ivertexbuilder, matrix4f, matrix3f, packedLightIn, 1.0f, 1, 1, 0);
        this.drawVertex(ivertexbuilder, matrix4f, matrix3f, packedLightIn, 0.0f, 1, 0, 0);
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void drawVertex(IVertexBuilder vertexBuilder, Matrix4f matrix, Matrix3f normals, int packedLightIn, float f, int i, int j, int k) {
        vertexBuilder.func_227888_a_(matrix, f - 0.5f, (float)i - 0.25f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_((float)j, (float)k).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(normals, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public ResourceLocation getTextureLocation(MagicBulletEntity entityIn) {
        switch (entityIn.getVariant()) {
            case 1: {
                return TEX1;
            }
            case 2: {
                return TEX2;
            }
        }
        return TEX0;
    }
}

