/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.model.MonolithModel;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.entity.MonolithEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MonolithRenderer
extends MobRenderer<MonolithEntity, MonolithModel<MonolithEntity>> {
    private static final ResourceLocation TEX0 = new ResourceLocation("hmag", "textures/entity/monolith_0.png");
    private static final ResourceLocation TEX1 = new ResourceLocation("hmag", "textures/entity/monolith_1.png");
    private static final ResourceLocation TEX2 = new ResourceLocation("hmag", "textures/entity/monolith_2.png");
    private static final ResourceLocation TEX3 = new ResourceLocation("hmag", "textures/entity/monolith_3.png");
    private static final ResourceLocation TEX4 = new ResourceLocation("hmag", "textures/entity/monolith_4.png");
    private static final ResourceLocation BEAM_TEX = new ResourceLocation("textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.func_228640_c_((ResourceLocation)BEAM_TEX);
    private final Random rand = new Random();

    public MonolithRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new MonolithModel(), 0.5f);
    }

    public boolean shouldRender(MonolithEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        if (super.func_225626_a_((MobEntity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        return ModClientUtils.shouldRenderBeamAttackMob((LivingEntity)livingEntityIn, camera, camX, camY, camZ, livingEntityIn);
    }

    public void render(MonolithEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        LivingEntity target = entityIn.getActiveAttackTarget();
        if (target != null) {
            float f = entityIn.getAttackAnimationScale(partialTicks);
            float f1 = (float)(entityIn.field_70170_p.func_82737_E() % 24000L) + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entityIn.func_70047_e();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f3, 0.0);
            Vector3d vector3d = ModClientUtils.getPosition(target, (double)target.func_213302_cg() * 0.5, partialTicks);
            Vector3d vector3d1 = ModClientUtils.getPosition((LivingEntity)entityIn, f3, partialTicks);
            Vector3d vector3d2 = vector3d.func_178788_d(vector3d1);
            float f4 = (float)(vector3d2.func_72433_c() + 1.0);
            vector3d2 = vector3d2.func_72432_b();
            float f5 = (float)Math.acos(vector3d2.field_72448_b);
            float f6 = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
            float f7 = f1 * 0.05f * -1.5f;
            float f8 = f * f;
            int i = 192 + (int)(f8 * 55.0f);
            int j = 32 + (int)(f8 * 159.0f);
            int k = 160 + (int)(f8 * 63.0f);
            float f11 = MathHelper.func_76134_b((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = MathHelper.func_76126_a((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = MathHelper.func_76134_b((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = MathHelper.func_76126_a((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = MathHelper.func_76134_b((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = MathHelper.func_76126_a((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = MathHelper.func_76134_b((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = MathHelper.func_76126_a((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = MathHelper.func_76134_b((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = MathHelper.func_76126_a((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = MathHelper.func_76134_b((float)(f7 + 0.0f)) * 0.2f;
            float f22 = MathHelper.func_76126_a((float)(f7 + 0.0f)) * 0.2f;
            float f23 = MathHelper.func_76134_b((float)(f7 + 1.5707964f)) * 0.2f;
            float f24 = MathHelper.func_76126_a((float)(f7 + 1.5707964f)) * 0.2f;
            float f25 = MathHelper.func_76134_b((float)(f7 + 4.712389f)) * 0.2f;
            float f26 = MathHelper.func_76126_a((float)(f7 + 4.712389f)) * 0.2f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(BEAM_RENDER_TYPE);
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
            Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, i, j, k, 0.5f, f30);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, i, j, k, 0.5f, f29);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, i, j, k, 0.0f, f29);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, i, j, k, 0.0f, f30);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, i, j, k, 0.5f, f30);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, i, j, k, 0.5f, f29);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, i, j, k, 0.0f, f29);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, i, j, k, 0.0f, f30);
            float f31 = entityIn.field_70173_aa % 2 == 0 ? 0.5f : 0.0f;
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, i, j, k, 0.5f, f31 + 0.5f);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, i, j, k, 1.0f, f31 + 0.5f);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, i, j, k, 1.0f, f31);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, i, j, k, 0.5f, f31);
            matrixStackIn.func_227865_b_();
        }
    }

    public Vector3d getRenderOffset(MonolithEntity entityIn, float partialTicks) {
        if (entityIn.getAttackPhase() == MonolithEntity.AttackPhase.ROAR_ATTACK) {
            return new Vector3d(this.rand.nextGaussian() * 0.01, 0.0, this.rand.nextGaussian() * 0.01);
        }
        return super.func_225627_b_((Entity)entityIn, partialTicks);
    }

    protected int getBlockLightLevel(MonolithEntity entityIn, BlockPos pos) {
        return MathHelper.func_76125_a((int)(super.func_225624_a_((Entity)entityIn, pos) + 12), (int)0, (int)15);
    }

    public ResourceLocation getTextureLocation(MonolithEntity entityIn) {
        switch (entityIn.getAttackPhase()) {
            case BEAM_CHARGE2: 
            case BEAM_END: {
                return TEX1;
            }
            case BEAM_ATTACK: {
                return TEX2;
            }
            case ROAR_CHARGE: 
            case ROAR_END: {
                return TEX3;
            }
            case ROAR_ATTACK: {
                return TEX4;
            }
        }
        return TEX0;
    }
}

