/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractClothingLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public AbstractClothingLayer(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T livingEntityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!livingEntityIn.func_82150_aj() && this.canRender(livingEntityIn)) {
            EntityModel<T> entitymodel = this.model();
            this.func_215332_c().func_217111_a(entitymodel);
            entitymodel.func_212843_a_(livingEntityIn, limbSwing, limbSwingAmount, partialTicks);
            entitymodel.func_225597_a_(livingEntityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ResourceLocation resourcelocation = this.getLayerTexture(livingEntityIn);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)resourcelocation));
            entitymodel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_(livingEntityIn, (float)0.0f), this.getR(livingEntityIn), this.getG(livingEntityIn), this.getB(livingEntityIn), this.getAlpha(livingEntityIn));
        }
    }

    protected boolean canRender(T livingEntityIn) {
        return true;
    }

    protected float getR(T livingEntityIn) {
        return 1.0f;
    }

    protected float getG(T livingEntityIn) {
        return 1.0f;
    }

    protected float getB(T livingEntityIn) {
        return 1.0f;
    }

    protected float getAlpha(T livingEntityIn) {
        return 1.0f;
    }

    protected abstract ResourceLocation getLayerTexture(T var1);

    protected abstract EntityModel<T> model();
}

