/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer.layers;

import com.github.mechalopa.hmag.client.model.MeltyMonsterModel;
import com.github.mechalopa.hmag.entity.MeltyMonsterEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MeltyMonsterLayer
extends LayerRenderer<MeltyMonsterEntity, MeltyMonsterModel<MeltyMonsterEntity>> {
    private static final ResourceLocation TEX = new ResourceLocation("hmag", "textures/entity/melty_monster_overlay.png");
    private final MeltyMonsterModel<MeltyMonsterEntity> modelOuterLayer = new MeltyMonsterModel(0.0f, true);

    public MeltyMonsterLayer(IEntityRenderer<MeltyMonsterEntity, MeltyMonsterModel<MeltyMonsterEntity>> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MeltyMonsterEntity livingEntityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!livingEntityIn.func_82150_aj()) {
            float f = (float)livingEntityIn.field_70173_aa + partialTicks;
            ((MeltyMonsterModel)this.func_215332_c()).func_217148_a(this.modelOuterLayer);
            this.modelOuterLayer.func_212843_a_((LivingEntity)livingEntityIn, limbSwing, limbSwingAmount, partialTicks);
            this.modelOuterLayer.setupAnim(livingEntityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ResourceLocation resourcelocation = this.getLayerTexture(livingEntityIn);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(MeltyMonsterLayer.getMeltyMonsterOverlay(resourcelocation, 0.0f, f * -0.001f));
            this.modelOuterLayer.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getLayerTexture(MeltyMonsterEntity entity) {
        return TEX;
    }

    public static RenderType getMeltyMonsterOverlay(ResourceLocation locationIn, float uIn, float vIn) {
        RenderState.TransparencyState transparencyState = new RenderState.TransparencyState("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        RenderType.State renderTypeState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228725_a_((RenderState.TexturingState)new RenderState.OffsetTexturingState(uIn, vIn)).func_228726_a_(transparencyState).func_228716_a_(new RenderState.DiffuseLightingState(true)).func_228714_a_(new RenderState.CullState(false)).func_228719_a_(new RenderState.LightmapState(false)).func_228722_a_(new RenderState.OverlayState(true)).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"melty_monster_overlay", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)renderTypeState);
    }
}

