/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.util.ModUtils;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractFlyingMonsterEntity
extends MonsterEntity {
    protected static final DataParameter<Byte> ATTACK_PHASE = EntityDataManager.func_187226_a(AbstractFlyingMonsterEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private BlockPos boundOrigin;

    public AbstractFlyingMonsterEntity(EntityType<? extends AbstractFlyingMonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_PHASE, (Object)0);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && source.func_76346_g() instanceof LivingEntity && this.isCharging() && this.func_70681_au().nextInt(3) == 0) {
            this.setAttackPhase(1);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        compound.func_74768_a("AttackPhase", this.getAttackPhase());
        if (compound.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(compound.func_74762_e("BoundX"), compound.func_74762_e("BoundY"), compound.func_74762_e("BoundZ"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.setAttackPhase(compound.func_74762_e("AttackPhase"));
        if (this.boundOrigin != null) {
            compound.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            compound.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            compound.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    public int getAttackPhase() {
        return ((Byte)this.field_70180_af.func_187225_a(ATTACK_PHASE)).byteValue();
    }

    public void setAttackPhase(int value) {
        int i = value;
        if (i < 0 || i >= 3) {
            i = 0;
        }
        this.field_70180_af.func_187227_b(ATTACK_PHASE, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getAttackPhase() == 2;
    }

    protected class MoveRandomGoal
    extends Goal {
        private final double moveSpeed;
        private final int chance;
        private final int width;
        private final int height;

        public MoveRandomGoal() {
            this(0.25);
        }

        public MoveRandomGoal(double moveSpeedIn) {
            this(moveSpeedIn, 6, 3, 2);
        }

        public MoveRandomGoal(double moveSpeedIn, int chanceIn, int width, int height) {
            this.moveSpeed = moveSpeedIn;
            this.chance = chanceIn;
            this.width = width;
            this.height = height;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !AbstractFlyingMonsterEntity.this.func_70605_aq().func_75640_a() && AbstractFlyingMonsterEntity.this.func_70681_au().nextInt(this.chance) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            if (AbstractFlyingMonsterEntity.this.func_70638_az() == null || !AbstractFlyingMonsterEntity.this.func_70638_az().func_70089_S()) {
                AbstractFlyingMonsterEntity.this.setAttackPhase(0);
            }
        }

        public void func_75246_d() {
            AbstractFlyingMonsterEntity flyingentity = AbstractFlyingMonsterEntity.this;
            BlockPos blockpos = flyingentity.getBoundOrigin();
            if (blockpos == null) {
                blockpos = flyingentity.func_233580_cy_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(flyingentity.func_70681_au().nextInt(this.width * 2 + 1) - this.width, flyingentity.func_70681_au().nextInt(this.height * 2 + 1) - this.height, flyingentity.func_70681_au().nextInt(this.width * 2 + 1) - this.width);
                if (!flyingentity.field_70170_p.func_175623_d(blockpos1)) continue;
                flyingentity.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, this.moveSpeed);
                if (flyingentity.func_70638_az() != null) break;
                flyingentity.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    protected class MoveHelperController
    extends MovementController {
        public MoveHelperController(AbstractFlyingMonsterEntity mob) {
            super((MobEntity)mob);
        }

        public void func_75641_c() {
            AbstractFlyingMonsterEntity flyingentity = AbstractFlyingMonsterEntity.this;
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - flyingentity.func_226277_ct_(), this.field_75647_c - flyingentity.func_226278_cu_(), this.field_75644_d - flyingentity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (d0 < flyingentity.func_174813_aQ().func_72320_b() || !ModUtils.canReach((LivingEntity)flyingentity, vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    flyingentity.func_213317_d(flyingentity.func_213322_ci().func_186678_a(0.5));
                } else {
                    float f = (float)flyingentity.func_233637_b_(Attributes.field_233821_d_);
                    flyingentity.func_213317_d(flyingentity.func_213322_ci().func_178787_e(vector3d.func_186678_a((double)((float)this.field_75645_e * f) * 0.2 / d0)));
                    if (flyingentity.func_70638_az() == null) {
                        Vector3d vector3d1 = flyingentity.func_213322_ci();
                        flyingentity.field_70761_aq = flyingentity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d2 = flyingentity.func_70638_az().func_226277_ct_() - flyingentity.func_226277_ct_();
                        double d1 = flyingentity.func_70638_az().func_226281_cx_() - flyingentity.func_226281_cx_();
                        flyingentity.field_70761_aq = flyingentity.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                    }
                }
            }
        }
    }

    protected class ChargeAttackGoal
    extends Goal {
        private final double moveSpeed;
        private final float attackRadius;
        private final int chance;
        protected int attackTime;

        public ChargeAttackGoal() {
            this(0.3, 2.0f);
        }

        public ChargeAttackGoal(double moveSpeedIn, float maxAttackDistanceIn) {
            this(moveSpeedIn, maxAttackDistanceIn, 4);
        }

        public ChargeAttackGoal(double moveSpeedIn, float maxAttackDistanceIn, int chanceIn) {
            this.moveSpeed = moveSpeedIn;
            this.attackRadius = maxAttackDistanceIn;
            this.chance = chanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (AbstractFlyingMonsterEntity.this.func_70638_az() != null && !AbstractFlyingMonsterEntity.this.func_70605_aq().func_75640_a() && AbstractFlyingMonsterEntity.this.func_70681_au().nextInt(this.chance) == 0) {
                return AbstractFlyingMonsterEntity.this.func_70068_e((Entity)AbstractFlyingMonsterEntity.this.func_70638_az()) > (double)this.attackRadius;
            }
            return false;
        }

        public boolean func_75253_b() {
            return AbstractFlyingMonsterEntity.this.func_70605_aq().func_75640_a() && AbstractFlyingMonsterEntity.this.isCharging() && AbstractFlyingMonsterEntity.this.func_70638_az() != null && AbstractFlyingMonsterEntity.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            LivingEntity livingentity = AbstractFlyingMonsterEntity.this.func_70638_az();
            if (AbstractFlyingMonsterEntity.this.func_70685_l((Entity)livingentity) || AbstractFlyingMonsterEntity.this.getAttackPhase() != 0) {
                Vector3d vector3d = livingentity.func_174824_e(1.0f);
                AbstractFlyingMonsterEntity.this.field_70765_h.func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b - 0.75, vector3d.field_72449_c, this.moveSpeed);
                AbstractFlyingMonsterEntity.this.setAttackPhase(2);
            }
        }

        public void func_75251_c() {
            AbstractFlyingMonsterEntity.this.setAttackPhase(AbstractFlyingMonsterEntity.this.func_70638_az() != null && AbstractFlyingMonsterEntity.this.func_70638_az().func_70089_S() ? 1 : 0);
        }

        public void func_75246_d() {
            AbstractFlyingMonsterEntity attacker = AbstractFlyingMonsterEntity.this;
            LivingEntity livingentity = attacker.func_70638_az();
            this.attackTime = Math.max(this.attackTime - 1, 0);
            attacker.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            double d0 = attacker.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
            double d1 = this.getAttackReachSqr(livingentity);
            if (d0 <= d1 && this.attackTime <= 0) {
                this.attackTime = 20;
                attacker.func_184609_a(Hand.MAIN_HAND);
                attacker.func_70652_k((Entity)livingentity);
                attacker.setAttackPhase(1);
            } else if (attacker.func_70685_l((Entity)livingentity)) {
                if (d0 < (double)(this.attackRadius + 15.0f)) {
                    Vector3d vector3d = livingentity.func_174824_e(1.0f);
                    attacker.field_70765_h.func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b - 0.75, vector3d.field_72449_c, this.moveSpeed);
                }
            } else if (attacker.func_70681_au().nextInt(16) == 0) {
                attacker.setAttackPhase(0);
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return AbstractFlyingMonsterEntity.this.func_213311_cf() * 2.0f * AbstractFlyingMonsterEntity.this.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
        }
    }
}

