/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.entity.goal.MeleeAttackGoal2;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;

public class CrimsonSlaughtererEntity
extends MonsterEntity
implements IModMob {
    public CrimsonSlaughtererEntity(EntityType<? extends CrimsonSlaughtererEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 20;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal2((CreatureEntity)this, 1.0, false, 0.8f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(120));
        if (ModConfigs.cachedServer.CRIMSON_SLAUGHTERER_ATTACK_ANIMALS) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 10, false, false, p -> !ModTags.checkTagContains(ModTags.CRIMSON_SLAUGHTERER_TARGET_ANIMAL_BLACKLIST, p.func_200600_R()) && p.func_70068_e((Entity)this) <= 64.0));
        }
        if (ModConfigs.cachedServer.CRIMSON_SLAUGHTERER_ATTACK_VILLAGERS) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        }
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.33).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233824_g_, 0.5).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233820_c_, 0.75);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 20;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76438_s, i * 20, 1));
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 0));
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76419_f, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76352_a() || source == DamageSource.field_76368_d || source == DamageSource.field_191291_g || source == DamageSource.field_76366_f || ModUtils.isThornsDamage(source)) {
            amount *= 0.5f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76438_s || potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public static boolean checkCrimsonSlaughtererSpawnRules(EntityType<CrimsonSlaughtererEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223325_c(type, (IServerWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn) && (reason == SpawnReason.SPAWNER || randomIn.nextDouble() < ModConfigs.cachedServer.CRIMSON_SLAUGHTERER_SPAWN_CHANCE);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.55f;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

