/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.entity.goal.HurtByTargetGoal2;
import com.github.mechalopa.hmag.entity.projectile.MagicBulletEntity;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModSpawnRules;
import com.github.mechalopa.hmag.util.ModUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;

public class DyssomniaEntity
extends FlyingEntity
implements IMob,
IModMob {
    private static final DataParameter<Byte> ATTACK_PHASE = EntityDataManager.func_187226_a(DyssomniaEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> ATTACKING_TIME = EntityDataManager.func_187226_a(DyssomniaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> RETREATING = EntityDataManager.func_187226_a(DyssomniaEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float xRotAnimation;
    private float xRotAnimationO;
    private int animationTick;
    private int animationTickO;

    public DyssomniaEntity(EntityType<? extends DyssomniaEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 25;
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new LookHelperController((MobEntity)this);
    }

    protected BodyController func_184650_s() {
        return new BodyHelperController((MobEntity)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAroundGoal(this));
        if (ModConfigs.cachedServer.DYSSOMNIA_SUMMON_PHANTOM) {
            this.field_70714_bg.func_75776_a(7, (Goal)new SummonGoal(this));
        }
        this.field_70714_bg.func_75776_a(8, (Goal)new ShotAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal2((MobEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(180));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_PHASE, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKING_TIME, (Object)-1);
        this.field_70180_af.func_187214_a(RETREATING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.xRotAnimationO = this.xRotAnimation;
            this.animationTickO = this.animationTick;
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            float f = MathHelper.func_76134_b((float)((float)(this.func_145782_y() * 3 + this.field_70173_aa) * 0.13f + (float)Math.PI));
            float f1 = MathHelper.func_76134_b((float)((float)(this.func_145782_y() * 3 + this.field_70173_aa + 1) * 0.13f + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_206944_gn, this.func_184176_by(), 0.95f + this.field_70146_Z.nextFloat() * 0.05f, 0.95f + this.field_70146_Z.nextFloat() * 0.05f, false);
            }
            boolean flag = this.isActuallyRetreating();
            for (int i = 0; i < 3; ++i) {
                float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * ((float)i * 0.4f + 1.7f);
                float f3 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * ((float)i * 0.4f + 1.7f);
                float f4 = 0.4f + f * ((float)i * 0.05f + 0.5f);
                if (flag && this.field_70173_aa % 12 == i * 3) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (double)f2, this.func_226278_cu_() + (double)f4, this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() - (double)f2, this.func_226278_cu_() + (double)f4, this.func_226281_cx_() - (double)f3, 0.0, 0.0, 0.0);
                    continue;
                }
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() + (double)f2, this.func_226278_cu_() + (double)f4, this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() - (double)f2, this.func_226278_cu_() + (double)f4, this.func_226281_cx_() - (double)f3, 0.0, 0.0, 0.0);
            }
            if (this.getAttackingTime() >= 0) {
                if (this.getAttackPhase() == AttackPhase.SHOT) {
                    double d0 = 1.75;
                    double d1 = 1.5;
                    Vector3d vector3d = this.func_70676_i(1.0f);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + vector3d.field_72450_a * d0, this.func_226280_cw_() - vector3d.field_72448_b * d1, this.func_226281_cx_() + vector3d.field_72449_c * d0, 0.0, 0.0, 0.0);
                }
                if (this.animationTick < 30) {
                    ++this.animationTick;
                }
            } else if (this.animationTick > 0) {
                this.animationTick = Math.max(this.animationTick - 2, 0);
            }
            this.xRotAnimation = MathHelper.func_76131_a((float)ModUtils.rotlerp(this.xRotAnimation, this.field_70125_A, 90.0f, false), (float)-180.0f, (float)180.0f);
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_175446_cd()) {
            if (!this.isRetreating() && this.func_204609_dp()) {
                this.setRetreating(true);
            } else if (this.isRetreating() && this.isStopRetreatTick()) {
                this.setRetreating(false);
            }
        }
        super.func_70636_d();
    }

    private boolean isStopRetreatTick() {
        float f;
        return this.field_70170_p.func_226690_K_() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c()) <= 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (0.6f - f) * 2.0f;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76440_q) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    private void summonPhantom(ServerWorld serverworld, LivingEntity attacker, LivingEntity target, Random random, int count) {
        boolean flag = false;
        for (int i = 0; i < count; ++i) {
            double d1 = attacker.func_226277_ct_() + (random.nextDouble() - random.nextDouble()) * 3.0;
            double d2 = attacker.func_226278_cu_() + 0.5;
            double d3 = attacker.func_226281_cx_() + (random.nextDouble() - random.nextDouble()) * 3.0;
            PhantomEntity phantomentity = (PhantomEntity)EntityType.field_203097_aH.func_200721_a(attacker.field_70170_p);
            phantomentity.func_70012_b(d1, d2, d3, this.field_70177_z + (random.nextFloat() - 0.5f) * 12.0f, 0.0f);
            phantomentity.func_213386_a((IServerWorld)serverworld, attacker.field_70170_p.func_175649_E(attacker.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            serverworld.func_242417_l((Entity)phantomentity);
            phantomentity.getPersistentData().func_74757_a("hmag.withSpawnParticle", true);
            if (!this.func_70027_ad()) continue;
            phantomentity.func_70015_d(this.func_223314_ad() / 20 + 2);
            flag = true;
        }
        if (flag) {
            this.func_70066_B();
        }
        attacker.field_70170_p.func_217379_c(2004, attacker.func_233580_cy_(), 0);
        attacker.func_184185_a((SoundEvent)ModSoundEvents.DYSSOMNIA_SUMMON.get(), 5.0f, 1.0f);
    }

    public static boolean checkDyssomniaSpawnRules(EntityType<DyssomniaEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return ModSpawnRules.checkMobSpawnInLightRules(type, worldIn, reason, pos, randomIn) && (reason == SpawnReason.SPAWNER || worldIn.func_226660_f_(pos) && randomIn.nextFloat() < worldIn.func_242413_ae());
    }

    public AttackPhase getAttackPhase() {
        return AttackPhase.byId(((Byte)this.field_70180_af.func_187225_a(ATTACK_PHASE)).byteValue());
    }

    private void setAttackPhase(AttackPhase phase) {
        this.field_70180_af.func_187227_b(ATTACK_PHASE, (Object)((byte)(phase.getId() & 0xFF)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackingTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACKING_TIME);
    }

    private void setAttackingTime(int value) {
        this.field_70180_af.func_187227_b(ATTACKING_TIME, (Object)value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getXRotAnimationScale(float f) {
        return MathHelper.func_219799_g((float)f, (float)(this.xRotAnimationO / 180.0f), (float)(this.xRotAnimation / 180.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float f) {
        return MathHelper.func_219799_g((float)f, (float)((float)this.animationTickO / 30.0f), (float)((float)this.animationTick / 30.0f));
    }

    public boolean isRetreating() {
        return (Boolean)this.field_70180_af.func_187225_a(RETREATING);
    }

    public void setRetreating(boolean flag) {
        this.field_70180_af.func_187227_b(RETREATING, (Object)flag);
    }

    public boolean isActuallyRetreating() {
        return this.isRetreating() && !this.func_104002_bU() && !this.func_213392_I();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setRetreating(compound.func_74767_n("isRetreating"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("isRetreating", this.isRetreating());
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.45f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.DYSSOMNIA_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.DYSSOMNIA_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.DYSSOMNIA_DEATH.get();
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static class RandomFlyGoal
    extends Goal {
        private final DyssomniaEntity parent;

        public RandomFlyGoal(DyssomniaEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parent.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parent.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parent.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parent.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parent.func_70681_au();
            BlockPos blockpos = new BlockPos(this.parent.func_226277_ct_(), (double)Math.round(this.parent.func_226278_cu_()), this.parent.func_226281_cx_());
            boolean flag = this.parent.isActuallyRetreating();
            double d0 = this.parent.func_226277_ct_();
            double d1 = this.parent.func_226278_cu_();
            double d2 = this.parent.func_226281_cx_();
            if (flag && this.parent.field_70170_p.func_226660_f_(blockpos) && blockpos.func_177956_o() < this.parent.field_70170_p.func_217301_I() + 64) {
                d0 += (double)((random.nextFloat() * 2.0f - 1.0f) * 8.0f);
                d1 += (double)(random.nextFloat() * 4.0f + 8.0f);
                d2 += (double)((random.nextFloat() * 2.0f - 1.0f) * 8.0f);
            } else {
                LivingEntity target;
                double distance;
                boolean flag1 = false;
                if (this.parent.func_70638_az() != null && (distance = (target = this.parent.func_70638_az()).func_70068_e((Entity)this.parent)) < 4096.0) {
                    Vector3d vector3d = target.func_174824_e(1.0f);
                    float f = random.nextFloat() * 2.0f;
                    float f1 = 4.0f + random.nextFloat() * 4.0f;
                    d0 = vector3d.field_72450_a + (double)(MathHelper.func_76134_b((float)(f * (float)Math.PI)) * f1);
                    d1 = vector3d.field_72448_b + 2.0 + random.nextDouble() * 2.0;
                    d2 = vector3d.field_72449_c + (double)(MathHelper.func_76126_a((float)(f * (float)Math.PI)) * f1);
                    flag1 = true;
                }
                if (!flag1) {
                    World world = this.parent.field_70170_p;
                    BlockPos.Mutable blockpos$mutable = blockpos.func_239590_i_();
                    boolean flag2 = false;
                    int i = 0;
                    while (world.func_175623_d((BlockPos)blockpos$mutable) && blockpos$mutable.func_177956_o() > 0) {
                        blockpos$mutable.func_189536_c(Direction.DOWN);
                        if (++i < 16) continue;
                        flag2 = true;
                        break;
                    }
                    d0 += (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    d1 += (double)(flag2 ? random.nextFloat() * -8.0f : (random.nextFloat() * 2.0f - 1.0f) * 8.0f);
                    d2 += (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                }
            }
            this.parent.func_70605_aq().func_75642_a(d0, d1, d2, flag ? 0.75 : 0.25);
        }
    }

    protected class LookHelperController
    extends LookController {
        public LookHelperController(MobEntity mob) {
            super(mob);
        }

        public void func_75649_a() {
        }
    }

    protected class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity mob) {
            super(mob);
        }

        public void func_75664_a() {
            DyssomniaEntity.this.field_70759_as = DyssomniaEntity.this.field_70761_aq;
            DyssomniaEntity.this.field_70761_aq = DyssomniaEntity.this.field_70177_z;
        }
    }

    protected class MoveHelperController
    extends MovementController {
        private final DyssomniaEntity parent;
        private int courseChangeCooldown;

        public MoveHelperController(DyssomniaEntity mob) {
            super((MobEntity)mob);
            this.parent = mob;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parent.func_70681_au().nextInt(5) + 5;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parent.func_226277_ct_(), this.field_75647_c - this.parent.func_226278_cu_(), this.field_75644_d - this.parent.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (ModUtils.canReach((LivingEntity)this.parent, vector3d = vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.parent.func_213317_d(this.parent.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }
    }

    private static class LookAroundGoal
    extends Goal {
        private final DyssomniaEntity parent;

        public LookAroundGoal(DyssomniaEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parent.func_70638_az() == null || this.parent.isActuallyRetreating() && this.parent.getAttackPhase() == AttackPhase.WAIT) {
                Vector3d vector3d = this.parent.func_213322_ci().func_72432_b();
                double d0 = vector3d.field_72450_a;
                double d1 = vector3d.field_72449_c;
                double d2 = Math.sqrt(d0 * d0 + d1 * d1);
                this.parent.field_70761_aq = this.parent.field_70177_z = -((float)MathHelper.func_181159_b((double)d0, (double)d1)) * 57.295776f;
                this.parent.field_70125_A = MathHelper.func_76131_a((float)((float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)d2) * 57.2957763671875)), (float)-45.0f, (float)45.0f);
            } else {
                LivingEntity target = this.parent.func_70638_az();
                if (target.func_70068_e((Entity)this.parent) < 4096.0) {
                    double d0 = target.func_226277_ct_() - this.parent.func_226277_ct_();
                    double d1 = target.func_226278_cu_() + (double)target.func_70047_e();
                    double d2 = target.func_226281_cx_() - this.parent.func_226281_cx_();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    this.parent.field_70761_aq = this.parent.field_70177_z = -((float)MathHelper.func_181159_b((double)d0, (double)d2)) * 57.295776f;
                    this.parent.field_70125_A = MathHelper.func_76131_a((float)(-((float)(MathHelper.func_181159_b((double)(this.parent.func_226278_cu_() - d1), (double)d3) * 57.2957763671875))), (float)-45.0f, (float)45.0f);
                }
            }
        }
    }

    private static class ShotAttackGoal
    extends Goal {
        private final DyssomniaEntity parent;
        public int attackTimer;

        public ShotAttackGoal(DyssomniaEntity mob) {
            this.parent = mob;
        }

        public boolean func_75250_a() {
            return this.parent.func_70638_az() != null && this.parent.getAttackPhase() == AttackPhase.WAIT && this.parent.func_70068_e((Entity)this.parent.func_70638_az()) < 576.0;
        }

        public boolean func_75253_b() {
            return this.parent.func_70638_az() != null && this.parent.getAttackPhase() == AttackPhase.SHOT;
        }

        public void func_75249_e() {
            this.attackTimer = -50;
            this.parent.setAttackPhase(AttackPhase.SHOT);
        }

        public void func_75251_c() {
            this.parent.setAttackingTime(-1);
            this.parent.setAttackPhase(AttackPhase.WAIT);
        }

        public void func_75246_d() {
            LivingEntity target = this.parent.func_70638_az();
            double d0 = 32.0;
            if ((target.func_70068_e((Entity)this.parent) < d0 * d0 || this.attackTimer > 10) && this.parent.func_70685_l((Entity)target)) {
                World world = this.parent.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 30) {
                    double d1 = 1.75;
                    double d2 = 1.5;
                    Vector3d vector3d = this.parent.func_70676_i(1.0f);
                    double d3 = target.func_226277_ct_() - (this.parent.func_226277_ct_() + vector3d.field_72450_a * d1);
                    double d4 = target.func_226283_e_(0.5) - (this.parent.func_226280_cw_() - vector3d.field_72448_b * d2);
                    double d5 = target.func_226281_cx_() - (this.parent.func_226281_cx_() + vector3d.field_72449_c * d1);
                    if (!this.parent.func_174814_R()) {
                        world.func_217378_a((PlayerEntity)null, 1024, this.parent.func_233580_cy_(), 0);
                    }
                    float f = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) * 0.02f;
                    MagicBulletEntity magicbulletentity = new MagicBulletEntity(world, (LivingEntity)this.parent, d3 + this.parent.func_70681_au().nextGaussian() * (double)f, d4, d5 + this.parent.func_70681_au().nextGaussian() * (double)f);
                    magicbulletentity.func_70107_b(this.parent.func_226277_ct_() + vector3d.field_72450_a * d1, this.parent.func_226280_cw_() - vector3d.field_72448_b * d2, this.parent.func_226281_cx_() + vector3d.field_72449_c * d1);
                    magicbulletentity.setDamage(5.0f);
                    magicbulletentity.setEffectLevel((byte)1);
                    magicbulletentity.setVariant(1);
                    world.func_217376_c((Entity)magicbulletentity);
                    this.parent.setAttackPhase(AttackPhase.WAIT);
                }
            } else {
                --this.attackTimer;
                if (this.attackTimer <= -60) {
                    this.parent.setAttackPhase(AttackPhase.WAIT);
                }
            }
            this.parent.setAttackingTime(this.attackTimer < 0 ? -1 : this.attackTimer);
        }
    }

    private static class SummonGoal
    extends Goal {
        private final DyssomniaEntity parent;
        public int attackTimer;
        private final EntityPredicate phantomCountTargeting = new EntityPredicate().func_221013_a(32.0).func_221014_c().func_221010_e().func_221008_a();

        public SummonGoal(DyssomniaEntity mob) {
            this.parent = mob;
        }

        public boolean func_75250_a() {
            if (!this.parent.isRetreating() && this.parent.func_70638_az() != null && this.parent.func_70638_az() instanceof PlayerEntity && this.parent.getAttackPhase() == AttackPhase.WAIT && (this.parent.func_70681_au().nextInt(6) == 0 || this.parent.func_70027_ad()) && this.parent.func_70068_e((Entity)this.parent.func_70638_az()) < 256.0) {
                return this.parent.field_70170_p.func_217374_a(PhantomEntity.class, this.phantomCountTargeting, (LivingEntity)this.parent, this.parent.func_174813_aQ().func_186662_g(32.0)).size() < 1;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.parent.func_70638_az() != null && this.parent.func_70638_az() instanceof PlayerEntity && this.parent.getAttackPhase() == AttackPhase.SUMMON;
        }

        public void func_75249_e() {
            this.attackTimer = -30;
            this.parent.setAttackPhase(AttackPhase.SUMMON);
        }

        public void func_75251_c() {
            this.parent.setAttackingTime(-1);
            this.parent.setAttackPhase(AttackPhase.WAIT);
        }

        public void func_75246_d() {
            LivingEntity target = this.parent.func_70638_az();
            double d0 = 32.0;
            if ((target.func_70068_e((Entity)this.parent) < d0 * d0 || this.attackTimer > 10) && this.parent.func_70685_l((Entity)target)) {
                World world = this.parent.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 20) {
                    this.parent.summonPhantom((ServerWorld)world, (LivingEntity)this.parent, target, this.parent.func_70681_au(), 1 + this.parent.func_70681_au().nextInt(this.parent.field_70170_p.func_175659_aa() == Difficulty.HARD ? 3 : 2));
                    this.parent.setAttackPhase(AttackPhase.WAIT);
                }
            } else {
                --this.attackTimer;
                if (this.attackTimer <= -40) {
                    this.parent.setAttackPhase(AttackPhase.WAIT);
                }
            }
            this.parent.setAttackingTime(this.attackTimer < 0 ? -1 : this.attackTimer);
        }
    }

    public static enum AttackPhase {
        WAIT(0),
        SUMMON(1),
        SHOT(2);

        private final int id;
        private static final AttackPhase[] BY_ID;

        private AttackPhase(int idIn) {
            this.id = idIn;
        }

        public int getId() {
            return this.id;
        }

        public static AttackPhase byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (AttackPhase[])Arrays.stream(AttackPhase.values()).sorted(Comparator.comparingInt(AttackPhase::getId)).toArray(AttackPhase[]::new);
        }
    }
}

