/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IBeamAttackMob;
import com.github.mechalopa.hmag.entity.IModMob;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EnderExecutorEntity
extends EndermanEntity
implements IModMob,
IBeamAttackMob {
    private static final DataParameter<Integer> ATTACKING_TIME = EntityDataManager.func_187226_a(EnderExecutorEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_TARGET = EntityDataManager.func_187226_a(EnderExecutorEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private LivingEntity targetedEntity;
    private int clientAttackTime;

    public EnderExecutorEntity(EntityType<? extends EnderExecutorEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 25;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKING_TIME, (Object)-20);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return EndermanEntity.func_234287_m_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && !this.func_175446_cd() && this.field_70170_p.func_175659_aa().func_151525_a() > 1 && ModConfigs.cachedServer.ENDER_EXECUTOR_BEAM_ATTACK) {
                LivingEntity target = this.func_70638_az();
                if (target != null && target.func_70089_S()) {
                    double d0 = this.func_70068_e((Entity)target);
                    if (this.func_70685_l((Entity)target) && d0 > 1.0 && d0 <= 576.0) {
                        int i = this.getAttackingTime();
                        if (++i == 0) {
                            this.setAttackingTime(i);
                            this.setActiveAttackTarget(target.func_145782_y());
                        } else if (i >= this.getAttackDuration()) {
                            if (this.getActiveAttackTarget() != null && this.attackEntityWithBeamAttack(this.getActiveAttackTarget(), 6.0f) && this.field_70146_Z.nextInt(10) == 0) {
                                this.func_70820_n();
                            }
                            this.setAttackingTime(-(10 + this.field_70146_Z.nextInt(6)));
                            this.setActiveAttackTarget(0);
                        } else {
                            this.setAttackingTime(i);
                        }
                    } else {
                        this.setAttackingTime(-20);
                        this.setActiveAttackTarget(0);
                    }
                } else {
                    this.setAttackingTime(-20);
                }
            }
        } else if (this.func_70089_S() && this.hasActiveAttackTarget()) {
            LivingEntity target;
            if (this.clientAttackTime < this.getAttackDuration()) {
                ++this.clientAttackTime;
            }
            if ((target = this.getActiveAttackTarget()) != null) {
                this.func_70671_ap().func_75651_a((Entity)target, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
            }
        } else {
            this.clientAttackTime = 0;
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        float f = amount;
        if (ModConfigs.cachedServer.ENDER_EXECUTOR_REDUCE_DAMAGE && (source.func_76346_g() == null || !source.func_180136_u()) && source != DamageSource.field_76380_i && f > 10.0f) {
            if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                f = 10.0f + (f - 10.0f) * 0.25f;
            } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                f = 10.0f + (f - 10.0f) * 0.1f;
            }
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.func_70820_n()) continue;
                return true;
            }
            return false;
        }
        return super.func_70097_a(source, f);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null) {
            this.setActiveAttackTarget(0);
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData ilivingentitydata = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151052_q));
        return ilivingentitydata;
    }

    public int func_70641_bl() {
        return 1;
    }

    public int getAttackingTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACKING_TIME);
    }

    private void setAttackingTime(int value) {
        this.field_70180_af.func_187227_b(ATTACKING_TIME, (Object)value);
    }

    public boolean func_213373_a(double x, double y, double z, boolean flag) {
        if (super.func_213373_a(x, y, z, flag)) {
            if (this.hasActiveAttackTarget()) {
                this.setActiveAttackTarget(0);
            }
            return true;
        }
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (ATTACK_TARGET.equals(key)) {
            this.clientAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    @Override
    public int getAttackDuration() {
        return 40;
    }

    @Override
    public boolean attackEntityWithBeamAttack(LivingEntity target, float damage) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), SoundEvents.field_190021_aL, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f);
        }
        float f = damage;
        if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            f += 2.0f;
        }
        return target.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this), f);
    }

    @Override
    public void setActiveAttackTarget(int entityId) {
        this.field_70180_af.func_187227_b(ATTACK_TARGET, (Object)entityId);
    }

    @Override
    public boolean hasActiveAttackTarget() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TARGET) != 0;
    }

    @Override
    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @Override
    public float getAttackAnimationScale(float f) {
        return ((float)this.clientAttackTime + f) / (float)this.getAttackDuration();
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

