/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.entity.goal.MeleeAttackGoal2;
import com.github.mechalopa.hmag.entity.goal.RangedAttackGoal2;
import com.github.mechalopa.hmag.entity.projectile.MagmaBulletEntity;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class FortressKeeperEntity
extends MonsterEntity
implements IModMob,
IRangedAttackMob {
    private static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(FortressKeeperEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private float attackAnimation;
    private float attackAnimationO;
    private float attackHandChangeAnimation;
    private float attackHandChangeAnimationO;

    public FortressKeeperEntity(EntityType<? extends FortressKeeperEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 15;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal2((CreatureEntity)this, 1.2, false, 0.6666667f, 4.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new RangedAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233824_g_, 2.0).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233820_c_, 0.75);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.attackAnimationO = this.attackAnimation;
            this.attackHandChangeAnimationO = this.attackHandChangeAnimation;
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.attackAnimation = this.isRangedAttacking() ? Math.min(1.0f, this.attackAnimation + 0.15f) : Math.max(0.0f, this.attackAnimation - 0.08f);
            this.attackHandChangeAnimation = this.isOffHandRangedAttack() ? Math.min(1.0f, this.attackHandChangeAnimation + 0.05f) : Math.max(0.0f, this.attackHandChangeAnimation - 0.05f);
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 16 == 0 && !this.func_82150_aj() && !this.func_203005_aq() && this.field_70733_aJ <= 0.2f) {
            double d0 = this.func_226278_cu_() + 2.625;
            if (this.attackAnimation <= 0.0f || this.attackHandChangeAnimation >= 1.0f ^ !this.func_184638_cS()) {
                float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * (0.75f + (this.func_70681_au().nextFloat() - 0.5f) * 0.75f);
                float f1 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))) * (0.75f + (this.func_70681_au().nextFloat() - 0.5f) * 0.75f);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + (double)f, d0 - this.func_70681_au().nextDouble() * (double)0.1f, this.func_226281_cx_() + (double)f1, 0.0, 0.0, 0.0);
            }
            if (this.attackAnimation <= 0.0f || this.attackHandChangeAnimation <= 0.0f ^ !this.func_184638_cS()) {
                float f2 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * (0.75f + (this.func_70681_au().nextFloat() - 0.5f) * 0.75f);
                float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))) * (0.75f + (this.func_70681_au().nextFloat() - 0.5f) * 0.75f);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() - (double)f2, d0 - this.func_70681_au().nextDouble() * (double)0.1f, this.func_226281_cx_() - (double)f3, 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 0));
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76352_a() || source.func_82725_o() || source.func_76347_k() || ModUtils.isThornsDamage(source)) {
            amount *= 0.5f;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 0.5625f;
        float f1 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 0.5625f;
        if (this.isOffHandRangedAttack() ^ !this.func_184638_cS()) {
            f *= -1.0f;
            f1 *= -1.0f;
        }
        Vector3d vector3d = this.func_70676_i(1.0f);
        f = (float)((double)f + vector3d.field_72450_a * 1.25);
        f1 = (float)((double)f1 + vector3d.field_72449_c * 1.25);
        double d0 = target.func_226277_ct_() - (this.func_226277_ct_() + (double)f);
        double d1 = target.func_226278_cu_() + (double)target.func_70047_e() * 0.5 - (this.func_226278_cu_() + 0.75);
        double d2 = target.func_226281_cx_() - (this.func_226281_cx_() + (double)f1);
        float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        MagmaBulletEntity bulletentity = new MagmaBulletEntity(this.field_70170_p, (LivingEntity)this, d0 + this.func_70681_au().nextGaussian() * (double)(f2 * 0.01f), d1 + (double)(f2 * 0.08f), d2 + this.func_70681_au().nextGaussian() * (double)(f2 * 0.01f));
        bulletentity.func_70107_b(bulletentity.func_226277_ct_() + (double)f, this.func_226278_cu_() + 0.75, bulletentity.func_226281_cx_() + (double)f1);
        bulletentity.setDamage(4.0f);
        this.field_70170_p.func_217376_c((Entity)bulletentity);
        for (int i = 0; i < 8; ++i) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, bulletentity.func_226277_ct_(), bulletentity.func_226278_cu_(), bulletentity.func_226281_cx_(), 1, this.func_70681_au().nextGaussian() * 0.05, 0.005, this.func_70681_au().nextGaussian() * 0.05, 0.0);
        }
        if (!this.func_203005_aq()) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197595_F, bulletentity.func_226277_ct_(), bulletentity.func_226278_cu_(), bulletentity.func_226281_cx_(), 8, 0.0, 0.0, 0.0, 0.0);
        }
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187789_eW, this.func_184176_by(), 2.0f, (this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        }
        if (this.func_70681_au().nextInt(3) == 0) {
            this.setOffHandRangedAttack(!this.isOffHandRangedAttack());
        }
    }

    public int func_70641_bl() {
        return 2;
    }

    public int func_70646_bf() {
        return 30;
    }

    public int func_184649_cE() {
        return 30;
    }

    public double func_70033_W() {
        return -0.1;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.74f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            this.attackAnimation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isRangedAttacking() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setRangedAttacking(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)(flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isOffHandRangedAttack() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 2) != 0;
    }

    public void setOffHandRangedAttack(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)(flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setOffHandRangedAttack(compound.func_74767_n("isOffHandRangedAttack"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("isOffHandRangedAttack", this.isOffHandRangedAttack());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float f) {
        return MathHelper.func_219799_g((float)f, (float)this.attackAnimationO, (float)this.attackAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackHandChangeAnimationScale(float f) {
        return MathHelper.func_219799_g((float)f, (float)this.attackHandChangeAnimationO, (float)this.attackHandChangeAnimation);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.DOLL_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.DOLL_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.DOLL_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_232765_iv_, 0.5f, 0.25f);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class RangedAttackGoal
    extends RangedAttackGoal2 {
        public RangedAttackGoal(IRangedAttackMob mob) {
            super(mob, 0.9, 40, 60, 9.0f, 4.0f, false);
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            FortressKeeperEntity.this.setRangedAttacking(false);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            FortressKeeperEntity attacker = FortressKeeperEntity.this;
            if (this.getAttackTime() >= 0 && this.getAttackTime() <= 20) {
                if (!attacker.isRangedAttacking()) {
                    attacker.setRangedAttacking(true);
                }
            } else if (attacker.isRangedAttacking() && (attacker.func_70092_e(this.getTarget().func_226277_ct_(), this.getTarget().func_226278_cu_(), this.getTarget().func_226281_cx_()) > 256.0 || !attacker.func_70635_at().func_75522_a((Entity)this.getTarget()))) {
                attacker.setRangedAttacking(false);
            }
        }
    }
}

