/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.util.ModUtils;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class GhastlySeekerEntity
extends FlyingEntity
implements IMob,
IModMob {
    private static final DataParameter<Integer> ATTACKING_TIME = EntityDataManager.func_187226_a(GhastlySeekerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int explosionPower = 1;

    public GhastlySeekerEntity(EntityType<? extends GhastlySeekerEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 25;
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FireballAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, p -> Math.abs(p.func_226278_cu_() - this.func_226278_cu_()) <= 10.0));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING_TIME, (Object)-1);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 3 == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.8, this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        super.func_70636_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isAttacking() {
        return this.getAttackingTime() > 10;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackingTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACKING_TIME);
    }

    private void setAttackingTime(int value) {
        this.field_70180_af.func_187227_b(ATTACKING_TIME, (Object)value);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76364_f() != null && source.func_76364_f() instanceof FireballEntity && source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity) {
            return super.func_70097_a(source, amount * 2.0f);
        }
        return super.func_70097_a(source, amount);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    public static boolean checkGhastlySeekerSpawnRules(EntityType<GhastlySeekerEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && randomIn.nextDouble() < ModConfigs.cachedServer.GHASTLY_SEEKER_SPAWN_CHANCE && MobEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ExplosionPower", this.explosionPower);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ExplosionPower", 99)) {
            this.explosionPower = compound.func_74762_e("ExplosionPower");
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static class RandomFlyGoal
    extends Goal {
        private final GhastlySeekerEntity parent;

        public RandomFlyGoal(GhastlySeekerEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parent.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parent.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parent.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parent.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            LivingEntity target;
            double distance;
            Random random = this.parent.func_70681_au();
            boolean flag = false;
            if (this.parent.func_70638_az() != null && (distance = (target = this.parent.func_70638_az()).func_70068_e((Entity)this.parent)) < 4096.0 && distance > 256.0) {
                Vector3d vector3d = target.func_174824_e(1.0f);
                this.parent.func_70605_aq().func_75642_a(vector3d.field_72450_a + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f), vector3d.field_72448_b - 1.0, vector3d.field_72449_c + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f), 0.75);
                flag = true;
            }
            if (!flag) {
                double d0 = this.parent.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d1 = this.parent.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d2 = this.parent.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.parent.func_70605_aq().func_75642_a(d0, d1, d2, 0.75);
            }
        }
    }

    protected class MoveHelperController
    extends MovementController {
        private final GhastlySeekerEntity parent;
        private int courseChangeCooldown;

        public MoveHelperController(GhastlySeekerEntity mob) {
            super((MobEntity)mob);
            this.parent = mob;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parent.func_70681_au().nextInt(5) + 2;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parent.func_226277_ct_(), this.field_75647_c - this.parent.func_226278_cu_(), this.field_75644_d - this.parent.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (ModUtils.canReach((LivingEntity)this.parent, vector3d = vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.parent.func_213317_d(this.parent.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }
    }

    private static class LookAroundGoal
    extends Goal {
        private final GhastlySeekerEntity parent;

        public LookAroundGoal(GhastlySeekerEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parent.func_70638_az() == null) {
                Vector3d vector3d = this.parent.func_213322_ci();
                this.parent.field_70761_aq = this.parent.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity target = this.parent.func_70638_az();
                if (target.func_70068_e((Entity)this.parent) < 4096.0) {
                    double d0 = target.func_226277_ct_() - this.parent.func_226277_ct_();
                    double d1 = target.func_226281_cx_() - this.parent.func_226281_cx_();
                    this.parent.field_70761_aq = this.parent.field_70177_z = -((float)MathHelper.func_181159_b((double)d0, (double)d1)) * 57.295776f;
                }
            }
        }
    }

    private static class FireballAttackGoal
    extends Goal {
        private final GhastlySeekerEntity parent;
        public int attackTimer;

        public FireballAttackGoal(GhastlySeekerEntity mob) {
            this.parent = mob;
        }

        public boolean func_75250_a() {
            return this.parent.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parent.setAttackingTime(-1);
        }

        public void func_75246_d() {
            LivingEntity target = this.parent.func_70638_az();
            double d0 = 24.0;
            if ((target.func_70068_e((Entity)this.parent) < d0 * d0 || this.attackTimer > 10) && this.parent.func_70685_l((Entity)target)) {
                World world = this.parent.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 10 && !this.parent.func_174814_R()) {
                    world.func_217378_a((PlayerEntity)null, 1015, this.parent.func_233580_cy_(), 0);
                }
                if (this.attackTimer == 20) {
                    double d1 = 4.0;
                    Vector3d vector3d = this.parent.func_70676_i(1.0f);
                    double d2 = target.func_226277_ct_() - (this.parent.func_226277_ct_() + vector3d.field_72450_a * d1);
                    double d3 = target.func_226278_cu_() + (double)target.func_70047_e() * 0.5 - this.parent.func_226283_e_(0.5) + 0.25;
                    double d4 = target.func_226281_cx_() - (this.parent.func_226281_cx_() + vector3d.field_72449_c * d1);
                    if (!this.parent.func_174814_R()) {
                        world.func_217378_a((PlayerEntity)null, 1016, this.parent.func_233580_cy_(), 0);
                    }
                    FireballEntity fireballentity = new FireballEntity(world, (LivingEntity)this.parent, d2, d3, d4);
                    fireballentity.field_92057_e = this.parent.getExplosionPower();
                    fireballentity.func_70107_b(this.parent.func_226277_ct_() + vector3d.field_72450_a * 0.5, this.parent.func_226283_e_(0.5) + 0.25, fireballentity.func_226281_cx_() + vector3d.field_72449_c * 0.5);
                    world.func_217376_c((Entity)fireballentity);
                    this.attackTimer = -50;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parent.setAttackingTime(this.attackTimer < 0 ? -1 : this.attackTimer);
        }
    }
}

