/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.entity.AbstractFlyingMonsterEntity;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModUtils;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class GhostEntity
extends AbstractFlyingMonsterEntity
implements IModMob {
    private static final DataParameter<Integer> DATA_VARIANT_ID = EntityDataManager.func_187226_a(GhostEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public GhostEntity(EntityType<? extends GhostEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_VARIANT_ID, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AbstractFlyingMonsterEntity.ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new AbstractFlyingMonsterEntity.MoveRandomGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 18.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void func_70636_d() {
        ModUtils.burnInDay((LivingEntity)this, this.func_70681_au(), this.func_204609_dp(), this.shouldBurnInDay(), 8);
        super.func_70636_d();
    }

    protected boolean shouldBurnInDay() {
        return true;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.func_70681_au().nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        float f = this.func_70681_au().nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            switch (this.func_70681_au().nextInt(3)) {
                case 0: {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151010_B));
                    break;
                }
                case 1: {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151006_E));
                    break;
                }
                case 2: {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151011_C));
                }
            }
        } else {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 4 && i == 1 && this.func_70681_au().nextFloat() < 0.5f) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151013_M));
            }
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_98053_h(this.func_70681_au().nextFloat() < 0.55f * difficultyIn.func_180170_c());
        this.setVariant(this.func_70681_au().nextInt(5));
        this.func_180481_a(difficultyIn);
        this.func_180483_b(difficultyIn);
        if (this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.func_70681_au().nextFloat() < 0.25f) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)(this.func_70681_au().nextFloat() < 0.1f ? Blocks.field_196628_cT : Blocks.field_196625_cS)));
                this.field_184655_bs[EquipmentSlotType.HEAD.func_188454_b()] = 0.0f;
            }
        }
        return spawnDataIn;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_VARIANT_ID);
    }

    private void setVariant(int typeIn) {
        if (typeIn < 0 || typeIn >= 5) {
            typeIn = this.func_70681_au().nextInt(5);
        }
        this.field_70180_af.func_187227_b(DATA_VARIANT_ID, (Object)typeIn);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.GHOST_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.GHOST_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.GHOST_DEATH.get();
    }
}

