/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class KashaEntity
extends MonsterEntity
implements IModMob {
    private static final UUID ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("7DDA541D-ABAA-BBF4-D099-AAC57D64ADA9");
    private static final AttributeModifier ATTACK_DAMAGE_MODIFIER = new AttributeModifier(ATTACK_DAMAGE_MODIFIER_UUID, "Soul variant attack damage bonus", 1.0, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Integer> DATA_VARIANT_ID = EntityDataManager.func_187226_a(KashaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public KashaEntity(EntityType<? extends KashaEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 12;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_VARIANT_ID, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
        this.field_70714_bg.func_75776_a(4, (Goal)new OcelotAttackGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8, 0.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        if (ModConfigs.cachedServer.KASHA_ATTACK_CHICKENS) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ChickenEntity.class, false));
        }
        if (ModConfigs.cachedServer.KASHA_ATTACK_BABY_HOGLINS) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, HoglinEntity.class, 10, false, false, p -> p.func_70631_g_()));
        }
        if (ModConfigs.cachedServer.KASHA_ATTACK_VILLAGERS) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        }
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        if (ModConfigs.cachedServer.KASHA_ATTACK_BABY_TURTLES) {
            this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, false, false, TurtleEntity.field_203029_bx));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.325).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233824_g_, 1.0);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 10 == 0) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_() + 0.25, this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            if (this.field_70173_aa % 2 == 0) {
                this.field_70170_p.func_195594_a((IParticleData)(this.getVariant() == Variant.SOUL ? ParticleTypes.field_239811_B_ : ParticleTypes.field_197631_x), this.func_226282_d_(0.75), this.func_226279_cv_() - 0.1, this.func_226287_g_(0.75), 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 5;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    entityIn.func_70015_d(i);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_230270_dK_() {
        return true;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_235714_a_((ITag)BlockTags.field_232880_av_)) {
            this.setVariant(Variant.SOUL);
        } else {
            this.setVariant(Variant.NORMAL);
        }
        return spawnDataIn;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_70180_af.func_187225_a(DATA_VARIANT_ID));
    }

    private void setVariant(Variant variant) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(Attributes.field_233823_f_).func_111124_b(ATTACK_DAMAGE_MODIFIER);
            if (variant == Variant.SOUL) {
                this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(ATTACK_DAMAGE_MODIFIER);
            }
        }
        this.field_70180_af.func_187227_b(DATA_VARIANT_ID, (Object)variant.getId());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(Variant.byId(compound.func_74762_e("Variant")));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant().getId());
    }

    public int func_70641_bl() {
        return 3;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public double func_70033_W() {
        return 0.14;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.KASHA_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.KASHA_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.KASHA_DEATH.get();
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Variant {
        NORMAL(0),
        SOUL(1);

        private final int id;
        private static final Variant[] BY_ID;

        private Variant(int idIn) {
            this.id = idIn;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

