/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class MeltyMonsterEntity
extends MonsterEntity
implements IModMob,
IRangedAttackMob {
    public MeltyMonsterEntity(EntityType<? extends MeltyMonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 15;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, StriderEntity.class, 10.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveToLavaGoal(this, 1.5));
        this.field_70714_bg.func_75776_a(5, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 30, 40, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, p -> !(p.func_184187_bx() instanceof StriderEntity)));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233821_d_, 0.18);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && !this.func_70026_G()) {
            if (this.field_70173_aa % 5 == 0) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.5, this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            if (this.field_70173_aa % 10 == 1) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.5, this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && ModConfigs.cachedServer.MELTY_MONSTER_SET_FIRE && !this.func_180799_ab() && !this.func_203008_ap() && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)this.func_226278_cu_());
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            for (int l = 0; l < 4; ++l) {
                i = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_226278_cu_()), k = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (!this.field_70170_p.func_175623_d(blockpos)) continue;
                this.field_70170_p.func_175656_a(blockpos, AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)blockpos));
            }
        }
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        double d1 = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = target.func_226278_cu_() + (double)target.func_70047_e() * 0.5 - this.func_226283_e_(0.5);
        double d3 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.02f;
        SmallFireballEntity fireballentity = new SmallFireballEntity(this.field_70170_p, (LivingEntity)this, d1 + this.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)f);
        fireballentity.func_70107_b(fireballentity.func_226277_ct_(), this.func_226283_e_(0.5) + 0.5, fireballentity.func_226281_cx_());
        this.field_70170_p.func_217376_c((Entity)fireballentity);
        this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public static boolean checkMeltyMonsterSpawnRules(EntityType<MeltyMonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
        do {
            blockpos$mutable.func_189536_c(Direction.UP);
        } while (worldIn.func_204610_c((BlockPos)blockpos$mutable).func_206884_a((ITag)FluidTags.field_206960_b));
        return worldIn.func_180495_p((BlockPos)blockpos$mutable).func_196958_f() && (reason == SpawnReason.SPAWNER || pos.func_177956_o() < 32 || randomIn.nextBoolean());
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_230285_a_(Fluid fluidIn) {
        return fluidIn.func_207185_a((ITag)FluidTags.field_206960_b);
    }

    protected void func_184231_a(double d0, boolean onGround, BlockState blockstate, BlockPos pos) {
        this.func_145775_I();
        if (this.func_180799_ab()) {
            this.field_70143_R = 0.0f;
        } else {
            super.func_184231_a(d0, onGround, blockstate, pos);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.floatMob();
        this.func_145775_I();
    }

    private void floatMob() {
        if (this.func_180799_ab()) {
            ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
            if (iselectioncontext.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_(), true) && !this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.field_70122_E = true;
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, 0.05, 0.0));
            }
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new LavaPathNavigator(this, worldIn);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (worldIn.func_180495_p(pos).func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b)) {
            return 10.0f;
        }
        return this.func_180799_ab() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public int func_70641_bl() {
        return 2;
    }

    public double func_70033_W() {
        return -0.45;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.74f;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187762_di;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187760_dh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187758_dg;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187764_dj, 0.15f, 1.0f);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static class MoveToLavaGoal
    extends MoveToBlockGoal {
        private final MeltyMonsterEntity parent;

        private MoveToLavaGoal(MeltyMonsterEntity mob, double d0) {
            super((CreatureEntity)mob, d0, 8, 2);
            this.parent = mob;
        }

        public BlockPos func_241846_j() {
            return this.field_179494_b;
        }

        public boolean func_75253_b() {
            return !this.parent.func_180799_ab() && this.func_179488_a((IWorldReader)this.parent.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            return !this.parent.func_180799_ab() && super.func_75250_a();
        }

        protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
            return world.func_180495_p(pos).func_203425_a(Blocks.field_150353_l) && world.func_180495_p(pos.func_177984_a()).func_196957_g((IBlockReader)world, pos, PathType.LAND);
        }
    }

    private static class LavaPathNavigator
    extends GroundPathNavigator {
        public LavaPathNavigator(MeltyMonsterEntity mob, World worldIn) {
            super((MobEntity)mob, worldIn);
        }

        protected PathFinder func_179679_a(int i) {
            this.field_179695_a = new WalkNodeProcessor();
            return new PathFinder(this.field_179695_a, i);
        }

        protected boolean func_230287_a_(PathNodeType pathNodeTypeIn) {
            return pathNodeTypeIn != PathNodeType.LAVA && pathNodeTypeIn != PathNodeType.DAMAGE_FIRE && pathNodeTypeIn != PathNodeType.DANGER_FIRE ? super.func_230287_a_(pathNodeTypeIn) : true;
        }

        public boolean func_188555_b(BlockPos pos) {
            return this.field_75513_b.func_180495_p(pos).func_203425_a(Blocks.field_150353_l) || super.func_188555_b(pos);
        }
    }
}

