/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IBeamAttackMob;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.registry.ModParticleTypes;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;

public class MonolithEntity
extends FlyingEntity
implements IMob,
IModMob,
IBeamAttackMob {
    private static final DataParameter<Byte> ATTACK_PHASE = EntityDataManager.func_187226_a(MonolithEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> ATTACK_TARGET = EntityDataManager.func_187226_a(MonolithEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private LivingEntity targetedEntity;
    private int clientAttackTime;
    private int eyeCloseTimer = 0;

    public MonolithEntity(EntityType<? extends MonolithEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 15;
        this.field_70765_h = new MoveHelperController(this);
    }

    protected BodyController func_184650_s() {
        return new BodyHelperController((MobEntity)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RoarAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BeamAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookTargetGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAroundGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, false, (Predicate)new TargetPredicate(this)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_PHASE, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.16).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.75).func_233815_a_(Attributes.field_233819_b_, 24.0);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S()) {
                AttackPhase phase = this.getAttackPhase();
                if (phase == AttackPhase.BEAM_END || phase == AttackPhase.ROAR_END) {
                    ++this.eyeCloseTimer;
                    if (this.eyeCloseTimer >= 10) {
                        this.setAttackPhase(AttackPhase.WAIT);
                        this.eyeCloseTimer = 0;
                    }
                } else {
                    this.eyeCloseTimer = 0;
                }
            }
        } else if (this.func_70089_S()) {
            if (this.hasActiveAttackTarget()) {
                LivingEntity target;
                if (this.clientAttackTime < this.getAttackDuration()) {
                    ++this.clientAttackTime;
                }
                if ((target = this.getActiveAttackTarget()) != null) {
                    this.func_70671_ap().func_75651_a((Entity)target, 90.0f, 90.0f);
                    this.func_70671_ap().func_75649_a();
                }
            } else {
                this.clientAttackTime = 0;
            }
            if (this.getAttackPhase().isBeamAttack()) {
                double d0 = this.func_226282_d_(1.5);
                double d1 = this.func_226279_cv_() - 0.25;
                double d2 = this.func_226287_g_(1.5);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239819_as_, d0, d1, d2, (d0 - this.func_226277_ct_()) * -0.025, (d1 - (this.func_226283_e_(0.5) - 0.25)) * -0.025, (d2 - this.func_226281_cx_()) * -0.025);
            } else if (this.getAttackPhase().isRoarAttack()) {
                for (int i = 0; i < 8; ++i) {
                    double d0 = this.func_226282_d_(1.5);
                    double d1 = this.func_226279_cv_() - 0.25;
                    double d2 = this.func_226287_g_(1.5);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, (d0 - this.func_226277_ct_()) * 0.2, (d1 - (this.func_226283_e_(0.5) - 0.25)) * 0.2, (d2 - this.func_226281_cx_()) * 0.2);
                }
            } else if (this.field_70173_aa % 12 == 0) {
                this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.ENCHANTMENT_RUNE.get(), this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), (this.func_70681_au().nextDouble() - 0.5) * 2.0, this.func_70681_au().nextDouble() - 0.25, (this.func_70681_au().nextDouble() - 0.5) * 2.0);
            }
        } else {
            this.clientAttackTime = 0;
        }
        super.func_70636_d();
    }

    public AttackPhase getAttackPhase() {
        return AttackPhase.byId(((Byte)this.field_70180_af.func_187225_a(ATTACK_PHASE)).byteValue());
    }

    private void setAttackPhase(AttackPhase phase) {
        this.field_70180_af.func_187227_b(ATTACK_PHASE, (Object)((byte)(phase.getId() & 0xFF)));
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack stack;
        if (source.func_76352_a() || source.func_76347_k() || source.func_82725_o() || ModUtils.isThornsDamage(source)) {
            amount *= 0.5f;
        } else if (source instanceof EntityDamageSource && source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity && !(stack = ((LivingEntity)source.func_76346_g()).func_184614_ca()).func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b().func_150897_b(Blocks.field_150348_b.func_176223_P())) {
            amount *= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u || potioneffectIn.func_188419_a() == Effects.field_76440_q) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (reason == SpawnReason.NATURAL) {
            Vector3d vector3d = this.func_213322_ci();
            this.func_213317_d(new Vector3d(vector3d.field_72450_a, 0.05, vector3d.field_72449_c));
        }
        return spawnDataIn;
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null) {
            this.setActiveAttackTarget(0);
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    public float func_70013_c() {
        return MathHelper.func_76131_a((float)(super.func_70013_c() + 0.8f), (float)0.0f, (float)1.0f);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.DOLL_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.DOLL_DEATH.get();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.0f;
    }

    public static boolean checkMonolithSpawnRules(EntityType<MonolithEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        if (worldIn.func_175659_aa() != Difficulty.PEACEFUL && MonolithEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn)) {
            if (ModUtils.isDarkEnoughToSpawn(worldIn, pos, randomIn)) {
                return true;
            }
            ServerWorld world = worldIn.func_201672_e();
            if (world instanceof ServerWorld && world.func_241112_a_().func_235010_a_(pos, true, Structure.field_236379_o_).func_75069_d()) {
                return true;
            }
        }
        return false;
    }

    public int func_70641_bl() {
        return 3;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (ATTACK_TARGET.equals(key)) {
            this.clientAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 15) {
            for (int i = 0; i < 32; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(1.0), this.func_226279_cv_() - 0.25, this.func_226287_g_(1.0), this.func_70681_au().nextGaussian() * 0.2, this.func_70681_au().nextGaussian() * 0.2, this.func_70681_au().nextGaussian() * 0.2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public int getAttackDuration() {
        return 60;
    }

    @Override
    public boolean attackEntityWithBeamAttack(LivingEntity target, float damage) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), SoundEvents.field_190021_aL, this.func_184176_by(), 1.0f, this.func_70681_au().nextFloat() * 0.2f + 0.9f);
        }
        float f = damage;
        int i = 0;
        if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
            i = 5;
        } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            f += 2.0f;
            i = 10;
        }
        boolean flag = target.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this), f);
        boolean flag1 = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
        if (flag || flag1) {
            if (i > 0) {
                int j = this.func_70681_au().nextInt(3);
                target.func_195064_c(new EffectInstance(j == 2 ? Effects.field_76437_t : (j == 1 ? Effects.field_76421_d : Effects.field_76419_f), i * 20, 0));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setActiveAttackTarget(int entityId) {
        this.field_70180_af.func_187227_b(ATTACK_TARGET, (Object)entityId);
    }

    @Override
    public boolean hasActiveAttackTarget() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TARGET) != 0;
    }

    @Override
    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @Override
    public float getAttackAnimationScale(float f) {
        return ((float)this.clientAttackTime + f) / (float)this.getAttackDuration();
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static class RoarTargetPredicate
    implements Predicate<LivingEntity> {
        private RoarTargetPredicate() {
        }

        @Override
        public boolean test(@Nullable LivingEntity livingEntityIn) {
            return livingEntityIn.func_70089_S() && !(livingEntityIn instanceof MonolithEntity);
        }
    }

    private static class TargetPredicate
    implements Predicate<LivingEntity> {
        private final MonolithEntity parent;

        public TargetPredicate(MonolithEntity mob) {
            this.parent = mob;
        }

        @Override
        public boolean test(@Nullable LivingEntity livingEntityIn) {
            if (livingEntityIn instanceof MonolithEntity) {
                return false;
            }
            if (this.parent.func_70643_av() != null && this.parent.func_70643_av().equals((Object)livingEntityIn) && (livingEntityIn.func_200600_R() != EntityType.field_200729_aH || !this.parent.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_))) {
                return livingEntityIn.func_70068_e((Entity)this.parent) <= 81.0;
            }
            if (ModTags.checkTagContains(ModTags.MONOLITH_TARGET_BLACKLIST, livingEntityIn.func_200600_R())) {
                return false;
            }
            if (livingEntityIn instanceof PlayerEntity || livingEntityIn instanceof GolemEntity && ModConfigs.cachedServer.MONOLITH_ATTACK_GOLEMS || livingEntityIn instanceof AbstractVillagerEntity && ModConfigs.cachedServer.MONOLITH_ATTACK_VILLAGERS || livingEntityIn.func_70668_bt() == CreatureAttribute.field_223225_d_ && ModConfigs.cachedServer.MONOLITH_ATTACK_ILLAGERS) {
                return livingEntityIn.func_70068_e((Entity)this.parent) <= 81.0;
            }
            return false;
        }
    }

    private static class RandomFlyGoal
    extends Goal {
        private final MonolithEntity parent;

        public RandomFlyGoal(MonolithEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.parent.func_70605_aq().func_75640_a() && this.parent.getAttackPhase().isWait() && this.parent.func_70681_au().nextFloat() < 0.01f;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parent.func_70681_au();
            double d0 = this.parent.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 3.0f);
            double d1 = this.parent.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 3.0f);
            double d2 = this.parent.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 3.0f);
            this.parent.func_70605_aq().func_75642_a(d0, d1, d2, 0.15);
        }
    }

    protected class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity mob) {
            super(mob);
        }

        public void func_75664_a() {
            MonolithEntity.this.field_70759_as = MonolithEntity.this.field_70761_aq;
            MonolithEntity.this.field_70761_aq = MonolithEntity.this.field_70177_z;
        }
    }

    protected class MoveHelperController
    extends MovementController {
        private final MonolithEntity parent;

        public MoveHelperController(MonolithEntity mob) {
            super((MobEntity)mob);
            this.parent = mob;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parent.func_226277_ct_(), this.field_75647_c - this.parent.func_226278_cu_(), this.field_75644_d - this.parent.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (d0 < this.parent.func_174813_aQ().func_72320_b() || !ModUtils.canReach((LivingEntity)this.parent, vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parent.func_213317_d(this.parent.func_213322_ci().func_186678_a(0.5));
                } else {
                    float f = (float)this.parent.func_233637_b_(Attributes.field_233821_d_);
                    this.parent.func_213317_d(this.parent.func_213322_ci().func_178787_e(vector3d.func_186678_a((double)((float)this.field_75645_e * f) * 0.2 / d0)));
                }
            }
        }
    }

    private static class LookAroundGoal
    extends Goal {
        private final MonolithEntity parent;
        private double lookX;
        private double lookZ;
        private int idleTime;

        public LookAroundGoal(MonolithEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.parent.func_70681_au().nextFloat() < 0.008f;
        }

        public boolean func_75253_b() {
            return this.idleTime >= 0;
        }

        public void func_75249_e() {
            double d0 = Math.PI * 2 * this.parent.func_70681_au().nextDouble();
            this.lookX = Math.cos(d0);
            this.lookZ = Math.sin(d0);
            this.idleTime = 20 + this.parent.func_70681_au().nextInt(20);
        }

        public void func_75246_d() {
            --this.idleTime;
            this.parent.field_70761_aq = this.parent.field_70177_z = -((float)MathHelper.func_181159_b((double)this.lookX, (double)this.lookZ)) * 57.295776f;
        }
    }

    private static class LookTargetGoal
    extends Goal {
        private final MonolithEntity parent;

        public LookTargetGoal(MonolithEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity target = this.parent.func_70638_az();
            return target != null && target.func_70068_e((Entity)this.parent) < 4096.0;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75246_d() {
            LivingEntity target = this.parent.func_70638_az();
            if (target != null && target.func_70068_e((Entity)this.parent) < 4096.0) {
                double d0 = target.func_226277_ct_() - this.parent.func_226277_ct_();
                double d1 = target.func_226281_cx_() - this.parent.func_226281_cx_();
                this.parent.field_70761_aq = this.parent.field_70177_z = -((float)MathHelper.func_181159_b((double)d0, (double)d1)) * 57.295776f;
            }
        }
    }

    private static class BeamAttackGoal
    extends Goal {
        private final MonolithEntity parent;
        private int tickCounter;

        public BeamAttackGoal(MonolithEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.parent.func_70638_az() != null && this.parent.func_70638_az().func_70089_S() && this.parent.getAttackPhase().isWait();
        }

        public boolean func_75253_b() {
            if (this.parent.func_70638_az() != null && this.parent.func_70638_az().func_70089_S()) {
                double d0 = this.parent.func_70068_e((Entity)this.parent.func_70638_az());
                return d0 > 4.0 && d0 <= 100.0;
            }
            return false;
        }

        public void func_75249_e() {
            this.tickCounter = -20;
            this.parent.setAttackPhase(AttackPhase.BEAM_CHARGE);
        }

        public void func_75251_c() {
            this.parent.setActiveAttackTarget(0);
            this.parent.func_70624_b(null);
            this.parent.setAttackPhase(AttackPhase.BEAM_END);
        }

        public void func_75246_d() {
            LivingEntity target = this.parent.func_70638_az();
            if (target == null || !this.parent.func_70685_l((Entity)target)) {
                this.parent.setAttackPhase(AttackPhase.BEAM_END);
                this.parent.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter >= -5 && this.tickCounter < 0 && this.parent.getAttackPhase() != AttackPhase.BEAM_CHARGE2) {
                    this.parent.setAttackPhase(AttackPhase.BEAM_CHARGE2);
                } else if (this.tickCounter == 0) {
                    this.parent.setAttackPhase(AttackPhase.BEAM_ATTACK);
                    this.parent.func_184185_a(SoundEvents.field_191244_bn, 1.0f, 1.0f);
                    this.parent.setActiveAttackTarget(target.func_145782_y());
                    if (this.parent.func_70681_au().nextFloat() < 0.4f) {
                        Vector3d vector3d = target.func_174824_e(1.0f);
                        this.parent.func_70605_aq().func_75642_a(vector3d.field_72450_a + (double)((this.parent.func_70681_au().nextFloat() * 2.0f - 1.0f) * 3.0f), vector3d.field_72448_b - (double)(0.5f + this.parent.func_70681_au().nextFloat()), vector3d.field_72449_c + (double)((this.parent.func_70681_au().nextFloat() * 2.0f - 1.0f) * 3.0f), 0.2);
                    }
                } else if (this.tickCounter >= this.parent.getAttackDuration()) {
                    if (this.parent.getActiveAttackTarget() != null) {
                        this.parent.attackEntityWithBeamAttack(this.parent.getActiveAttackTarget(), 1.0f);
                    }
                    this.parent.setAttackPhase(AttackPhase.BEAM_END);
                    this.parent.func_70624_b(null);
                }
            }
        }
    }

    private static class RoarAttackGoal
    extends Goal {
        private final MonolithEntity parent;
        private int tickCounter;

        public RoarAttackGoal(MonolithEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.parent.func_70638_az() != null && this.parent.func_70638_az().func_70089_S() && this.parent.getAttackPhase().isWait() && this.parent.getAttackPhase() != AttackPhase.ROAR_END) {
                return this.parent.func_70068_e((Entity)this.parent.func_70638_az()) <= 9.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (this.parent.func_70638_az() != null && this.parent.func_70638_az().func_70089_S() && this.parent.getAttackPhase().isRoarAttack()) {
                return this.parent.func_70068_e((Entity)this.parent.func_70638_az()) < 4096.0;
            }
            return false;
        }

        public void func_75249_e() {
            this.tickCounter = -5;
            this.parent.setAttackPhase(AttackPhase.ROAR_CHARGE);
        }

        public void func_75251_c() {
            this.parent.setAttackPhase(AttackPhase.ROAR_END);
        }

        public void func_75246_d() {
            LivingEntity target = this.parent.func_70638_az();
            if (target == null || !this.parent.func_70685_l((Entity)target)) {
                this.parent.setAttackPhase(AttackPhase.ROAR_END);
                this.parent.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.parent.func_184185_a(SoundEvents.field_191244_bn, 1.0f, 1.0f);
                    this.parent.setAttackPhase(AttackPhase.ROAR_ATTACK);
                } else if (this.tickCounter >= 15) {
                    for (LivingEntity livingentity : this.parent.field_70170_p.func_175647_a(LivingEntity.class, this.parent.func_174813_aQ().func_186662_g(2.0), (Predicate)new RoarTargetPredicate())) {
                        if (livingentity instanceof PlayerEntity && (((PlayerEntity)livingentity).func_184812_l_() || ((PlayerEntity)livingentity).func_175149_v())) continue;
                        float f = 3.0f;
                        int i = 0;
                        if (this.parent.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                            i = 7;
                        } else if (this.parent.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                            f += 2.0f;
                            i = 12;
                        }
                        if (i > 0) {
                            livingentity.func_195064_c(new EffectInstance(Effects.field_76440_q, i * 10, 0));
                            livingentity.func_195064_c(new EffectInstance(Effects.field_76419_f, i * 20, 1));
                            livingentity.func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 1));
                            livingentity.func_195064_c(new EffectInstance(Effects.field_76437_t, i * 20, 1));
                        }
                        livingentity.func_233627_a_(1.5f, this.parent.func_226277_ct_() - livingentity.func_226277_ct_(), this.parent.func_226281_cx_() - livingentity.func_226281_cx_());
                        livingentity.func_70097_a(DamageSource.func_76354_b((Entity)this.parent, (Entity)this.parent), f);
                    }
                    this.parent.func_184185_a(SoundEvents.field_187789_eW, 1.0f, (this.parent.func_70681_au().nextFloat() - this.parent.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                    this.parent.field_70170_p.func_72960_a((Entity)this.parent, (byte)15);
                    Vector3d vector3d = this.parent.func_213322_ci();
                    Vector3d vector3d1 = new Vector3d(target.func_226277_ct_() - this.parent.func_226277_ct_(), 0.0, target.func_226281_cx_() - this.parent.func_226281_cx_()).func_72432_b().func_186678_a(0.25);
                    this.parent.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
                    this.parent.setAttackPhase(AttackPhase.ROAR_END);
                }
            }
        }
    }

    public static enum AttackPhase {
        WAIT(0, false, false),
        BEAM_CHARGE(1, true, false),
        BEAM_CHARGE2(2, true, false),
        BEAM_ATTACK(3, true, false),
        BEAM_END(4, false, false),
        ROAR_CHARGE(5, false, true),
        ROAR_ATTACK(6, false, true),
        ROAR_END(7, false, false);

        private final int id;
        private final boolean isBeam;
        private final boolean isRoar;
        private static final AttackPhase[] BY_ID;

        private AttackPhase(int idIn, boolean isBeamIn, boolean isRoarIn) {
            this.id = idIn;
            this.isBeam = isBeamIn;
            this.isRoar = isRoarIn;
        }

        public int getId() {
            return this.id;
        }

        public boolean isWait() {
            return !this.isBeamAttack() && !this.isRoarAttack();
        }

        public boolean isBeamAttack() {
            return this.isBeam;
        }

        public boolean isRoarAttack() {
            return this.isRoar;
        }

        public static AttackPhase byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (AttackPhase[])Arrays.stream(AttackPhase.values()).sorted(Comparator.comparingInt(AttackPhase::getId)).toArray(AttackPhase[]::new);
        }
    }
}

