/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class OgreEntity
extends MonsterEntity
implements IModMob {
    private static final DataParameter<Boolean> IS_ARM_SWING = EntityDataManager.func_187226_a(OgreEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int armSwingTimer;
    private float attackAnimation;
    private float attackAnimationO;

    public OgreEntity(EntityType<? extends OgreEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 25;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackAndDestroyGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        if (ModConfigs.cachedServer.OGRE_ATTACK_VILLAGERS) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        }
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        if (ModConfigs.cachedServer.OGRE_ATTACK_BABY_TURTLES) {
            this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_ARM_SWING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.285).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233824_g_, 2.0).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.attackAnimationO = this.attackAnimation;
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.attackAnimation = this.isArmSwinging() ? Math.min(1.0f, this.attackAnimation + 0.45f) : Math.max(0.0f, this.attackAnimation - 0.08f);
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = false;
            if (this.armSwingTimer > 0) {
                flag = true;
            }
            if (this.isArmSwinging() != flag) {
                this.setArmSwinging(flag);
            }
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.armSwingTimer > 0) {
            --this.armSwingTimer;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.armSwingTimer = 3;
        if (super.func_70652_k(entityIn)) {
            this.playArmSwingSound();
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 5;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 3));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d || source == DamageSource.field_191291_g || ModUtils.isThornsDamage(source)) {
            amount *= 0.25f;
            if (!this.func_175446_cd() && this.func_70681_au().nextInt(8) == 0) {
                this.destroyBlock();
            }
        } else if (source.func_76352_a() || source.func_94541_c() || source.func_76347_k() || source == DamageSource.field_76379_h || source == DamageSource.field_82729_p) {
            amount *= 0.5f;
        }
        return super.func_70097_a(source, amount);
    }

    public int func_70641_bl() {
        return 1;
    }

    public double func_70033_W() {
        return -0.6;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.5f;
    }

    public boolean isArmSwinging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ARM_SWING);
    }

    public void setArmSwinging(boolean flag) {
        this.field_70180_af.func_187227_b(IS_ARM_SWING, (Object)flag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationScale(float f) {
        return MathHelper.func_219799_g((float)f, (float)this.attackAnimationO, (float)this.attackAnimation);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.OGRE_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.OGRE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.OGRE_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.25f, 1.0f);
    }

    protected void playArmSwingSound() {
        this.func_184185_a(SoundEvents.field_187929_hc, 0.5f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    protected boolean destroyBlock() {
        if (ModConfigs.cachedServer.OGRE_DESTROY_BLOCKS && this.field_70170_p.func_175659_aa().func_151525_a() > 1 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            int i1 = MathHelper.func_76128_c((double)this.func_226278_cu_());
            int l1 = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int i2 = MathHelper.func_76128_c((double)this.func_226281_cx_());
            boolean flag = false;
            for (int k2 = -1; k2 <= 1; ++k2) {
                for (int l2 = -1; l2 <= 1; ++l2) {
                    for (int j = 0; j <= 3; ++j) {
                        int i3 = l1 + k2;
                        int k = i1 + j;
                        int l = i2 + l2;
                        BlockPos blockpos = new BlockPos(i3, k, l);
                        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                        if (!this.canDestroyBlock(blockstate.func_177230_c(), blockstate, this.field_70170_p, blockpos, (LivingEntity)this, 5.0f)) continue;
                        flag = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || flag;
                    }
                }
            }
            if (flag) {
                this.armSwingTimer = 5;
                this.playArmSwingSound();
            }
            return flag;
        }
        return false;
    }

    private boolean canDestroyBlock(Block blockIn, BlockState stateIn, World worldIn, BlockPos pos, LivingEntity entityIn, float maxHardness) {
        if (ModTags.checkTagContains(ModTags.OGRE_IMMUNE, blockIn) || blockIn.isAir(stateIn, (IBlockReader)worldIn, pos) || stateIn.func_185904_a().func_76224_d() || !blockIn.canEntityDestroy(stateIn, (IBlockReader)worldIn, pos, (Entity)entityIn)) {
            return false;
        }
        float f = stateIn.func_185887_b((IBlockReader)worldIn, pos);
        return f >= 0.0f && f <= maxHardness && f / maxHardness <= this.func_70681_au().nextFloat() + 0.05f && this.func_70681_au().nextBoolean();
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class MeleeAttackAndDestroyGoal
    extends MeleeAttackGoal {
        public MeleeAttackAndDestroyGoal(OgreEntity mob, double speedIn, boolean useLongMemory) {
            super((CreatureEntity)mob, speedIn, useLongMemory);
        }

        protected void func_190102_a(LivingEntity attackTarget, double distToEnemySqr) {
            double d0 = this.func_179512_a(attackTarget);
            if (this.func_234041_j_() <= 0) {
                if (distToEnemySqr <= d0) {
                    this.func_234039_g_();
                    this.field_75441_b.func_184609_a(Hand.MAIN_HAND);
                    this.field_75441_b.func_70652_k((Entity)attackTarget);
                } else if ((distToEnemySqr < 100.0 && !this.field_75441_b.func_70635_at().func_75522_a((Entity)attackTarget) || distToEnemySqr < 9.0) && this.field_75441_b.func_70681_au().nextInt(12) == 0) {
                    OgreEntity.this.destroyBlock();
                }
            }
        }
    }
}

