/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.entity.goal.MeleeAttackGoal2;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class SavagefangEntity
extends MonsterEntity
implements IModMob {
    private static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(SavagefangEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private SavagefangEntity leader;
    private int schoolSize = 1;
    private int leapCooldown;
    private float xRotAnimation;
    private float xRotAnimationO;
    private float attackAnimation;
    private float attackAnimationO;

    public SavagefangEntity(EntityType<? extends SavagefangEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new LookHelperController(this);
        this.field_70728_aV = 3;
        this.leapCooldown = 0;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new LeapGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal(this, 1.0, 20));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowSchoolLeaderGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, false, (Predicate)new TargetPredicate(this)).func_190882_b(30));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 3.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.handleAirSupply(i);
    }

    protected void handleAirSupply(int airSupply) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.func_70050_g(airSupply - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public void func_70071_h_() {
        List list;
        if (this.field_70170_p.field_72995_K) {
            if (this.isLaunched()) {
                this.xRotAnimation = 0.0f;
            }
            this.attackAnimationO = this.attackAnimation;
            this.xRotAnimationO = this.xRotAnimation;
        }
        super.func_70071_h_();
        if (this.hasFollowers() && this.field_70170_p.field_73012_v.nextInt(200) == 1 && (list = this.field_70170_p.func_217357_a(this.getClass(), this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
        if (this.field_70170_p.field_72995_K) {
            if (!this.isLaunched()) {
                this.xRotAnimation = MathHelper.func_76131_a((float)ModUtils.rotlerp(this.xRotAnimation, this.field_70125_A, 90.0f, false), (float)-180.0f, (float)180.0f);
            }
            this.attackAnimation = this.isAttacking() ? Math.min(1.0f, this.attackAnimation + 0.25f) : Math.max(0.0f, this.attackAnimation - 0.08f);
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && !this.isLaunched()) {
                if (!this.isAttacking()) {
                    this.setAttacking(true);
                }
                if (this.leapCooldown > 0) {
                    --this.leapCooldown;
                }
            } else {
                if (this.isAttacking()) {
                    this.setAttacking(false);
                }
                this.leapCooldown = 0;
            }
        }
        if (!this.func_70090_H()) {
            if (this.func_233570_aj_() && this.field_70124_G) {
                float f = this.isLaunched() ? 0.2f : 0.4f;
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * f), (double)(this.isLaunched() ? 0.4f : 0.6f), (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * f)));
                this.field_70122_E = false;
                this.field_70160_al = true;
                this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
                if (!(this.func_175446_cd() || this.func_70681_au().nextInt(8) != 0 && this.func_70086_ai() > 100)) {
                    this.setLaunched(true);
                }
            }
        } else if (this.isLaunched()) {
            this.setLaunched(false);
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            if (!(this.field_70170_p.field_72995_K || this.func_175446_cd() || this.func_70090_H() || this.isLaunched())) {
                this.setLaunched(true);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (spawnDataIn == null) {
            spawnDataIn = new GroupData(this);
        } else {
            this.startFollowing(((GroupData)spawnDataIn).leader);
        }
        this.leapCooldown = 0;
        return spawnDataIn;
    }

    public void func_213352_e(Vector3d vector3dIn) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, vector3dIn);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(vector3dIn);
        }
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) ? 10.0f + worldIn.func_205052_D(pos) - 0.5f : super.func_205022_a(pos, worldIn);
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.65f;
    }

    public void setLeapCooldown(int value) {
        this.leapCooldown = value;
    }

    public int getLeapCooldown() {
        return this.leapCooldown;
    }

    public boolean isLaunched() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setLaunched(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)(flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isAttacking() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 2) != 0;
    }

    public void setAttacking(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)(flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setLaunched(compound.func_74767_n("isLaunched"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("isLaunched", this.isLaunched());
    }

    public int func_70641_bl() {
        return 8;
    }

    public static boolean checkSavagefangSpawnRules(EntityType<? extends SavagefangEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && SavagefangEntity.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) && (reason == SpawnReason.SPAWNER || pos.func_177956_o() >= worldIn.func_181545_F() - 10 && worldIn.func_175710_j(pos) && randomIn.nextDouble() < ModConfigs.cachedServer.SAVAGEFANG_SPAWN_CHANCE);
    }

    public int getMaxSchoolSize() {
        return 5;
    }

    protected boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.func_70089_S();
    }

    public SavagefangEntity startFollowing(SavagefangEntity mob) {
        this.leader = mob;
        mob.addFollower();
        return mob;
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.func_70068_e((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower() && this.func_70638_az() == null) {
            this.func_70661_as().func_75497_a((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<SavagefangEntity> stream) {
        stream.limit(this.getMaxSchoolSize() - this.schoolSize).filter(p -> p != this).forEach(p -> p.startFollowing(this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getXRotAnimationScale(float f) {
        return MathHelper.func_219799_g((float)f, (float)(this.xRotAnimationO / 180.0f), (float)(this.xRotAnimation / 180.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float f) {
        return MathHelper.func_219799_g((float)f, (float)this.attackAnimationO, (float)this.attackAnimation);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public int func_70627_aG() {
        return 120;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203818_az;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 15) {
            Vector3d vector3d1 = this.func_70676_i(0.0f);
            for (int i = 0; i < 12; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226282_d_(0.5) - vector3d1.field_72450_a * 1.0, this.func_226279_cv_() - vector3d1.field_72448_b * 1.0, this.func_226287_g_(0.5) - vector3d1.field_72449_c * 1.0, 0.0, 0.0, 0.0);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static class TargetPredicate
    implements Predicate<LivingEntity> {
        private final SavagefangEntity parent;

        public TargetPredicate(SavagefangEntity mob) {
            this.parent = mob;
        }

        @Override
        public boolean test(@Nullable LivingEntity livingEntityIn) {
            if (this.parent.isLaunched() || ModTags.checkTagContains(ModTags.SAVAGEFANG_TARGET_BLACKLIST, livingEntityIn.func_200600_R()) || livingEntityIn instanceof SavagefangEntity) {
                return false;
            }
            if (livingEntityIn instanceof PlayerEntity || livingEntityIn.func_70668_bt() != CreatureAttribute.field_203100_e && !livingEntityIn.func_70648_aU() && livingEntityIn instanceof AnimalEntity && ModConfigs.cachedServer.SAVAGEFANG_ATTACK_ANIMALS || livingEntityIn instanceof AbstractVillagerEntity && ModConfigs.cachedServer.SAVAGEFANG_ATTACK_VILLAGERS || livingEntityIn.func_70668_bt() == CreatureAttribute.field_223225_d_ && ModConfigs.cachedServer.SAVAGEFANG_ATTACK_ILLAGERS) {
                return livingEntityIn.func_70068_e((Entity)this.parent) <= 16.0 || livingEntityIn.func_203005_aq() && livingEntityIn.func_70068_e((Entity)this.parent) <= 81.0;
            }
            if (!(livingEntityIn instanceof FlyingEntity) && ModConfigs.cachedServer.SAVAGEFANG_ATTACK_DAMAGED_MOBS) {
                return livingEntityIn.func_203005_aq() && livingEntityIn.func_70068_e((Entity)this.parent) <= 81.0 && (livingEntityIn.func_110143_aJ() < 10.0f && livingEntityIn.func_110143_aJ() < livingEntityIn.func_110138_aP() || livingEntityIn.func_110143_aJ() < livingEntityIn.func_110138_aP() * 0.25f);
            }
            return false;
        }
    }

    private static class FollowSchoolLeaderGoal
    extends Goal {
        private final SavagefangEntity mob;
        private int timeToRecalcPath;
        private int nextStartTick;

        public FollowSchoolLeaderGoal(SavagefangEntity mob) {
            this.mob = mob;
            this.nextStartTick = this.nextStartTick(mob);
        }

        protected int nextStartTick(SavagefangEntity mob) {
            return 200 + mob.func_70681_au().nextInt(200) % 20;
        }

        public boolean func_75250_a() {
            if (this.mob.func_70638_az() != null) {
                return false;
            }
            if (this.mob.hasFollowers()) {
                return false;
            }
            if (this.mob.isFollower()) {
                return true;
            }
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick(this.mob);
            Predicate<SavagefangEntity> predicate = p -> p.canBeFollowed() || !p.isFollower();
            List list = this.mob.field_70170_p.func_175647_a(this.mob.getClass(), this.mob.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), predicate);
            SavagefangEntity monsterentity = list.stream().filter(SavagefangEntity::canBeFollowed).findAny().orElse(this.mob);
            monsterentity.addFollowers(list.stream().filter(p -> !p.isFollower()));
            return this.mob.isFollower();
        }

        public boolean func_75253_b() {
            return this.mob.func_70638_az() == null && this.mob.isFollower() && this.mob.inRangeOfLeader();
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
        }

        public void func_75251_c() {
            this.mob.stopFollowing();
        }

        public void func_75246_d() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 30;
                this.mob.pathToLeader();
            }
        }
    }

    private static class SwimGoal
    extends RandomSwimmingGoal {
        private final SavagefangEntity mob;

        public SwimGoal(SavagefangEntity mob, double speed, int interval) {
            super((CreatureEntity)mob, speed, interval);
            this.mob = mob;
        }

        public boolean func_75250_a() {
            return this.mob.canRandomSwim() && super.func_75250_a();
        }
    }

    private static class LeapGoal
    extends Goal {
        private final SavagefangEntity mob;
        private LivingEntity target;

        public LeapGoal(SavagefangEntity mob) {
            this.mob = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.mob.func_184207_aI() || this.mob.getLeapCooldown() > 0 || this.mob.isLaunched()) {
                return false;
            }
            this.target = this.mob.func_70638_az();
            if (this.target == null) {
                return false;
            }
            double d0 = this.mob.func_70068_e((Entity)this.target);
            if (!(d0 < 4.0) && !(d0 > 16.0)) {
                if (!this.mob.func_203005_aq()) {
                    return false;
                }
                return this.mob.func_70681_au().nextInt(4) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75249_e() {
            this.mob.setLeapCooldown(15 + this.mob.func_70681_au().nextInt(15));
            Vector3d vector3d = this.mob.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(this.target.func_226277_ct_() - this.mob.func_226277_ct_(), 0.0, this.target.func_226281_cx_() - this.mob.func_226281_cx_());
            if (vector3d1.func_189985_c() > 1.0E-7) {
                vector3d1 = vector3d1.func_72432_b().func_186678_a(0.25 + (double)(this.mob.func_70681_au().nextFloat() * 0.05f)).func_178787_e(vector3d.func_186678_a(0.5));
            }
            if (!this.target.func_203005_aq() || this.target.func_226278_cu_() + 1.0 > this.mob.func_226280_cw_() && this.mob.field_70170_p.func_175623_d(new BlockPos((double)this.mob.func_233580_cy_().func_177958_n(), (double)this.mob.func_233580_cy_().func_177956_o() + 1.0, (double)this.mob.func_233580_cy_().func_177952_p()))) {
                this.mob.func_213293_j(vector3d1.field_72450_a, 0.4 + (double)(this.mob.func_70681_au().nextFloat() * 0.2f), vector3d1.field_72449_c);
            } else {
                this.mob.func_213293_j(vector3d1.field_72450_a * 1.2, 0.05, vector3d1.field_72449_c * 1.2);
            }
            this.mob.func_70661_as().func_75499_g();
            FluidState fluidstate = this.mob.field_70170_p.func_204610_c(this.mob.func_233580_cy_());
            if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                this.mob.func_184185_a(SoundEvents.field_205209_aZ, 0.9f, 1.2f);
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)15);
            }
        }
    }

    private class AttackGoal
    extends MeleeAttackGoal2 {
        private final SavagefangEntity mob;

        public AttackGoal(SavagefangEntity mob) {
            super((CreatureEntity)mob, 1.5, false, 0.7f);
            this.mob = mob;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !this.mob.isLaunched();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && !this.mob.isLaunched();
        }

        protected int func_234042_k_() {
            return 10;
        }
    }

    protected class LookHelperController
    extends LookController {
        private final SavagefangEntity mob;

        public LookHelperController(SavagefangEntity mob) {
            super((MobEntity)mob);
            this.mob = mob;
        }

        public void func_75649_a() {
            if (!this.mob.isLaunched()) {
                Vector3d vector3d = this.mob.func_213322_ci();
                if (vector3d.func_189985_c() > 0.001) {
                    vector3d = vector3d.func_72432_b();
                    double d0 = vector3d.field_72450_a;
                    double d1 = vector3d.field_72449_c;
                    double d2 = Math.sqrt(d0 * d0 + d1 * d1);
                    this.mob.field_70125_A = MathHelper.func_76131_a((float)((float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)d2) * 57.2957763671875)), (float)-60.0f, (float)60.0f);
                } else {
                    this.mob.field_70125_A = 0.0f;
                }
            } else {
                this.mob.field_70125_A = 0.0f;
            }
            this.mob.field_70759_as = this.mob.field_70177_z;
        }
    }

    protected static class MoveHelperController
    extends MovementController {
        private final SavagefangEntity mob;

        public MoveHelperController(SavagefangEntity mob) {
            super((MobEntity)mob);
            this.mob = mob;
        }

        public void func_75641_c() {
            if (this.mob.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.mob.func_213317_d(this.mob.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.mob.func_70661_as().func_75500_f()) {
                float f = (float)(this.field_75645_e * this.mob.func_233637_b_(Attributes.field_233821_d_));
                this.mob.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.mob.func_70689_ay(), (float)f));
                double d0 = this.field_75646_b - this.mob.func_226277_ct_();
                double d1 = this.field_75647_c - this.mob.func_226278_cu_();
                double d2 = this.field_75644_d - this.mob.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                if (d1 != 0.0) {
                    this.mob.func_213317_d(this.mob.func_213322_ci().func_72441_c(0.0, (double)this.mob.func_70689_ay() * (d1 / d3) * 0.01, 0.0));
                }
                if (d3 >= (double)2.5E-7f) {
                    float f1 = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.mob.field_70761_aq = this.mob.field_70177_z = this.func_75639_a(this.mob.field_70177_z, f1, this.mob.func_70638_az() != null ? 90.0f : 30.0f);
                }
            } else {
                this.mob.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.mob.func_70689_ay(), (float)0.0f));
            }
        }
    }

    public static class GroupData
    implements ILivingEntityData {
        public final SavagefangEntity leader;

        public GroupData(SavagefangEntity mob) {
            this.leader = mob;
        }
    }
}

