/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.entity.MagicalSlimeEntity;
import com.github.mechalopa.hmag.entity.goal.LeapAtTargetGoal2;
import com.github.mechalopa.hmag.registry.ModEntityTypes;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class SlimeGirlEntity
extends MonsterEntity
implements IModMob {
    private static final DataParameter<Integer> DATA_VARIANT_ID = EntityDataManager.func_187226_a(SlimeGirlEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround;

    public SlimeGirlEntity(EntityType<? extends SlimeGirlEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 15;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_VARIANT_ID, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.19).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    public void func_70071_h_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.func_70071_h_();
        boolean flag = false;
        if (this.func_233570_aj_() && !this.wasOnGround) {
            if (this.field_70170_p.field_72995_K) {
                this.spawnParticle(12);
            }
            this.targetSquish = -0.5f;
            flag = true;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        if (this.field_70170_p.field_72995_K && !flag && this.field_70173_aa % 8 == 0 && this.func_70681_au().nextInt(3) == 0) {
            this.spawnParticle(1);
        }
        this.wasOnGround = this.func_233570_aj_();
        this.targetSquish *= 0.6f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticle(int count) {
        for (int j = 0; j < count; ++j) {
            float f = this.func_70681_au().nextFloat() * ((float)Math.PI * 2);
            float f1 = this.func_70681_au().nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * 0.6f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * 0.6f * f1;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70089_S() && ModConfigs.cachedServer.SLIME_GIRL_REGEN && this.func_203008_ap() && !this.func_70644_a(Effects.field_76428_l)) {
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 2));
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f);
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    public void remove(boolean keepData) {
        if (!this.field_70170_p.field_72995_K && ModConfigs.cachedServer.MAGICAL_SLIME_SPAWNS_ON_SLIME_GIRL_DEATH && this.func_233643_dh_() && !this.field_70128_L) {
            ITextComponent itextcomponent = this.func_200201_e();
            boolean flag = this.func_175446_cd();
            int i = 2;
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.func_70681_au().nextInt(3);
            for (int l = 0; l < k; ++l) {
                float f1 = ((float)(l % 2) - 0.5f) * f;
                float f2 = ((float)(l / 2) - 0.5f) * f;
                MagicalSlimeEntity slimeentity = (MagicalSlimeEntity)((EntityType)ModEntityTypes.MAGICAL_SLIME.get()).func_200721_a(this.field_70170_p);
                if (this.func_104002_bU()) {
                    slimeentity.func_110163_bv();
                }
                slimeentity.func_200203_b(itextcomponent);
                slimeentity.func_94061_f(flag);
                slimeentity.func_184224_h(this.func_190530_aW());
                slimeentity.func_70799_a(j, true);
                if (this.func_70681_au().nextInt(8) != 0) {
                    slimeentity.setVariant(this.getVariant());
                }
                slimeentity.func_70012_b(this.func_226277_ct_() + (double)f1, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + (double)f2, this.func_70681_au().nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)slimeentity);
            }
        }
        super.remove(keepData);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_82725_o() || source == DamageSource.field_76379_h) {
            amount *= 0.5f;
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.func_70681_au().nextInt(ColorVariant.values().length));
        return spawnDataIn;
    }

    public int func_70641_bl() {
        return 2;
    }

    public double func_70033_W() {
        return -0.45;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.74f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getColor() {
        return ColorVariant.byId(this.getVariant()).getColors();
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_VARIANT_ID);
    }

    private void setVariant(int typeIn) {
        if (typeIn < 0 || typeIn >= ColorVariant.values().length) {
            typeIn = this.func_70681_au().nextInt(ColorVariant.values().length);
        }
        this.field_70180_af.func_187227_b(DATA_VARIANT_ID, (Object)typeIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.wasOnGround = compound.func_74767_n("wasOnGround");
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187886_fs;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187888_ft, 0.15f, 1.0f);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class LeapGoal
    extends LeapAtTargetGoal2 {
        private final MobEntity mob;

        public LeapGoal(MobEntity mob) {
            super(mob, 0.25f, 0.3f, 6.0f, 6);
            this.mob = mob;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.mob.func_184185_a(SoundEvents.field_187882_fq, 1.0f, ((this.mob.func_70681_au().nextFloat() - this.mob.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 1.4f);
        }
    }

    public static enum ColorVariant {
        PINK1(0, 16678066),
        PINK2(1, 16608633),
        PINK3(2, 16143733),
        PINK4(3, 16732339),
        LIGHT_PINK1(4, 16225469),
        LIGHT_PINK2(5, 0xFF999D),
        DARK_PINK1(6, 16005289),
        DARK_PINK2(7, 14830776),
        PURPLE1(8, 13393626),
        PURPLE2(9, 13269976),
        LAVENDER(10, 12360685),
        WHITE1(11, 16766945),
        RED1(12, 0xF77272),
        RED2(13, 16605268),
        SLIME(14, 9489279),
        MINT(15, 7077059),
        BLACK(16, 0x3C3838),
        SLATEBLUE(17, 6970061),
        WHITE2(18, 16768685),
        DARK_RED1(19, 0x8B0000),
        DARK_RED2(20, 14423100),
        ORANGE(21, 16747520),
        BROWN(22, 9127187),
        GOLD(23, 16766720),
        DARK_KHAKI(24, 12433259),
        GREEN_YELLOW(25, 11403055),
        GREEN1(26, 7048739),
        GREEN2(27, 3050327),
        GREEN3(28, 6452328),
        BLUE(29, 8900331),
        TURQUOISE(30, 4251856),
        GRAY(31, 0x778899);

        private final int id;
        private final float[] colors;
        private static final ColorVariant[] BY_ID;

        private ColorVariant(int idIn, int colorIn) {
            this.id = idIn;
            int i = (colorIn & 0xFF0000) >> 16;
            int j = (colorIn & 0xFF00) >> 8;
            int k = (colorIn & 0xFF) >> 0;
            this.colors = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        }

        public int getId() {
            return this.id;
        }

        public float[] getColors() {
            return this.colors;
        }

        public static ColorVariant byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (ColorVariant[])Arrays.stream(ColorVariant.values()).sorted(Comparator.comparingInt(ColorVariant::getId)).toArray(ColorVariant[]::new);
        }
    }
}

