/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.entity.goal.MeleeAttackGoal2;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpiderNestEntity
extends MonsterEntity
implements IModMob {
    private static final DataParameter<Integer> SUMMON_DELAY = EntityDataManager.func_187226_a(SpiderNestEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public SpiderNestEntity(EntityType<? extends SpiderNestEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 15;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackAndSummonGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMON_DELAY, (Object)60);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.175).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.75);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239813_am_, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.func_70681_au().nextDouble() - 0.5) * 3.0, -this.func_70681_au().nextDouble(), (this.func_70681_au().nextDouble() - 0.5) * 3.0);
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 20, 0));
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, i * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    public void remove(boolean keepData) {
        if (!this.field_70170_p.field_72995_K && ModConfigs.cachedServer.SPIDER_NEST_SUMMON_CAVE_SPIDER && !this.func_175446_cd() && this.func_233643_dh_() && !this.field_70128_L) {
            this.summonSpider((ServerWorld)this.field_70170_p, (LivingEntity)this, this.func_70638_az(), this.func_70681_au(), 2 + this.func_70681_au().nextInt(3));
        }
        super.remove(keepData);
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (!state.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76352_a() || source.func_94541_c() || ModUtils.isThornsDamage(source)) {
            amount *= 0.5f;
        } else if (source.func_76347_k()) {
            amount *= 1.5f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    private void summonSpider(ServerWorld serverworld, LivingEntity attacker, LivingEntity target, Random random, int count) {
        for (int i = 0; i < count; ++i) {
            double d1 = attacker.func_226277_ct_() + (random.nextDouble() - random.nextDouble()) * 1.5;
            double d2 = attacker.func_226278_cu_() + 0.5;
            double d3 = attacker.func_226281_cx_() + (random.nextDouble() - random.nextDouble()) * 1.5;
            CaveSpiderEntity cavespiderentity = (CaveSpiderEntity)EntityType.field_200794_h.func_200721_a(attacker.field_70170_p);
            cavespiderentity.func_70012_b(d1, d2, d3, random.nextFloat() * 360.0f, 0.0f);
            cavespiderentity.func_213386_a((IServerWorld)serverworld, attacker.field_70170_p.func_175649_E(attacker.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            serverworld.func_242417_l((Entity)cavespiderentity);
            if (target != null && target.func_70089_S()) {
                cavespiderentity.func_70624_b(target);
            }
            cavespiderentity.getPersistentData().func_74757_a("hmag.withSpawnParticle", true);
        }
        attacker.field_70170_p.func_217379_c(2004, attacker.func_233580_cy_(), 0);
        attacker.func_184185_a((SoundEvent)ModSoundEvents.SPIDER_NEST_SUMMON.get(), 1.0f, 1.0f);
    }

    public int func_70641_bl() {
        return 2;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.1f;
    }

    public int func_70646_bf() {
        return 30;
    }

    public int func_184649_cE() {
        return 30;
    }

    public boolean isCharging() {
        return this.getSummonDelay() <= 20;
    }

    public int getSummonDelay() {
        return (Integer)this.field_70180_af.func_187225_a(SUMMON_DELAY);
    }

    private void setSummonDelay(int value) {
        this.field_70180_af.func_187227_b(SUMMON_DELAY, (Object)value);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Delay", this.getSummonDelay());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSummonDelay(compound.func_74765_d("Delay"));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.SPIDER_NEST_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.SPIDER_NEST_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.SPIDER_NEST_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class MeleeAttackAndSummonGoal
    extends MeleeAttackGoal2 {
        private final int summonInterval;
        private final float summonRadius;
        private final int maxSpawn;
        private final EntityPredicate caveSpiderCountTargeting;

        public MeleeAttackAndSummonGoal(SpiderNestEntity mob) {
            this(mob, 1.0, false, 120, 10.0f, 2);
        }

        public MeleeAttackAndSummonGoal(SpiderNestEntity mob, double speedIn, boolean useLongMemory, int intervalIn, float radiusIn, int maxSpawnIn) {
            super((CreatureEntity)mob, speedIn, useLongMemory, 0.625f);
            this.caveSpiderCountTargeting = new EntityPredicate().func_221013_a(12.0).func_221014_c().func_221010_e().func_221008_a();
            this.summonInterval = intervalIn;
            this.summonRadius = radiusIn;
            this.maxSpawn = maxSpawnIn;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.resetTimer(SpiderNestEntity.this);
        }

        public void func_75246_d() {
            LivingEntity target;
            SpiderNestEntity attacker;
            double d0;
            if (ModConfigs.cachedServer.SPIDER_NEST_SUMMON_CAVE_SPIDER && (d0 = (attacker = SpiderNestEntity.this).func_70092_e((target = attacker.func_70638_az()).func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_())) <= (double)(this.summonRadius * this.summonRadius) && attacker.func_70685_l((Entity)target)) {
                if (attacker.getSummonDelay() == -1) {
                    this.resetTimer(attacker);
                }
                if (attacker.getSummonDelay() > 0) {
                    attacker.setSummonDelay(attacker.getSummonDelay() - 1);
                } else if (attacker.field_70170_p.func_217374_a(CaveSpiderEntity.class, this.caveSpiderCountTargeting, (LivingEntity)attacker, attacker.func_174813_aQ().func_186662_g(12.0)).size() >= 6) {
                    attacker.setSummonDelay(20);
                } else {
                    attacker.summonSpider((ServerWorld)attacker.field_70170_p, (LivingEntity)attacker, target, attacker.func_70681_au(), 1 + attacker.func_70681_au().nextInt(this.maxSpawn));
                    this.resetTimer(attacker);
                }
            }
            super.func_75246_d();
        }

        private void resetTimer(SpiderNestEntity attackerIn) {
            attackerIn.setSummonDelay(this.summonInterval + attackerIn.func_70681_au().nextInt(this.summonInterval / 2));
        }
    }
}

