/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity;

import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.entity.goal.MeleeAttackGoal2;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class StoneularEntity
extends MonsterEntity
implements IModMob {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("8FC423B1-4E9A-246D-5CD6-28DB031B3CF9");
    private static final AttributeModifier ARMOR_MODIFIER = new AttributeModifier(ARMOR_MODIFIER_UUID, "Armor bonus", 8.0, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Byte> ACTION_PHASE = EntityDataManager.func_187226_a(StoneularEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockPos targetPosition = null;
    private int toRiseTick = 0;
    private int riseTick = 0;
    private int animationTick;
    private int animationTickO;

    public StoneularEntity(EntityType<? extends StoneularEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 12;
        this.field_70138_W = 1.0f;
        this.field_70765_h = new MoveHelperController(this);
        this.setActionPhase(ActionPhase.WALK);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveToTargetPositionGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, p -> {
            if (this.isWalking()) {
                return true;
            }
            if (this.func_226280_cw_() >= p.func_226278_cu_()) {
                double d1;
                double d0 = p.func_226277_ct_() - this.func_226277_ct_();
                return (double)MathHelper.func_76133_a((double)(d0 * d0 + (d1 = p.func_226281_cx_() - this.func_226281_cx_()) * d1)) <= 6.0;
            }
            return false;
        }));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ACTION_PHASE, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.29).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233824_g_, 2.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233820_c_, 0.75);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70148_d && !this.isWalking()) {
                this.animationTick = 15;
            }
            this.animationTickO = this.animationTick;
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (!this.isWalking()) {
                if (this.animationTick < 15) {
                    ++this.animationTick;
                }
            } else if (this.animationTick > 0) {
                --this.animationTick;
            }
        }
    }

    public void func_70636_d() {
        BlockPos pos;
        BlockState blockstate;
        if (this.field_70170_p.field_72995_K && this.isAwaiting() && this.func_70681_au().nextInt(24) == 0 && (blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(this.func_233580_cy_().func_177958_n(), this.func_233580_cy_().func_177956_o() + this.getYSize(), this.func_233580_cy_().func_177952_p()))) != null && !this.field_70170_p.func_175623_d(pos)) {
            double d0 = this.func_226282_d_(0.5);
            double d1 = this.func_174813_aQ().field_72337_e;
            double d2 = this.func_226287_g_(0.5);
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70089_S()) {
            if (this.isWalking()) {
                if (!this.func_184207_aI() && !this.func_184218_aH()) {
                    if (this.hasLevitation()) {
                        if (this.toRiseTick < 20) {
                            ++this.toRiseTick;
                        } else if (!this.func_203005_aq() && !this.func_180799_ab() && this.findTargetPos()) {
                            this.setActionPhase(ActionPhase.RISE);
                            this.toRiseTick = 0;
                        } else {
                            this.toRiseTick = 10;
                        }
                    } else if (this.func_70638_az() == null || !this.func_70685_l((Entity)this.func_70638_az())) {
                        if (this.func_233570_aj_()) {
                            if (this.toRiseTick < 200) {
                                ++this.toRiseTick;
                            }
                            if (this.toRiseTick >= 200 && this.func_70681_au().nextInt(50) == 0 && this.findTargetPos()) {
                                this.setActionPhase(ActionPhase.RISE);
                                this.toRiseTick = 0;
                            }
                        } else if (this.toRiseTick > 0) {
                            --this.toRiseTick;
                        }
                    } else if (this.toRiseTick > 0) {
                        this.toRiseTick = 0;
                    }
                }
            } else {
                boolean flag = false;
                if (!(!this.hasValidTargetPos() || this.func_184207_aI() || this.func_184218_aH() || this.func_203005_aq() || this.func_180799_ab())) {
                    BlockPos pos = this.func_233580_cy_();
                    if (this.isAwaiting()) {
                        double d3;
                        double d2;
                        if (this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && this.func_226280_cw_() >= this.func_70638_az().func_226278_cu_() && !this.hasLevitation() && (double)MathHelper.func_76133_a((double)((d2 = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_()) * d2 + (d3 = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_()) * d3)) <= 6.0) {
                            flag = true;
                        }
                        if (!flag) {
                            if (pos.func_177956_o() + this.getYSize() == this.getTargetPos().func_177956_o()) {
                                int i = pos.func_177958_n();
                                int j = pos.func_177952_p();
                                int k = this.getTargetPos().func_177958_n();
                                int l = this.getTargetPos().func_177952_p();
                                if (i != k || j != l) {
                                    if (Math.abs(i - k) <= 1 && Math.abs(j - l) <= 1) {
                                        BlockPos pos1 = new BlockPos(i, this.getTargetPos().func_177956_o(), j);
                                        if (StoneularEntity.isRedstoneConductorBlock(this.field_70170_p, pos1)) {
                                            this.setTargetPos(pos1);
                                        } else {
                                            flag = true;
                                        }
                                    } else {
                                        flag = true;
                                    }
                                }
                            } else {
                                flag = true;
                            }
                        }
                    } else {
                        BlockPos pos1 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + this.getYSize(), pos.func_177952_p());
                        if (StoneularEntity.isRedstoneConductorBlock(this.field_70170_p, pos1)) {
                            this.setTargetPos(pos1);
                            this.setActionPhase(ActionPhase.AWAIT);
                            this.riseTick = 0;
                        } else if (!this.field_70170_p.func_175623_d(pos1)) {
                            flag = true;
                        }
                        if (!flag) {
                            if (this.riseTick < 30) {
                                ++this.riseTick;
                            } else {
                                flag = true;
                            }
                        }
                    }
                } else {
                    flag = true;
                }
                if (flag) {
                    this.riseTick = 0;
                    this.setActionPhase(ActionPhase.WALK);
                    this.playFallSoundAndParticles();
                    if (this.func_70638_az() == null) {
                        this.toRiseTick = 150;
                    }
                }
            }
        }
    }

    private boolean findTargetPos() {
        BlockPos pos;
        BlockPos.Mutable blockpos$mutable = this.func_233580_cy_().func_239590_i_();
        int i = 0;
        while (this.field_70170_p.func_175623_d((BlockPos)blockpos$mutable)) {
            blockpos$mutable.func_189536_c(Direction.UP);
            if (++i <= 20) continue;
            return false;
        }
        if ((i >= 3 || this.hasLevitation() && i >= 1) && ModUtils.closerThan((Entity)this, pos = blockpos$mutable.func_185334_h(), 32) && StoneularEntity.isRedstoneConductorBlock(this.field_70170_p, pos)) {
            this.setTargetPos(pos);
            return true;
        }
        return false;
    }

    private boolean hasValidTargetPos() {
        return this.hasTargetPos() && ModUtils.closerThan((Entity)this, this.getTargetPos(), 32) && this.getTargetPos().func_177956_o() >= 1 && StoneularEntity.isRedstoneConductorBlock(this.field_70170_p, this.getTargetPos()) && this.field_70170_p.func_175623_d(this.getTargetPos().func_177977_b());
    }

    private int getYSize() {
        return MathHelper.func_76143_f((double)this.func_174813_aQ().func_216360_c());
    }

    private boolean hasLevitation() {
        return this.func_70644_a(Effects.field_188424_y);
    }

    private void playFallSoundAndParticles() {
        if (!this.field_70170_p.field_72995_K) {
            BlockPos pos;
            BlockState blockstate;
            if (this.hasTargetPos() && (blockstate = this.field_70170_p.func_180495_p(pos = this.getTargetPos())) != null && !this.field_70170_p.func_175623_d(pos)) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_(), 50, 0.0, 0.0, 0.0, 0.05);
            }
            this.func_184185_a(SoundEvents.field_187835_fT, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.2f + 0.9f));
        }
    }

    private static boolean isRedstoneConductorBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_215686_e((IBlockReader)world, pos);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setActionPhase(ActionPhase.WALK);
        this.toRiseTick = 200;
        return spawnDataIn;
    }

    protected boolean func_225502_at_() {
        return !this.isAwaiting() && super.func_225502_at_();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        if (this.isWalking()) {
            super.func_184231_a(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack stack;
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76347_k()) {
            amount *= 0.5f;
        } else if (!source.func_76352_a() && source instanceof EntityDamageSource && source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity && !(stack = ((LivingEntity)source.func_76346_g()).func_184614_ca()).func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b().func_150897_b(Blocks.field_150348_b.func_176223_P())) {
            amount *= 2.0f;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd() && amount >= 2.0f && source != DamageSource.field_76368_d) {
            if (!this.isWalking()) {
                if (!this.hasLevitation()) {
                    this.setActionPhase(ActionPhase.WALK);
                    this.playFallSoundAndParticles();
                }
            } else {
                this.toRiseTick = 0;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setActionPhase(ActionPhase.byId(compound.func_74762_e("ActionPhase")));
        if (compound.func_74764_b("TargetPos")) {
            this.targetPosition = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("TargetPos"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ActionPhase", this.getActionPhase().getId());
        if (this.hasTargetPos()) {
            compound.func_218657_a("TargetPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getTargetPos()));
        }
    }

    public ActionPhase getActionPhase() {
        return ActionPhase.byId(((Byte)this.field_70180_af.func_187225_a(ACTION_PHASE)).byteValue());
    }

    private void setActionPhase(ActionPhase phase) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(Attributes.field_233826_i_).func_111124_b(ARMOR_MODIFIER);
            if (phase != ActionPhase.WALK) {
                this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(ARMOR_MODIFIER);
            }
        }
        this.field_70180_af.func_187227_b(ACTION_PHASE, (Object)((byte)(phase.getId() & 0xFF)));
    }

    public boolean hasTargetPos() {
        return this.targetPosition != null;
    }

    public void setTargetPos(BlockPos pos) {
        this.targetPosition = pos;
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.targetPosition;
    }

    public boolean isWalking() {
        return !this.isAwaiting() && !this.isRising();
    }

    public boolean isRising() {
        return this.getActionPhase() == ActionPhase.RISE;
    }

    public boolean isAwaiting() {
        return this.getActionPhase() == ActionPhase.AWAIT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationScale(float f) {
        return MathHelper.func_219799_g((float)f, (float)((float)this.animationTickO / 15.0f), (float)((float)this.animationTick / 15.0f));
    }

    public int func_70641_bl() {
        return 3;
    }

    public double func_70033_W() {
        return 0.14;
    }

    protected SoundEvent func_184639_G() {
        return this.isWalking() ? (SoundEvent)ModSoundEvents.STONEULAR_IDLE.get() : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.STONEULAR_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.STONEULAR_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        if (this.isWalking()) {
            this.func_184185_a(SoundEvents.field_187902_gb, 0.15f, 1.0f);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static class MoveToTargetPositionGoal
    extends Goal {
        private final StoneularEntity parent;

        public MoveToTargetPositionGoal(StoneularEntity mob) {
            this.parent = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.parent.func_70605_aq().func_75640_a() && !this.parent.isWalking() && this.parent.hasValidTargetPos();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            if (this.parent.hasTargetPos()) {
                BlockPos pos2 = this.parent.getTargetPos();
                double d0 = pos2.func_177958_n();
                double d1 = pos2.func_177956_o();
                double d2 = pos2.func_177952_p();
                this.parent.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            }
        }
    }

    private class RandomWalkingGoal
    extends WaterAvoidingRandomWalkingGoal {
        public RandomWalkingGoal(StoneularEntity mob) {
            super((CreatureEntity)mob, 1.0);
        }

        public boolean func_75250_a() {
            return StoneularEntity.this.isWalking() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return StoneularEntity.this.isWalking() && super.func_75253_b();
        }
    }

    private class AttackGoal
    extends MeleeAttackGoal2 {
        public AttackGoal(StoneularEntity mob) {
            super((CreatureEntity)mob, 1.0, false, 0.6666667f);
        }

        @Override
        public boolean func_75250_a() {
            return StoneularEntity.this.isWalking() && super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            return StoneularEntity.this.isWalking() && super.func_75253_b();
        }
    }

    protected class MoveHelperController
    extends MovementController {
        private final StoneularEntity parent;

        public MoveHelperController(StoneularEntity mob) {
            super((MobEntity)mob);
            this.parent = mob;
        }

        public void func_75641_c() {
            if (this.parent.isWalking()) {
                this.parent.func_189654_d(false);
                super.func_75641_c();
            } else {
                this.parent.func_189654_d(true);
                if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                    Vector3d vector3d = new Vector3d(this.field_75646_b - this.parent.func_226277_ct_(), this.field_75647_c - this.parent.func_226278_cu_(), this.field_75644_d - this.parent.func_226281_cx_());
                    double d0 = vector3d.func_72433_c();
                    if (d0 < this.parent.func_174813_aQ().func_72320_b() || this.parent.isAwaiting() && !ModUtils.canReach((LivingEntity)this.parent, vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                        this.field_188491_h = MovementController.Action.WAIT;
                        this.parent.func_213317_d(this.parent.func_213322_ci().func_186678_a(0.5));
                    } else {
                        this.parent.func_213317_d(this.parent.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.01)));
                    }
                }
            }
        }
    }

    public static enum ActionPhase {
        AWAIT(0),
        WALK(1),
        RISE(2);

        private final int id;
        private static final ActionPhase[] BY_ID;

        private ActionPhase(int idIn) {
            this.id = idIn;
        }

        public int getId() {
            return this.id;
        }

        public static ActionPhase byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (ActionPhase[])Arrays.stream(ActionPhase.values()).sorted(Comparator.comparingInt(ActionPhase::getId)).toArray(ActionPhase[]::new);
        }
    }
}

