/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity.goal;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.MathHelper;

public class RangedAttackGoal2
extends Goal {
    private final MobEntity mob;
    private final IRangedAttackMob rangedAttackMob;
    private LivingEntity target;
    private int rangedAttackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;
    private final float minAttackDistance;
    private final boolean canStrafe;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public RangedAttackGoal2(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistance) {
        this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistance);
    }

    public RangedAttackGoal2(IRangedAttackMob attacker, double movespeed, int attackInterval, int maxAttackTime, float maxAttackDistance) {
        this(attacker, movespeed, attackInterval, maxAttackTime, maxAttackDistance, maxAttackDistance, false);
    }

    public RangedAttackGoal2(IRangedAttackMob attacker, double movespeed, int attackInterval, int maxAttackTime, float maxAttackDistance, boolean canStrafe) {
        this(attacker, movespeed, attackInterval, maxAttackTime, maxAttackDistance, maxAttackDistance, canStrafe);
    }

    public RangedAttackGoal2(IRangedAttackMob attacker, double movespeed, int attackInterval, int maxAttackTime, float maxAttackDistance, float minAttackDistance, boolean canStrafe) {
        if (!(attacker instanceof LivingEntity)) {
            throw new IllegalArgumentException("RangedAttackGoal2 requires Mob implements RangedAttackMob");
        }
        this.rangedAttackMob = attacker;
        this.mob = (MobEntity)attacker;
        this.speedModifier = movespeed;
        this.attackIntervalMin = attackInterval;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistance;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
        this.minAttackDistance = minAttackDistance * minAttackDistance;
        this.canStrafe = canStrafe;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity != null && livingentity.func_70089_S()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.mob.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double d0 = this.mob.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        boolean flag = this.mob.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.maxAttackDistance || d0 > (double)this.minAttackDistance && this.rangedAttackTime > 10 || this.seeTime < (this.canStrafe ? 20 : 5))) {
            this.mob.func_70661_as().func_75499_g();
            if (this.canStrafe) {
                ++this.strafingTime;
            }
        } else {
            this.mob.func_70661_as().func_75497_a((Entity)this.target, this.speedModifier);
            if (this.canStrafe) {
                this.strafingTime = -1;
            }
        }
        if (this.canStrafe && this.strafingTime >= 20) {
            if ((double)this.mob.func_70681_au().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.func_70681_au().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.canStrafe && this.strafingTime > -1) {
            if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                this.strafingBackwards = false;
            } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.mob.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.mob.func_70625_a((Entity)this.target, 30.0f, 30.0f);
        } else {
            this.mob.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        }
        if (--this.rangedAttackTime == 0) {
            if (!flag) {
                return;
            }
            float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            float f1 = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.func_82196_d(this.target, f1);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }

    public int getAttackTime() {
        return this.rangedAttackTime;
    }

    public LivingEntity getTarget() {
        return this.target;
    }
}

