/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity.projectile;

import com.github.mechalopa.hmag.entity.LichEntity;
import com.github.mechalopa.hmag.entity.projectile.ModDamagingProjectileEntity;
import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.registry.ModParticleTypes;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagicBulletEntity
extends ModDamagingProjectileEntity {
    private static final DataParameter<Integer> DATA_VARIANT_ID = EntityDataManager.func_187226_a(MagicBulletEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> EFFECT_LEVEL = EntityDataManager.func_187226_a(MagicBulletEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PIERCE_LEVEL = EntityDataManager.func_187226_a(MagicBulletEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private IntOpenHashSet piercingIgnoreEntityIds;

    public MagicBulletEntity(EntityType<? extends MagicBulletEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public MagicBulletEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGIC_BULLET.get()), shooter, accelX, accelY, accelZ, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MagicBulletEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGIC_BULLET.get()), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_VARIANT_ID, (Object)0);
        this.field_70180_af.func_187214_a(EFFECT_LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(PIERCE_LEVEL, (Object)0);
    }

    protected float func_82341_c() {
        switch (this.getVariant()) {
            case 1: {
                return 0.87f;
            }
            case 2: {
                return 0.98f;
            }
        }
        return 0.9f;
    }

    @Override
    protected void tick2() {
        if (this.getVariant() == 2) {
            if (!(this.field_70170_p.field_72995_K || this.field_70173_aa < 60 && this.func_234616_v_() != null)) {
                this.func_70106_y();
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.NEMESIS_FLAME.get(), this.func_226282_d_(0.5), this.func_226283_e_(this.field_70146_Z.nextDouble() * 0.5), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        } else {
            super.tick2();
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        super.func_213868_a(result);
        Entity entity = result.func_216348_a();
        Vector3d vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b();
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercingIgnoreEntityIds.size() < this.getPierceLevel() + 1) {
                this.piercingIgnoreEntityIds.add(entity.func_145782_y());
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean flag;
            Entity entity1 = this.func_234616_v_();
            float damage = this.getDamage();
            if (entity1 != null && entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                if (this.getVariant() == 0 && livingentity instanceof LichEntity && entity instanceof VexEntity && livingentity.func_184191_r(entity)) {
                    damage *= 5.0f;
                }
                if ((flag = entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)livingentity), damage)) && entity.func_70089_S()) {
                    this.func_174815_a(livingentity, entity);
                }
            } else {
                flag = entity.func_70097_a(DamageSource.field_76376_m, damage);
            }
            if (flag && entity instanceof LivingEntity && this.getEffectLevel() > 0) {
                int i = 0;
                switch (this.getVariant()) {
                    case 0: {
                        if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                            i = 7;
                        } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                            i = 15;
                        }
                        if (i <= 0) break;
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76437_t, 20 * i, 0));
                        break;
                    }
                    case 1: {
                        if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                            i = 5;
                        } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                            i = 10;
                        }
                        if (i <= 0) break;
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76440_q, 20 * i, 0));
                        break;
                    }
                    case 2: {
                        i = (this.getEffectLevel() * 2 + 4) * 20;
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76437_t, i, 1));
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, i, 1));
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76419_f, i, 1));
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_82731_v, i, 1));
                        if (!(vector3d.func_189985_c() > 0.0)) break;
                        ((LivingEntity)entity).func_233627_a_(1.0f * ((float)this.getEffectLevel() / 12.0f) + 0.1f, -vector3d.field_72450_a, -vector3d.field_72449_c);
                    }
                }
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        }
    }

    protected boolean func_230298_a_(Entity entityIn) {
        return super.func_230298_a_(entityIn) && this.func_234616_v_() != null && !this.func_234616_v_().equals((Object)entityIn) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entityIn.func_145782_y()));
    }

    @Override
    protected void onHitServer(RayTraceResult result) {
        if (result.func_216346_c() != RayTraceResult.Type.ENTITY || this.getPierceLevel() <= 0 || this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
            this.func_70106_y();
        }
    }

    public void func_184206_a(DataParameter<?> data) {
        if (DATA_VARIANT_ID.equals(data)) {
            this.func_213323_x_();
        }
        super.func_184206_a(data);
    }

    public EntitySize func_213305_a(Pose pose) {
        if (this.getVariant() == 2) {
            return super.func_213305_a(pose).func_220313_a(1.6f);
        }
        return super.func_213305_a(pose);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3 && this.getVariant() == 2) {
            for (int i = 0; i < 12; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.NEMESIS_FLAME.get(), this.func_226282_d_(1.75), this.func_226283_e_(this.field_70146_Z.nextDouble() * 1.75), this.func_226287_g_(1.75), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_VARIANT_ID);
    }

    public void setVariant(int typeIn) {
        if (typeIn < 0 || typeIn >= 3) {
            typeIn = 0;
        }
        this.field_70180_af.func_187227_b(DATA_VARIANT_ID, (Object)typeIn);
    }

    public void setPierceLevel(byte amount) {
        this.field_70180_af.func_187227_b(PIERCE_LEVEL, (Object)amount);
    }

    public byte getPierceLevel() {
        return (Byte)this.field_70180_af.func_187225_a(PIERCE_LEVEL);
    }

    public void setEffectLevel(byte amount) {
        this.field_70180_af.func_187227_b(EFFECT_LEVEL, (Object)amount);
    }

    public byte getEffectLevel() {
        return (Byte)this.field_70180_af.func_187225_a(EFFECT_LEVEL);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74774_a("PierceLevel", this.getPierceLevel());
        compound.func_74774_a("EffectLevel", this.getEffectLevel());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setPierceLevel(compound.func_74771_c("PierceLevel"));
        this.setEffectLevel(compound.func_74771_c("EffectLevel"));
    }

    protected IParticleData func_195057_f() {
        switch (this.getVariant()) {
            case 1: {
                return ParticleTypes.field_197594_E;
            }
            case 2: {
                return ParticleTypes.field_197601_L;
            }
        }
        return ParticleTypes.field_197616_i;
    }
}

