/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity.projectile;

import com.github.mechalopa.hmag.entity.projectile.ModDamagingProjectileEntity;
import com.github.mechalopa.hmag.registry.ModEntityTypes;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class MagmaBulletEntity
extends ModDamagingProjectileEntity {
    private static final DataParameter<Integer> LIFE_TIME = EntityDataManager.func_187226_a(MagmaBulletEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int life = 25;

    public MagmaBulletEntity(EntityType<? extends MagmaBulletEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public MagmaBulletEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGMA_BULLET.get()), shooter, accelX, accelY, accelZ, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MagmaBulletEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGMA_BULLET.get()), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIFE_TIME, (Object)25);
    }

    protected float func_82341_c() {
        return 0.85f;
    }

    @Override
    protected void tick2() {
        super.tick2();
        if (this.life > 0) {
            this.life = this.func_203008_ap() ? Math.max(this.life - 3, 0) : --this.life;
        }
        if (this.life <= 0) {
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.05, 0.0));
            }
            this.field_70232_b *= 0.97;
            this.field_70233_c *= 0.97;
            this.field_70230_d *= 0.97;
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity;
        super.func_213868_a(result);
        if (!this.field_70170_p.field_72995_K && !(entity = result.func_216348_a()).func_230279_az_()) {
            Entity entity1 = this.func_234616_v_();
            int i = entity.func_223314_ad();
            entity.func_70015_d(5);
            boolean flag = entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)entity1).func_76361_j(), this.getDamage());
            if (!flag) {
                entity.func_241209_g_(i);
            } else if (entity1 != null && entity1 instanceof LivingEntity) {
                this.func_174815_a((LivingEntity)entity1, entity);
            }
        }
    }

    @Override
    protected void onHitServer(RayTraceResult result) {
        boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.func_234616_v_());
        this.field_70170_p.func_217398_a((Entity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.75f, flag, flag ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        super.onHitServer(result);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            BlockParticleData iparticledata = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196814_hQ.func_176223_P()).setPos(this.func_233580_cy_());
            for (int i = 0; i < 16; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            if (!this.func_203005_aq()) {
                for (int j = 0; j < 8; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void setLifeTime(int amount) {
        this.field_70180_af.func_187227_b(LIFE_TIME, (Object)amount);
        this.life = amount;
    }

    public int getLifeTime() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE_TIME);
    }

    public int getLife() {
        return this.life;
    }

    public void func_184206_a(DataParameter<?> data) {
        super.func_184206_a(data);
        if (LIFE_TIME.equals(data)) {
            this.life = this.getLifeTime();
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("Life", (short)this.getLife());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setLifeTime(compound.func_74765_d("Life"));
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197601_L;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.15f;
    }
}

