/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.entity.projectile;

import com.github.mechalopa.hmag.entity.projectile.ModProjectileItemEntity;
import com.github.mechalopa.hmag.registry.ModEntityTypes;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PoisonSeedEntity
extends ModProjectileItemEntity {
    public PoisonSeedEntity(EntityType<? extends PoisonSeedEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public PoisonSeedEntity(World worldIn, LivingEntity throwerIn) {
        super((EntityType<? extends ModProjectileItemEntity>)((EntityType)ModEntityTypes.POISON_SEED.get()), throwerIn, worldIn);
    }

    public PoisonSeedEntity(World worldIn, double x, double y, double z) {
        super((EntityType<? extends ModProjectileItemEntity>)((EntityType)ModEntityTypes.POISON_SEED.get()), x, y, z, worldIn);
    }

    protected Item func_213885_i() {
        return Items.field_185163_cU;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184543_l()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void onHitServer(RayTraceResult result) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (LivingEntity livingEntity : list) {
                double d0;
                if (!livingEntity.func_184603_cC() || !((d0 = this.func_70068_e((Entity)livingEntity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a() == livingEntity) {
                    d1 = 1.0;
                }
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 140;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 300;
                }
                if ((i = (int)(d1 * (double)i + 0.5)) <= 20) continue;
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, i, 0));
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76437_t, i, 0));
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, i, 0));
            }
        }
        this.field_70170_p.func_217379_c(2002, this.func_233580_cy_(), Effects.field_76436_u.func_76401_j());
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        super.onHitServer(result);
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        super.func_213868_a(result);
        result.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), this.getDamage());
    }
}

