/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.math.MathHelper;

public class ModSwordItem
extends SwordItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final int maxDamage;
    private final int enchantability;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ModSwordItem(IItemTier tier, Item.Properties builderIn) {
        this(tier, 3.0f, -2.4f, builderIn);
    }

    public ModSwordItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        this(tier, attackDamageIn, attackSpeedIn, tier.func_200926_a(), tier.func_200927_e(), builderIn);
    }

    public ModSwordItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, int maxDamageIn, int enchantabilityIn, Item.Properties builderIn) {
        super(tier, MathHelper.func_76141_d((float)attackDamageIn), attackSpeedIn, builderIn);
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
        this.maxDamage = maxDamageIn;
        this.enchantability = enchantabilityIn;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.func_111205_h(equipmentSlot);
    }

    public float func_200894_d() {
        return this.attackDamage;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.maxDamage;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public int getBurnTime(ItemStack stack, @Nullable IRecipeType<?> recipeType) {
        return this.func_200891_e() == ItemTier.WOOD ? 200 : super.getBurnTime(stack, recipeType);
    }
}

