/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fml.ModList;

public class ModLoadedCondition
implements ILootCondition {
    public static final LootConditionType TYPE = new LootConditionType((ILootSerializer)new Serializer());
    private final String modid;

    private ModLoadedCondition(String modid) {
        this.modid = modid;
    }

    public LootConditionType func_230419_b_() {
        return TYPE;
    }

    public boolean test(LootContext lootContext) {
        return ModList.get().isLoaded(this.modid);
    }

    public static Builder builder(String modid) {
        return new Builder(modid);
    }

    public static class Serializer
    implements ILootSerializer<ModLoadedCondition> {
        public void serialize(JsonObject object, ModLoadedCondition instance, JsonSerializationContext ctx) {
            object.addProperty("modid", instance.modid);
        }

        public ModLoadedCondition deserialize(JsonObject object, JsonDeserializationContext ctx) {
            return new ModLoadedCondition(JSONUtils.func_151200_h((JsonObject)object, (String)"modid"));
        }
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private final String modid;

        public Builder(String modid) {
            if (modid == null) {
                throw new IllegalArgumentException("Target modid must not be null");
            }
            this.modid = modid;
        }

        public ILootCondition build() {
            return new ModLoadedCondition(this.modid);
        }
    }
}

