/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.loot.modifiers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

public class AdditionalEntityLootModifier
extends LootModifier {
    private static final Gson GSON = LootSerializers.func_237387_b_().create();
    private final ILootFunction[] functions;
    private final Item addition;

    public AdditionalEntityLootModifier(ILootCondition[] conditionsIn, ILootFunction[] functions, Item addition) {
        super(conditionsIn);
        this.functions = functions;
        this.addition = addition;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity != null && entity instanceof LivingEntity && this.addition != null && ((LivingEntity)entity).func_213346_cF() != null && context.getQueriedLootTableId().equals((Object)((LivingEntity)entity).func_213346_cF())) {
            ItemStack stack = this.addition.func_190903_i();
            for (ILootFunction function : this.functions) {
                stack = (ItemStack)function.apply((Object)stack, (Object)context);
            }
            generatedLoot.add(stack);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AdditionalEntityLootModifier> {
        public AdditionalEntityLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            ILootFunction[] functions = object.has("functions") ? (ILootFunction[])GSON.fromJson(object.get("functions"), ILootFunction[].class) : new ILootFunction[]{};
            Item addition = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"addition")));
            return new AdditionalEntityLootModifier(conditionsIn, functions, addition);
        }

        public JsonObject write(AdditionalEntityLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            if (!ArrayUtils.isEmpty((Object[])instance.functions)) {
                json.add("functions", GSON.toJsonTree((Object)instance.functions));
            }
            json.addProperty("addition", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.addition).toString());
            return json;
        }
    }
}

