/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.loot.modifiers;

import com.github.mechalopa.hmag.util.MobTier;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.apache.commons.lang3.ArrayUtils;

public class NuggetLootModifier
extends LootModifier {
    private static final Gson GSON = LootSerializers.func_237387_b_().create();
    private final ILootFunction[] functions;

    public NuggetLootModifier(ILootCondition[] conditionsIn, ILootFunction[] functions) {
        super(conditionsIn);
        this.functions = functions;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Item item;
        MobTier tier;
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity != null && entity instanceof LivingEntity && ((LivingEntity)entity).func_213346_cF() != null && ((LivingEntity)entity).func_213346_cF().equals((Object)context.getQueriedLootTableId()) && (tier = MobTier.getMobTier(entity.func_200600_R())).hasReward() && (item = tier.getDropItem(context.func_216032_b())) != null) {
            ItemStack stack = new ItemStack((IItemProvider)item, 1);
            for (ILootFunction function : this.functions) {
                stack = (ItemStack)function.apply((Object)stack, (Object)context);
            }
            generatedLoot.add(stack);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<NuggetLootModifier> {
        public NuggetLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            ILootFunction[] functions = object.has("functions") ? (ILootFunction[])GSON.fromJson(object.get("functions"), ILootFunction[].class) : new ILootFunction[]{};
            return new NuggetLootModifier(conditionsIn, functions);
        }

        public JsonObject write(NuggetLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            if (!ArrayUtils.isEmpty((Object[])instance.functions)) {
                json.add("functions", GSON.toJsonTree((Object)instance.functions));
            }
            return json;
        }
    }
}

