/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.loot.modifiers;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ReplaceLootModifier
extends LootModifier {
    private final Item original;
    private final Item replacement;

    public ReplaceLootModifier(ILootCondition[] conditionsIn, Item original, Item replacement) {
        super(conditionsIn);
        this.original = original;
        this.replacement = replacement;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.original == null || this.replacement == null) {
            return generatedLoot;
        }
        return generatedLoot.stream().map(stack -> {
            if (stack.func_77973_b() == this.original) {
                return new ItemStack((IItemProvider)this.replacement, stack.func_190916_E());
            }
            return stack;
        }).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ReplaceLootModifier> {
        public ReplaceLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            Item original = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"original")));
            Item replacement = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"replacement")));
            return new ReplaceLootModifier(conditionsIn, original, replacement);
        }

        public JsonObject write(ReplaceLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("original", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.original).toString());
            json.addProperty("replacement", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.replacement).toString());
            return json;
        }
    }
}

