/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.recipe;

import com.github.mechalopa.hmag.item.EnchantmentUpgradeItem;
import com.github.mechalopa.hmag.registry.ModRecipes;
import com.github.mechalopa.hmag.util.ModTags;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EnchantmentUpgradeRecipe
extends SmithingRecipe {
    private final ResourceLocation recipeId;

    public EnchantmentUpgradeRecipe(ResourceLocation recipeId) {
        super(recipeId, Ingredient.field_193370_a, Ingredient.field_193370_a, ItemStack.field_190927_a);
        this.recipeId = recipeId;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        List<EnchantmentUpgradeItem.Properties.EnchantmentUpgradeProp> eups;
        ItemStack stack = inv.func_70301_a(0);
        ItemStack stack1 = inv.func_70301_a(1);
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() != Items.field_151134_bR && !stack1.func_190926_b() && stack1.func_77973_b() != null && stack1.func_77973_b() instanceof EnchantmentUpgradeItem && ModTags.checkTagContains(ModTags.ENCHANTMENT_UPGRADE_ITEMS, stack1.func_77973_b()) && !ModTags.checkTagContains(ModTags.ENCHANTMENT_UPGRADEABLE_BLACKLIST, stack.func_77973_b()) && !(eups = ((EnchantmentUpgradeItem)stack1.func_77973_b()).getEnchantmentUpgradeProps()).isEmpty()) {
            for (EnchantmentUpgradeItem.Properties.EnchantmentUpgradeProp eup : eups) {
                Enchantment enchantment;
                if (eup == null || (enchantment = eup.getEnchantment()) == null || !EnchantmentUpgradeRecipe.checkEnchantableItem(stack, enchantment, eup.getMinLevel(), eup.getMaxLevel())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkEnchantableItem(ItemStack stackIn, Enchantment enchantmentIn, int min, int max) {
        int i;
        return !stackIn.func_190926_b() && enchantmentIn.func_92089_a(stackIn) && ((i = EnchantmentHelper.func_77506_a((Enchantment)enchantmentIn, (ItemStack)stackIn)) == 0 && min == 0 && max >= 0 ? EnchantmentHelper.func_201840_a(EnchantmentHelper.func_82781_a((ItemStack)stackIn).keySet(), (Enchantment)enchantmentIn) : i >= min && i <= max);
    }

    public ItemStack func_77572_b(IInventory inv) {
        List<EnchantmentUpgradeItem.Properties.EnchantmentUpgradeProp> eups;
        ItemStack stack = inv.func_70301_a(1);
        if (stack.func_77973_b() instanceof EnchantmentUpgradeItem && !(eups = ((EnchantmentUpgradeItem)stack.func_77973_b()).getEnchantmentUpgradeProps()).isEmpty()) {
            for (EnchantmentUpgradeItem.Properties.EnchantmentUpgradeProp eup : eups) {
                ItemStack stack1;
                Enchantment enchantment;
                if (eup == null || (enchantment = eup.getEnchantment()) == null || !EnchantmentUpgradeRecipe.checkEnchantableItem(stack1 = inv.func_70301_a(0), enchantment, eup.getMinLevel(), eup.getMaxLevel())) continue;
                ItemStack stack2 = stack1.func_77946_l();
                if (stack1.func_77948_v()) {
                    stack2.func_196083_e("Enchantments");
                    stack2.func_196083_e("StoredEnchantments");
                    int j = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack1);
                    Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack1).entrySet().stream().filter(p -> p.getKey() != enchantment).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    map.put(enchantment, j + 1);
                    EnchantmentHelper.func_82782_a(map, (ItemStack)stack2);
                    stack2.func_82841_c(0);
                    for (int k = 0; k < map.size(); ++k) {
                        stack2.func_82841_c(RepairContainer.func_216977_d((int)stack1.func_82838_A()));
                    }
                } else {
                    EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)enchantment, (Object)1), (ItemStack)stack2);
                }
                return stack2;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.ENCHANTMENT_UPGRADE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<EnchantmentUpgradeRecipe> {
        public EnchantmentUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new EnchantmentUpgradeRecipe(this.getRegistryName());
        }

        @Nonnull
        public EnchantmentUpgradeRecipe fromNetwork(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
            return new EnchantmentUpgradeRecipe(this.getRegistryName());
        }

        public void toNetwork(PacketBuffer buffer, EnchantmentUpgradeRecipe recipe) {
        }
    }
}

