/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.util;

import com.github.mechalopa.hmag.registry.ModItems;
import com.github.mechalopa.hmag.util.ModTags;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;

public enum MobTier {
    IRON(1, (ITag<EntityType<?>>)ModTags.IRON_TIER, true),
    GOLD(2, (ITag<EntityType<?>>)ModTags.GOLD_TIER, true),
    SILVER(2, (ITag<EntityType<?>>)ModTags.SILVER_TIER, true),
    EMERALD(2, (ITag<EntityType<?>>)ModTags.EMERALD_TIER, true),
    DIAMOND(3, (ITag<EntityType<?>>)ModTags.DIAMOND_TIER, true),
    RUBY(3, (ITag<EntityType<?>>)ModTags.RUBY_TIER, true),
    SAPPHIRE(3, (ITag<EntityType<?>>)ModTags.SAPPHIRE_TIER, true),
    NONE(0, null, false);

    private final int tier;
    private final ITag<EntityType<?>> tag;
    private final boolean hasReward;

    private MobTier(int tierIn, ITag<EntityType<?>> tagIn, boolean hasRewardIn) {
        this.tier = tierIn;
        this.tag = tagIn;
        this.hasReward = hasRewardIn;
    }

    public int getTier() {
        return this.tier;
    }

    @Nullable
    private ITag<EntityType<?>> getTag() {
        return this.tag;
    }

    public boolean hasReward() {
        return this.hasReward;
    }

    @Nullable
    public Item getDropItem(Random rand) {
        return MobTier.getItem(this, rand);
    }

    @Nullable
    private static Item getItem(MobTier mobTier, Random rand) {
        switch (mobTier) {
            case IRON: {
                return rand.nextBoolean() && ModTags.getItem(ModTags.FORGE_COPPER_INGOTS) != null ? (Item)ModItems.COPPER_NUGGET.get() : Items.field_191525_da;
            }
            case GOLD: {
                return rand.nextInt(5) == 0 ? Items.field_191525_da : Items.field_151074_bl;
            }
            case SILVER: {
                return rand.nextInt(5) == 0 ? Items.field_191525_da : (ModTags.getItem(ModTags.FORGE_SILVER_INGOTS) != null ? (Item)ModItems.SILVER_NUGGET.get() : Items.field_151074_bl);
            }
            case EMERALD: {
                return rand.nextInt(4) == 0 ? Items.field_151074_bl : (Item)ModItems.EMERALD_FRAGMENT.get();
            }
            case DIAMOND: {
                return (Item)ModItems.DIAMOND_FRAGMENT.get();
            }
            case RUBY: {
                return ModTags.getItem(ModTags.FORGE_RUBY_GEMS) != null ? (rand.nextInt(4) == 0 ? (Item)ModItems.DIAMOND_FRAGMENT.get() : (Item)ModItems.RUBY_FRAGMENT.get()) : (rand.nextInt(4) == 0 ? (Item)ModItems.EMERALD_FRAGMENT.get() : (Item)ModItems.DIAMOND_FRAGMENT.get());
            }
            case SAPPHIRE: {
                return ModTags.getItem(ModTags.FORGE_SAPPHIRE_GEMS) != null ? (rand.nextInt(4) == 0 ? (Item)ModItems.DIAMOND_FRAGMENT.get() : (Item)ModItems.SAPPHIRE_FRAGMENT.get()) : (rand.nextInt(4) == 0 ? (Item)ModItems.EMERALD_FRAGMENT.get() : (Item)ModItems.DIAMOND_FRAGMENT.get());
            }
        }
        return null;
    }

    public static MobTier getMobTier(EntityType<?> type) {
        if (type != null) {
            for (MobTier tier : MobTier.values()) {
                if (!ModTags.checkTagContains(tier.getTag(), type)) continue;
                return tier;
            }
        }
        return NONE;
    }
}

