/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.util;

import com.github.mechalopa.hmag.util.ModUtils;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;

public class ModSpawnRules {
    public static boolean checkMonsterSpawnOnGroundRules(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223325_c(type, (IServerWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn) && (reason == SpawnReason.SPAWNER || worldIn.func_226660_f_(pos));
    }

    public static boolean checkMonsterSpawnOnUndergroundRules(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223325_c(type, (IServerWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn) && (reason == SpawnReason.SPAWNER || !worldIn.func_226660_f_(pos));
    }

    public static boolean checkMonsterSpawnInLightOverY64Rules(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223325_c(type, (IServerWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn) && (reason == SpawnReason.SPAWNER || pos.func_177956_o() >= 64);
    }

    public static boolean checkMonsterSpawnInLightUnderY56Rules(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223325_c(type, (IServerWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn) && (reason == SpawnReason.SPAWNER || pos.func_177956_o() < 56);
    }

    public static boolean checkMonsterSpawnInLightUnderY32Rules(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223325_c(type, (IServerWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn) && (reason == SpawnReason.SPAWNER || pos.func_177956_o() < 32);
    }

    public static boolean checkMonsterSpawnInLightUnderY24Rules(EntityType<? extends MonsterEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223325_c(type, (IServerWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn) && (reason == SpawnReason.SPAWNER || pos.func_177956_o() < 24);
    }

    public static boolean checkMobSpawnInLightRules(EntityType<? extends MobEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && ModUtils.isDarkEnoughToSpawn(worldIn, pos, randomIn) && MobEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }
}

