/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.util;

import com.github.mechalopa.hmag.HMaG;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

public class ModTags {
    public static final ITag.INamedTag<Block> OGRE_IMMUNE = ModTags.makeBlockTag("ogre_immune");
    public static final ITag.INamedTag<Item> CURSE_REMOVABLE_BLACKLIST = ModTags.makeItemTag("curse_removable_blacklist");
    public static final ITag.INamedTag<Item> CURSE_REMOVE_ITEMS = ModTags.makeItemTag("curse_remove_items");
    public static final ITag.INamedTag<Item> ENCHANTMENT_UPGRADE_ITEMS = ModTags.makeItemTag("enchantment_upgrade_items");
    public static final ITag.INamedTag<Item> ENCHANTMENT_UPGRADEABLE_BLACKLIST = ModTags.makeItemTag("enchantment_upgradeable_blacklist");
    public static final ITag.INamedTag<EntityType<?>> DIAMOND_TIER = ModTags.makeEntityTag("tiered/diamond");
    public static final ITag.INamedTag<EntityType<?>> EMERALD_TIER = ModTags.makeEntityTag("tiered/emerald");
    public static final ITag.INamedTag<EntityType<?>> GOLD_TIER = ModTags.makeEntityTag("tiered/gold");
    public static final ITag.INamedTag<EntityType<?>> IRON_TIER = ModTags.makeEntityTag("tiered/iron");
    public static final ITag.INamedTag<EntityType<?>> RUBY_TIER = ModTags.makeEntityTag("tiered/ruby");
    public static final ITag.INamedTag<EntityType<?>> SAPPHIRE_TIER = ModTags.makeEntityTag("tiered/sapphire");
    public static final ITag.INamedTag<EntityType<?>> SILVER_TIER = ModTags.makeEntityTag("tiered/silver");
    public static final ITag.INamedTag<EntityType<?>> CREEPER_GIRL_REPLACEABLES = ModTags.makeEntityTag("creeper_girl_replaceables");
    public static final ITag.INamedTag<EntityType<?>> CRIMSON_SLAUGHTERER_TARGET_ANIMAL_BLACKLIST = ModTags.makeEntityTag("crimson_slaughterer_target_animal_blacklist");
    public static final ITag.INamedTag<EntityType<?>> DROWNED_GIRL_REPLACEABLES = ModTags.makeEntityTag("drowned_girl_replaceables");
    public static final ITag.INamedTag<EntityType<?>> ENDER_EXECUTOR_REPLACEABLES = ModTags.makeEntityTag("ender_executor_replaceables");
    public static final ITag.INamedTag<EntityType<?>> HARD_SNOWBALL_HURTS_EXTRA_TYPES = ModTags.makeEntityTag("hard_snowball_hurts_extra_types");
    public static final ITag.INamedTag<EntityType<?>> HUSK_GIRL_REPLACEABLES = ModTags.makeEntityTag("husk_girl_replaceables");
    public static final ITag.INamedTag<EntityType<?>> MONOLITH_TARGET_BLACKLIST = ModTags.makeEntityTag("monolith_target_blacklist");
    public static final ITag.INamedTag<EntityType<?>> SAVAGEFANG_TARGET_BLACKLIST = ModTags.makeEntityTag("savagefang_target_blacklist");
    public static final ITag.INamedTag<EntityType<?>> SKELETON_GIRL_REPLACEABLES = ModTags.makeEntityTag("skeleton_girl_replaceables");
    public static final ITag.INamedTag<EntityType<?>> STRAY_GIRL_REPLACEABLES = ModTags.makeEntityTag("stray_girl_replaceables");
    public static final ITag.INamedTag<EntityType<?>> TIERED = ModTags.makeEntityTag("tiered");
    public static final ITag.INamedTag<EntityType<?>> WITHER_SKELETON_GIRL_REPLACEABLES = ModTags.makeEntityTag("wither_skeleton_girl_replaceables");
    public static final ITag.INamedTag<EntityType<?>> ZOMBIE_GIRL_REPLACEABLES = ModTags.makeEntityTag("zombie_girl_replaceables");
    public static final ResourceLocation FORGE_COPPER_INGOTS = new ResourceLocation("forge", "ingots/copper");
    public static final ResourceLocation FORGE_RUBY_GEMS = new ResourceLocation("forge", "gems/ruby");
    public static final ResourceLocation FORGE_SAPPHIRE_GEMS = new ResourceLocation("forge", "gems/sapphire");
    public static final ResourceLocation FORGE_SILVER_INGOTS = new ResourceLocation("forge", "ingots/silver");

    private static ITag.INamedTag<Block> makeBlockTag(String name) {
        return BlockTags.func_199894_a((String)("hmag:" + name));
    }

    private static ITag.INamedTag<Item> makeItemTag(String name) {
        return ItemTags.func_199901_a((String)("hmag:" + name));
    }

    private static ITag.INamedTag<EntityType<?>> makeEntityTag(String name) {
        return EntityTypeTags.func_232896_a_((String)("hmag:" + name));
    }

    @Nullable
    public static ITag<Item> getItemTag(ResourceLocation r) {
        return (ITag)ItemTags.func_199903_a().func_241833_a().get(r);
    }

    @Nullable
    public static Item getItem(ResourceLocation r) {
        return ModTags.getItem(ModTags.getItemTag(r));
    }

    @Nullable
    public static Item getItem(ITag<Item> tag) {
        List<Item> list;
        Item item = null;
        if (tag != null && (list = ModTags.getTagAllElements(tag)) != null && !list.isEmpty()) {
            item = list.get(0);
        }
        return item;
    }

    public static <T> boolean checkTagContains(ITag<T> tag, T value) {
        if (tag != null && value != null) {
            try {
                if (tag.func_230235_a_(value)) {
                    return true;
                }
            }
            catch (Exception e) {
                HMaG.LOGGER.warn("Broken tags -> " + tag.toString(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static <T> List<T> getTagAllElements(ITag<T> tag) {
        if (tag != null) {
            try {
                return tag.func_230236_b_();
            }
            catch (Exception e) {
                HMaG.LOGGER.warn("Broken tags -> " + tag.toString(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }
}

