/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.util;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TridentItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class ModUtils {
    public static final EquipmentSlotType[] ARMOR_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    public static final String LIVING_UPDATE_CHECKING_KEY = "hmag.checking";
    public static final String LIVING_UPDATE_CHECKED_KEY = "hmag.checked";
    public static final String LIVING_NOT_REPLACED_KEY = "hmag.notReplaced";
    public static final String WITH_SPAWN_PARTICLE_KEY = "hmag.withSpawnParticle";
    public static final String LEVEL_KEY = "hmag.level";

    public static void burnInDay(@Nonnull LivingEntity livingEntityIn, Random rand, Boolean isInDaylight, int seconds) {
        ModUtils.burnInDay(livingEntityIn, rand, isInDaylight, true, seconds);
    }

    public static void burnInDay(@Nonnull LivingEntity livingEntityIn, Random rand, Boolean isInDaylight, Boolean shouldBurn, int seconds) {
        if (livingEntityIn != null && livingEntityIn.field_70170_p != null && !livingEntityIn.field_70170_p.field_72995_K && livingEntityIn.func_70089_S()) {
            boolean flag;
            boolean bl = flag = isInDaylight != false && shouldBurn != false && !livingEntityIn.func_70026_G();
            if (flag) {
                ItemStack itemstack = livingEntityIn.func_184582_a(EquipmentSlotType.HEAD);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_196085_b(itemstack.func_77952_i() + rand.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            livingEntityIn.func_213361_c(EquipmentSlotType.HEAD);
                            livingEntityIn.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    livingEntityIn.func_70015_d(seconds);
                }
            }
        }
    }

    public static boolean canReach(@Nonnull LivingEntity livingEntityIn, Vector3d vector3dIn, int countIn) {
        AxisAlignedBB axisalignedbb = livingEntityIn.func_174813_aQ();
        for (int i = 1; i < countIn; ++i) {
            if (livingEntityIn.field_70170_p.func_226665_a__((Entity)livingEntityIn, axisalignedbb = axisalignedbb.func_191194_a(vector3dIn))) continue;
            return false;
        }
        return true;
    }

    public static boolean closerThan(Entity entity, BlockPos pos, int distance) {
        return pos.func_218141_a((Vector3i)entity.func_233580_cy_(), (double)distance);
    }

    public static boolean isDarkEnoughToSpawn(IServerWorld worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.func_226658_a_(LightType.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i <= randomIn.nextInt(8);
    }

    public static boolean isThornsDamage(DamageSource source) {
        return source == DamageSource.field_76367_g || source == DamageSource.field_220302_v || source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w();
    }

    public static float rotlerp(float f, float f1, float f2, boolean flag) {
        float f3 = MathHelper.func_76142_g((float)(f1 - f));
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        float f4 = f + f3;
        if (!flag) {
            return f4;
        }
        if (f4 < 0.0f) {
            f4 += 360.0f;
        } else if (f4 > 360.0f) {
            f4 -= 360.0f;
        }
        return f4;
    }

    public static float rotlerpRad(float f, float f1, float f2) {
        float f3 = (f2 - f1) % ((float)Math.PI * 2);
        if (f3 < (float)(-Math.PI)) {
            f3 += (float)Math.PI * 2;
        }
        if (f3 >= (float)Math.PI) {
            f3 -= (float)Math.PI * 2;
        }
        return f1 + f * f3;
    }

    public static float rotlerp2(float f, float f1, float f2) {
        while (f1 - f < -180.0f) {
            f -= 360.0f;
        }
        while (f1 - f >= 180.0f) {
            f += 360.0f;
        }
        return MathHelper.func_219799_g((float)f2, (float)f, (float)f1);
    }

    public static boolean matchItemBothHands(LivingEntity livingEntity, Item item) {
        for (Hand hand : Hand.values()) {
            ItemStack stack = livingEntity.func_184586_b(hand);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isBow(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return ModUtils.isBow(stack.func_77973_b());
        }
        return false;
    }

    public static boolean isBow(Item item) {
        return item != null && (item == Items.field_151031_f || item instanceof BowItem);
    }

    public static boolean isCrossbow(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return ModUtils.isCrossbow(stack.func_77973_b());
        }
        return false;
    }

    public static boolean isCrossbow(Item item) {
        return item != null && (item == Items.field_222114_py || item instanceof CrossbowItem);
    }

    public static boolean isTrident(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return ModUtils.isTrident(stack.func_77973_b());
        }
        return false;
    }

    public static boolean isTrident(Item item) {
        return item != null && (item == Items.field_203184_eO || item instanceof TridentItem);
    }

    public static ItemStack getPotionStack(Potion potion) {
        return ModUtils.getPotionStack(potion, Items.field_151068_bn);
    }

    public static ItemStack getPotionStack(Potion potion, Item containerItem) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)containerItem), (Potion)potion);
    }

    public static int getLevel(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_74764_b(LEVEL_KEY) ? (int)compoundnbt.func_74771_c(LEVEL_KEY) : 0;
    }

    public static void removeLevelTag(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_74764_b(LEVEL_KEY)) {
            compoundnbt.func_82580_o(LEVEL_KEY);
        }
    }

    public static boolean checkBiomeList(World worldIn, BlockPos pos, List<? extends String> list) {
        Biome biome;
        if (worldIn != null && (biome = worldIn.func_226691_t_(pos)) != null) {
            return ModUtils.checkList(biome.getRegistryName(), list);
        }
        return false;
    }

    public static boolean checkDimensionList(World worldIn, List<? extends String> list) {
        if (worldIn != null) {
            return ModUtils.checkDimensionList((RegistryKey<World>)worldIn.func_234923_W_(), list);
        }
        return false;
    }

    public static boolean checkDimensionList(RegistryKey<World> key, List<? extends String> list) {
        if (key != null) {
            return ModUtils.checkList(key.func_240901_a_(), list);
        }
        return false;
    }

    public static boolean checkList(ResourceLocation r, List<? extends String> list) {
        return r != null && list != null && !list.isEmpty() && list.contains(r.toString());
    }
}

