/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.util.ModUtils;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.NetherFortressFeature;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="hmag", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AddSpawnerDataEvents {
    private static WeightedRandomList<MobSpawnSettings.SpawnerData> DEFAULT_FORTRESS_ENEMIES;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceKey biomeKey;
        if (event.getName() != null && !ModUtils.checkList(event.getName(), ModConfigs.cachedServer.SPAWN_BIOME_BLACKLIST) && (biomeKey = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName())) != null) {
            boolean isVoid = BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.VOID);
            if (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && !isVoid || ModUtils.checkList(event.getName(), ModConfigs.cachedServer.SPAWN_OVERWORLD_BIOME_WHITELIST)) {
                if (ModConfigs.cachedServer.GHOST_SPAWN_WEIGHT > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.GHOST.get(), ModConfigs.cachedServer.GHOST_SPAWN_WEIGHT, 4, 4));
                }
                if (ModConfigs.cachedServer.KOBOLD_SPAWN_WEIGHT > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.KOBOLD.get(), ModConfigs.cachedServer.KOBOLD_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.LICH_SPAWN_WEIGHT > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.LICH.get(), ModConfigs.cachedServer.LICH_SPAWN_WEIGHT, 1, 1));
                }
                if (ModConfigs.cachedServer.OGRE_SPAWN_WEIGHT > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.OGRE.get(), ModConfigs.cachedServer.OGRE_SPAWN_WEIGHT, 1, 1));
                }
                if (ModConfigs.cachedServer.SPIDER_NEST_SPAWN_WEIGHT > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.SPIDER_NEST.get(), ModConfigs.cachedServer.SPIDER_NEST_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.CURSED_DOLL_SPAWN_WEIGHT > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.CURSED_DOLL.get(), ModConfigs.cachedServer.CURSED_DOLL_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.JACK_FROST_SPAWN_WEIGHT > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.JACK_FROST.get(), ModConfigs.cachedServer.JACK_FROST_SPAWN_WEIGHT, 1, 2));
                }
                if (!(ModConfigs.cachedServer.HORNET_SPAWN_WEIGHT <= 0 || !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY))) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.HORNET.get(), ModConfigs.cachedServer.HORNET_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.DULLAHAN_SPAWN_WEIGHT > 0 && (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY))) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.DULLAHAN.get(), ModConfigs.cachedServer.DULLAHAN_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.BANSHEE_SPAWN_WEIGHT > 0 && (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS))) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.BANSHEE.get(), ModConfigs.cachedServer.BANSHEE_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.ALRAUNE_SPAWN_WEIGHT > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.ALRAUNE.get(), ModConfigs.cachedServer.ALRAUNE_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.CATOBLEPAS_SPAWN_WEIGHT > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.CATOBLEPAS.get(), ModConfigs.cachedServer.CATOBLEPAS_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.SCORPION_SPAWN_WEIGHT > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.SCORPION.get(), ModConfigs.cachedServer.SCORPION_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.DOGU_SPAWN_WEIGHT > 0 && (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || biomeKey.m_135782_().toString().equals("magicalforest:magical_forest"))) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.DOGU.get(), ModConfigs.cachedServer.DOGU_SPAWN_WEIGHT, 1, 1));
                }
                if (ModConfigs.cachedServer.REDCAP_SPAWN_WEIGHT > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.REDCAP.get(), ModConfigs.cachedServer.REDCAP_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.SLIME_GIRL_SPAWN_WEIGHT > 0 && (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || biomeKey.m_135782_().toString().equals("magicalforest:magical_forest"))) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.SLIME_GIRL.get(), ModConfigs.cachedServer.SLIME_GIRL_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.DYSSOMNIA_SPAWN_WEIGHT > 0 && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.DYSSOMNIA.get(), ModConfigs.cachedServer.DYSSOMNIA_SPAWN_WEIGHT, 1, 1));
                }
                if (ModConfigs.cachedServer.SNOW_CANINE_SPAWN_WEIGHT > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.SNOW_CANINE.get(), ModConfigs.cachedServer.SNOW_CANINE_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.HARPY_SPAWN_WEIGHT > 0 && (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) && !BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.HARPY.get(), ModConfigs.cachedServer.HARPY_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.SAVAGEFANG_SPAWN_WEIGHT_IN_SWAMP > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.SAVAGEFANG.get(), ModConfigs.cachedServer.SAVAGEFANG_SPAWN_WEIGHT_IN_SWAMP, 6, 8));
                } else if (ModConfigs.cachedServer.SAVAGEFANG_SPAWN_WEIGHT_IN_JUNGLE > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.SAVAGEFANG.get(), ModConfigs.cachedServer.SAVAGEFANG_SPAWN_WEIGHT_IN_JUNGLE, 6, 8));
                }
                if (ModConfigs.cachedServer.NECROTIC_REAPER_SPAWN_WEIGHT > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.NECROTIC_REAPER.get(), ModConfigs.cachedServer.NECROTIC_REAPER_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.DODOMEKI_SPAWN_WEIGHT > 0 && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.DODOMEKI.get(), ModConfigs.cachedServer.DODOMEKI_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.GLARYAD_SPAWN_WEIGHT > 0 && biomeKey == Biomes.f_151785_) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.GLARYAD.get(), ModConfigs.cachedServer.GLARYAD_SPAWN_WEIGHT, 1, 2));
                }
                if (ModConfigs.cachedServer.MELTY_MONSTER_SPAWN_WEIGHT > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.MELTY_MONSTER.get(), ModConfigs.cachedServer.MELTY_MONSTER_SPAWN_WEIGHT, 1, 2));
                    event.getSpawns().m_48370_((EntityType)ModEntityTypes.MELTY_MONSTER.get(), 0.25, 0.25);
                }
            }
            if (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && !isVoid || ModUtils.checkList(event.getName(), ModConfigs.cachedServer.SPAWN_NETHER_BIOME_WHITELIST)) {
                if (biomeKey == Biomes.f_48199_) {
                    if (ModConfigs.cachedServer.WITHER_GHOST_SPAWN_WEIGHT_IN_SOUL_SAND_VALLEY > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.WITHER_GHOST.get(), ModConfigs.cachedServer.WITHER_GHOST_SPAWN_WEIGHT_IN_SOUL_SAND_VALLEY, 2, 2));
                        event.getSpawns().m_48370_((EntityType)ModEntityTypes.WITHER_GHOST.get(), 0.7, 0.15);
                    }
                    if (ModConfigs.cachedServer.KASHA_SPAWN_WEIGHT_IN_SOUL_SAND_VALLEY > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.KASHA.get(), ModConfigs.cachedServer.KASHA_SPAWN_WEIGHT_IN_SOUL_SAND_VALLEY, 1, 2));
                        event.getSpawns().m_48370_((EntityType)ModEntityTypes.KASHA.get(), 0.7, 0.15);
                    }
                    if (ModConfigs.cachedServer.GHASTLY_SEEKER_SPAWN_WEIGHT_IN_SOUL_SAND_VALLEY > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.GHASTLY_SEEKER.get(), ModConfigs.cachedServer.GHASTLY_SEEKER_SPAWN_WEIGHT_IN_SOUL_SAND_VALLEY, 1, 1));
                        event.getSpawns().m_48370_((EntityType)ModEntityTypes.GHASTLY_SEEKER.get(), 0.7, 0.15);
                    }
                } else if (biomeKey == Biomes.f_48175_) {
                    if (ModConfigs.cachedServer.WITHER_GHOST_SPAWN_WEIGHT_IN_BASALT_DELTAS > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.WITHER_GHOST.get(), ModConfigs.cachedServer.WITHER_GHOST_SPAWN_WEIGHT_IN_BASALT_DELTAS, 2, 2));
                    }
                    if (ModConfigs.cachedServer.KASHA_SPAWN_WEIGHT_IN_BASALT_DELTAS > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.KASHA.get(), ModConfigs.cachedServer.KASHA_SPAWN_WEIGHT_IN_BASALT_DELTAS, 1, 2));
                    }
                    if (ModConfigs.cachedServer.GHASTLY_SEEKER_SPAWN_WEIGHT_IN_BASALT_DELTAS > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.GHASTLY_SEEKER.get(), ModConfigs.cachedServer.GHASTLY_SEEKER_SPAWN_WEIGHT_IN_BASALT_DELTAS, 1, 1));
                    }
                    if (ModConfigs.cachedServer.IMP_SPAWN_WEIGHT_IN_BASALT_DELTAS > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.IMP.get(), ModConfigs.cachedServer.IMP_SPAWN_WEIGHT_IN_BASALT_DELTAS, 1, 2));
                    }
                } else if (biomeKey.m_135782_().toString().equals("biomesoplenty:withered_abyss")) {
                    if (ModConfigs.cachedServer.WITHER_GHOST_SPAWN_WEIGHT > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.WITHER_GHOST.get(), ModConfigs.cachedServer.WITHER_GHOST_SPAWN_WEIGHT, 1, 2));
                    }
                } else if (biomeKey != Biomes.f_48200_ && biomeKey != Biomes.f_48201_) {
                    if (ModConfigs.cachedServer.WITHER_GHOST_SPAWN_WEIGHT > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.WITHER_GHOST.get(), ModConfigs.cachedServer.WITHER_GHOST_SPAWN_WEIGHT, 2, 4));
                    }
                    if (ModConfigs.cachedServer.KASHA_SPAWN_WEIGHT > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.KASHA.get(), ModConfigs.cachedServer.KASHA_SPAWN_WEIGHT, 1, 2));
                    }
                    if (ModConfigs.cachedServer.GHASTLY_SEEKER_SPAWN_WEIGHT > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.GHASTLY_SEEKER.get(), ModConfigs.cachedServer.GHASTLY_SEEKER_SPAWN_WEIGHT, 1, 1));
                    }
                    if (ModConfigs.cachedServer.IMP_SPAWN_WEIGHT > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.IMP.get(), ModConfigs.cachedServer.IMP_SPAWN_WEIGHT, 1, 2));
                    }
                }
                if (biomeKey == Biomes.f_48200_ || biomeKey != Biomes.f_48201_ && BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                    if (ModConfigs.cachedServer.CRIMSON_SLAUGHTERER_SPAWN_WEIGHT > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.CRIMSON_SLAUGHTERER.get(), ModConfigs.cachedServer.CRIMSON_SLAUGHTERER_SPAWN_WEIGHT, 1, 1));
                    }
                    if (ModConfigs.cachedServer.IMP_SPAWN_WEIGHT_IN_CRIMSON_FOREST > 0) {
                        event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.IMP.get(), ModConfigs.cachedServer.IMP_SPAWN_WEIGHT_IN_CRIMSON_FOREST, 1, 2));
                    }
                }
                if (ModConfigs.cachedServer.MELTY_MONSTER_SPAWN_WEIGHT_IN_NETHER > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.MELTY_MONSTER.get(), ModConfigs.cachedServer.MELTY_MONSTER_SPAWN_WEIGHT_IN_NETHER, 1, 2));
                    if (biomeKey == Biomes.f_48199_) {
                        event.getSpawns().m_48370_((EntityType)ModEntityTypes.MELTY_MONSTER.get(), 0.7, 0.15);
                    } else if (biomeKey == Biomes.f_48201_) {
                        event.getSpawns().m_48370_((EntityType)ModEntityTypes.MELTY_MONSTER.get(), 1.0, 0.12);
                    } else {
                        event.getSpawns().m_48370_((EntityType)ModEntityTypes.MELTY_MONSTER.get(), 0.5, 0.15);
                    }
                }
            }
            if (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.END) && !isVoid || ModUtils.checkList(event.getName(), ModConfigs.cachedServer.SPAWN_END_BIOME_WHITELIST)) {
                if (ModConfigs.cachedServer.MONOLITH_SPAWN_WEIGHT > 0 && (biomeKey == Biomes.f_48165_ || biomeKey == Biomes.f_48162_)) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.MONOLITH.get(), ModConfigs.cachedServer.MONOLITH_SPAWN_WEIGHT, 1, 3));
                }
                if (ModConfigs.cachedServer.MELTY_MONSTER_SPAWN_WEIGHT_IN_END > 0) {
                    event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.MELTY_MONSTER.get(), ModConfigs.cachedServer.MELTY_MONSTER_SPAWN_WEIGHT_IN_END, 1, 2));
                    event.getSpawns().m_48370_((EntityType)ModEntityTypes.MELTY_MONSTER.get(), 0.25, 0.25);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        MinecraftServer server = event.getPlayerList().m_7873_();
        Registry registry = server.m_206579_().m_175515_(Registry.f_122882_);
        ConfiguredStructureFeature endCity = (ConfiguredStructureFeature)registry.m_6246_(BuiltinStructures.f_209861_);
        ConfiguredStructureFeature fortress = (ConfiguredStructureFeature)registry.m_6246_(BuiltinStructures.f_209859_);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<MobSpawnSettings.SpawnerData> fortressEnemyList = new ArrayList<MobSpawnSettings.SpawnerData>();
        if (DEFAULT_FORTRESS_ENEMIES == null) {
            DEFAULT_FORTRESS_ENEMIES = WeightedRandomList.m_146328_((List)NetherFortressFeature.f_66381_.m_146338_());
            flag = true;
        }
        if (endCity != null && ModConfigs.cachedServer.MONOLITH_SPAWN_WEIGHT_IN_END_CITY > 0) {
            AddSpawnerDataEvents.addSpawnToStructure(endCity, StructureSpawnOverride.BoundingBoxType.PIECE, MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.MONOLITH.get(), ModConfigs.cachedServer.MONOLITH_SPAWN_WEIGHT_IN_END_CITY, 1, 1));
        }
        if (fortress != null && ModConfigs.cachedServer.FORTRESS_KEEPER_SPAWN_WEIGHT_IN_NETHER_FORTRESS > 0) {
            MobSpawnSettings.SpawnerData data = new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.FORTRESS_KEEPER.get(), ModConfigs.cachedServer.FORTRESS_KEEPER_SPAWN_WEIGHT_IN_NETHER_FORTRESS, 1, 1);
            AddSpawnerDataEvents.addSpawnToStructure(fortress, StructureSpawnOverride.BoundingBoxType.PIECE, MobCategory.MONSTER, data);
            fortressEnemyList.add(data);
        }
        if (!fortressEnemyList.isEmpty()) {
            AddSpawnerDataEvents.addFortressEnemies(fortressEnemyList);
            flag1 = true;
        }
        if (!flag && !flag1) {
            NetherFortressFeature.f_66381_ = WeightedRandomList.m_146328_((List)DEFAULT_FORTRESS_ENEMIES.m_146338_());
        }
    }

    private static void addSpawnToStructure(ConfiguredStructureFeature<?, ?> feature, StructureSpawnOverride.BoundingBoxType bbType, MobCategory category, MobSpawnSettings.SpawnerData spawnerData) {
        if (feature.f_209744_.isEmpty() || feature.f_209744_.get(category) == null) {
            WeightedRandomList spawns = WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{spawnerData});
            StructureSpawnOverride override = new StructureSpawnOverride(bbType, spawns);
            HashMap<MobCategory, StructureSpawnOverride> newMap = new HashMap<MobCategory, StructureSpawnOverride>(feature.f_209744_);
            newMap.put(category, override);
            feature.f_209744_ = ImmutableMap.copyOf(newMap);
        } else {
            StructureSpawnOverride override1 = (StructureSpawnOverride)feature.f_209744_.get(category);
            ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>(override1.f_210044_().m_146338_());
            boolean flag = false;
            for (MobSpawnSettings.SpawnerData data : list) {
                if (!data.f_48404_.equals(spawnerData.f_48404_)) continue;
                flag = true;
            }
            if (!flag) {
                list.add(spawnerData);
            }
            WeightedRandomList spawns = WeightedRandomList.m_146328_(list);
            StructureSpawnOverride override2 = new StructureSpawnOverride(override1.f_210043_(), spawns);
            HashMap<MobCategory, StructureSpawnOverride> newMap = new HashMap<MobCategory, StructureSpawnOverride>(feature.f_209744_);
            newMap.put(category, override2);
            feature.f_209744_ = ImmutableMap.copyOf(newMap);
        }
    }

    private static void addFortressEnemies(List<MobSpawnSettings.SpawnerData> additionalSpawnerDataList) {
        WeightedRandomList fortressEnemies;
        ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>(NetherFortressFeature.f_66381_.m_146338_());
        for (MobSpawnSettings.SpawnerData additionalSpawnData : additionalSpawnerDataList) {
            boolean flag = false;
            for (MobSpawnSettings.SpawnerData data : list) {
                if (!data.f_48404_.equals(additionalSpawnData.f_48404_)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            list.add(additionalSpawnData);
        }
        NetherFortressFeature.f_66381_ = fortressEnemies = WeightedRandomList.m_146328_(list);
    }
}

