/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag;

import com.github.mechalopa.hmag.ModConfigs;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hmag", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModLootTableLoadingEvent {
    private static final List<String> CHEST_TABLES = ImmutableList.of((Object)"abandoned_mineshaft", (Object)"bastion_hoglin_stable", (Object)"bastion_other", (Object)"bastion_treasure", (Object)"buried_treasure", (Object)"desert_pyramid", (Object)"end_city_treasure", (Object)"igloo_chest", (Object)"jungle_temple_dispenser", (Object)"jungle_temple", (Object)"nether_bridge", (Object)"pillager_outpost", (Object[])new String[]{"ruined_portal", "simple_dungeon", "stronghold_corridor", "stronghold_crossing", "stronghold_library", "underwater_ruin_big", "woodland_mansion", "village/village_armorer", "village/village_temple", "village/village_toolsmith", "village/village_weaponsmith"});

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName() != null && event.getTable() != null && ModConfigs.cachedServer.ADDITIONAL_CHEST_LOOTS) {
            String prefix = "minecraft:chests/";
            String name = event.getName().toString();
            if (name.startsWith(prefix) && CHEST_TABLES.contains(name.substring(prefix.length()))) {
                String file = name.substring("minecraft:".length());
                event.getTable().addPool(ModLootTableLoadingEvent.getInjectPool(file));
            }
        }
    }

    private static LootPool getInjectPool(String name) {
        return LootPool.m_79043_().m_79076_(ModLootTableLoadingEvent.getInjectEntry(name)).name("hmag_inject").m_79082_();
    }

    private static LootPoolEntryContainer.Builder<?> getInjectEntry(String name) {
        ResourceLocation r = new ResourceLocation("hmag", "inject/" + name);
        return LootTableReference.m_79776_((ResourceLocation)r).m_79707_(1);
    }
}

