/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.model.AbstractGirlModel;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.EnderExecutorEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnderExecutorModel<T extends EnderExecutorEntity>
extends AbstractGirlModel<T> {
    private ModelPart bust;
    private ModelPart rightHair1;
    private ModelPart leftHair1;
    private ModelPart rightHair2;
    private ModelPart leftHair2;
    public boolean creepy;
    public boolean carrying;
    public boolean beamAttacking;
    private float animationAmount;

    public EnderExecutorModel(ModelPart modelPart) {
        super(modelPart);
        this.bust = this.f_102810_.m_171324_("bust");
        this.rightHair1 = this.f_102808_.m_171324_("right_hair_1");
        this.leftHair1 = this.f_102808_.m_171324_("left_hair_1");
        this.rightHair2 = this.rightHair1.m_171324_("right_hair_2");
        this.leftHair2 = this.leftHair1.m_171324_("left_hair_2");
    }

    public static MeshDefinition createMesh(CubeDeformation cd) {
        float f = -14.0f;
        MeshDefinition md = AbstractGirlModel.createMesh(cd, f);
        PartDefinition pd = md.m_171576_();
        PartDefinition rapd = ModClientUtils.addC(pd, cd, "right_arm", 40, 16, 0.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, -5.0f, 2.0f + f, 0.0f);
        PartDefinition lapd = ModClientUtils.addC(pd, cd, "left_arm", 40, 16, -2.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, 5.0f, 2.0f + f, 0.0f, true);
        ModClientUtils.addC(rapd, cd, "right_arm_part_1", 0, 40, -0.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, 0.0f, 3.0f, 0.0f);
        ModClientUtils.addC(lapd, cd, "left_arm_part_1", 0, 40, -2.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, 0.0f, 3.0f, 0.0f, true);
        ModClientUtils.addC(rapd, cd, "right_arm_part_2", 0, 40, -0.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, 0.0f, 7.0f, 0.0f);
        ModClientUtils.addC(lapd, cd, "left_arm_part_2", 0, 40, -2.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, 0.0f, 7.0f, 0.0f, true);
        PartDefinition rlpd = ModClientUtils.addC(pd, cd, "right_leg", 16, 32, -1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f, -2.0f, 12.0f + f, 0.0f);
        PartDefinition llpd = ModClientUtils.addC(pd, cd, "left_leg", 16, 32, -1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f, 2.0f, 12.0f + f, 0.0f, true);
        ModClientUtils.addC(rlpd, cd, "right_leg_part_1", 0, 44, -1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, 0.0f, 16.0f, 0.0f);
        ModClientUtils.addC(llpd, cd, "left_leg_part_1", 0, 44, -1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, 0.0f, 16.0f, 0.0f, true);
        ModClientUtils.addC(rlpd, cd, "right_leg_part_2", 0, 44, -1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, 0.0f, 18.0f, 0.0f);
        ModClientUtils.addC(llpd, cd, "left_leg_part_2", 0, 44, -1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, 0.0f, 18.0f, 0.0f, true);
        PartDefinition bodypd = pd.m_171597_("body");
        ModClientUtils.addC(bodypd, cd, "bust", 0, 32, -3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f, 0.0f, 3.5f, -1.1f, -0.001f);
        ModClientUtils.addC(bodypd, cd, "skirt_1", 0, 64, -3.5f, 0.0f, -2.0f, 7.0f, 2.0f, 4.0f, 0.0f, 11.0f, 0.0f);
        PartDefinition s2pd = ModClientUtils.addC(bodypd, cd, "skirt_2", 24, 64, -4.0f, 0.0f, -2.5f, 8.0f, 2.0f, 5.0f, 0.0f, 13.0f, 0.0f);
        PartDefinition s3pd = ModClientUtils.addC(s2pd, cd, "skirt_3", 0, 72, -4.5f, 0.0f, -3.0f, 9.0f, 2.0f, 6.0f, 0.0f, 2.0f, 0.0f);
        PartDefinition s4pd = ModClientUtils.addC(s3pd, cd, "skirt_4", 0, 80, -5.0f, 0.0f, -3.5f, 10.0f, 2.0f, 7.0f, 0.0f, 2.0f, 0.0f);
        ModClientUtils.addC(s4pd, cd, "skirt_5", 0, 92, -5.5f, 0.0f, -4.0f, 11.0f, 3.0f, 8.0f, 0.0f, 2.0f, 0.0f);
        PartDefinition headpd = pd.m_171597_("head");
        PartDefinition rhpd = ModClientUtils.addC(headpd, cd, "right_hair_1", 24, 32, -1.0f, -1.5f, -1.0f, 2.0f, 14.0f, 2.0f, -4.25f, -8.0f, 3.5f);
        PartDefinition lhpd = ModClientUtils.addC(headpd, cd, "left_hair_1", 24, 32, -1.0f, -1.5f, -1.0f, 2.0f, 14.0f, 2.0f, 4.25f, -8.0f, 3.5f, true);
        ModClientUtils.addC(rhpd, cd, "right_hair_2", 32, 32, -1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f, 12.5f, 0.0f);
        ModClientUtils.addC(lhpd, cd, "left_hair_2", 32, 32, -1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f, 12.5f, 0.0f, true);
        return md;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)EnderExecutorModel.createMesh(CubeDeformation.f_171458_), (int)64, (int)128);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.animationAmount = ((EnderExecutorEntity)entityIn).getAttackAnimationScale(partialTick);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.f_102808_.f_104207_ = true;
        float f = -14.0f;
        this.f_102810_.f_104203_ = 0.0f;
        this.f_102810_.f_104201_ = f;
        this.f_102810_.f_104202_ = 0.0f;
        this.f_102813_.f_104203_ = (float)((double)this.f_102813_.f_104203_ * 0.5);
        this.f_102814_.f_104203_ = (float)((double)this.f_102814_.f_104203_ * 0.5);
        float f1 = 0.21f;
        if (this.f_102813_.f_104203_ > f1) {
            this.f_102813_.f_104203_ = f1;
        }
        if (this.f_102814_.f_104203_ > f1) {
            this.f_102814_.f_104203_ = f1;
        }
        if (this.f_102813_.f_104203_ < -f1) {
            this.f_102813_.f_104203_ = -f1;
        }
        if (this.f_102814_.f_104203_ < -f1) {
            this.f_102814_.f_104203_ = -f1;
        }
        this.f_102813_.f_104202_ = 0.0f;
        this.f_102814_.f_104202_ = 0.0f;
        this.f_102813_.f_104201_ = 9.0f + f;
        this.f_102814_.f_104201_ = 9.0f + f;
        this.f_102808_.f_104202_ = 0.0f;
        this.f_102808_.f_104201_ = f;
        this.f_102809_.m_104315_(this.f_102808_);
        if (this.creepy) {
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
            float f3 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102811_.f_104204_ = -(5.0f - f2 * 0.6f);
            this.f_102812_.f_104204_ = 5.0f - f2 * 0.6f;
            this.f_102811_.f_104203_ = -1.5707964f;
            this.f_102812_.f_104203_ = -1.5707964f;
            this.f_102811_.f_104203_ -= f2 * 1.2f - f3 * 0.4f;
            this.f_102812_.f_104203_ -= f2 * 1.2f - f3 * 0.4f;
            this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.25f - 0.6f;
            this.f_102812_.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.25f - 0.6f;
            this.f_102811_.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            this.f_102812_.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        } else if (this.carrying) {
            if (entityIn.m_5737_() != HumanoidArm.RIGHT) {
                this.f_102811_.f_104203_ = Mth.m_14031_((float)(ageInTicks * 0.09f)) * 0.03f + 0.34906587f;
                this.f_102811_.f_104205_ = -(Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.125f - 0.62831855f);
            } else {
                this.f_102812_.f_104203_ = Mth.m_14031_((float)(ageInTicks * 0.09f)) * 0.03f + 0.34906587f;
                this.f_102812_.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.125f - 0.62831855f;
            }
        }
        this.bust.f_104203_ = 0.95993114f;
        this.f_102811_.m_104227_(-5.0f, 2.0f + f, 0.0f);
        this.f_102812_.m_104227_(5.0f, 2.0f + f, 0.0f);
        this.rightHair1.f_104203_ = 0.17453294f;
        this.leftHair1.f_104203_ = 0.17453294f;
        this.rightHair1.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.06f)) * 0.03f;
        this.leftHair1.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.06f)) * 0.03f;
        this.rightHair2.f_104203_ = 0.09817477f;
        this.leftHair2.f_104203_ = 0.09817477f;
        this.rightHair1.f_104205_ = 0.34906587f;
        this.leftHair1.f_104205_ = -0.34906587f;
        this.rightHair1.f_104205_ -= Mth.m_14031_((float)(ageInTicks * 0.09f)) * 0.03f;
        this.leftHair1.f_104205_ += Mth.m_14031_((float)(ageInTicks * 0.09f)) * 0.03f;
        this.rightHair2.f_104205_ = 0.116355285f;
        this.leftHair2.f_104205_ = -0.116355285f;
        this.rightHair2.f_104205_ -= Mth.m_14031_((float)(ageInTicks * 0.09f + 0.7853982f)) * 0.024f;
        this.leftHair2.f_104205_ += Mth.m_14031_((float)(ageInTicks * 0.09f + 0.7853982f)) * 0.024f;
        if (this.animationAmount > 0.0f) {
            this.rightHair1.f_104205_ += Mth.m_14031_((float)(this.animationAmount * this.animationAmount * 2.6179938f)) * 0.75f;
            this.leftHair1.f_104205_ -= Mth.m_14031_((float)(this.animationAmount * this.animationAmount * 2.6179938f)) * 0.75f;
        }
    }
}

