/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.OgreEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OgreModel<T extends OgreEntity>
extends HumanoidModel<T> {
    private ModelPart horn1;
    private ModelPart horn2;
    private ModelPart bodyPart1;
    private ModelPart bodyPart2;
    private ModelPart bodyPart3;
    private ModelPart rightArmPart1;
    private ModelPart leftArmPart1;
    private ModelPart rightArmPart2;
    private ModelPart leftArmPart2;
    private ModelPart rightArmPart3;
    private ModelPart leftArmPart3;
    private ModelPart rightArmPart3A;
    private ModelPart leftArmPart3A;
    private ModelPart rightArmPart3B;
    private ModelPart leftArmPart3B;
    private ModelPart rightLegPart;
    private ModelPart leftLegPart;
    private float swingAmount;

    public OgreModel(ModelPart modelPart) {
        super(modelPart);
        this.horn1 = this.f_102808_.m_171324_("horn_1");
        this.horn2 = this.horn1.m_171324_("horn_2");
        this.bodyPart1 = this.f_102810_.m_171324_("body_part_1");
        this.bodyPart2 = this.f_102810_.m_171324_("body_part_2");
        this.bodyPart3 = this.bodyPart2.m_171324_("body_part_3");
        this.rightArmPart1 = this.f_102811_.m_171324_("right_arm_part_1");
        this.leftArmPart1 = this.f_102812_.m_171324_("left_arm_part_1");
        this.rightArmPart2 = this.rightArmPart1.m_171324_("right_arm_part_2");
        this.leftArmPart2 = this.leftArmPart1.m_171324_("left_arm_part_2");
        this.rightArmPart3 = this.f_102811_.m_171324_("right_arm_part_3");
        this.leftArmPart3 = this.f_102812_.m_171324_("left_arm_part_3");
        this.rightArmPart3A = this.rightArmPart3.m_171324_("right_arm_part_3a");
        this.leftArmPart3A = this.leftArmPart3.m_171324_("left_arm_part_3a");
        this.rightArmPart3B = this.rightArmPart3.m_171324_("right_arm_part_3b");
        this.leftArmPart3B = this.leftArmPart3.m_171324_("left_arm_part_3b");
        this.rightLegPart = this.f_102813_.m_171324_("right_leg_part");
        this.leftLegPart = this.f_102814_.m_171324_("left_leg_part");
    }

    public static LayerDefinition createBodyLayer() {
        float f = -5.0f;
        MeshDefinition md = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)f);
        PartDefinition pd = md.m_171576_();
        PartDefinition headpd = ModClientUtils.addC(pd, "head", 0, 0, -5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, 0.0f, 0.0f + f, 0.0f);
        ModClientUtils.addC(pd, "hat", 0, 0, -0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f + f, 0.0f);
        PartDefinition horn1pd = ModClientUtils.addC(headpd, "horn_1", 40, 16, -1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.0f, -7.75f, 0.5f);
        ModClientUtils.addC(horn1pd, "horn_2", 48, 16, -0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, -3.0f, 0.0f);
        PartDefinition bodypd = ModClientUtils.addC(pd, "body", 0, 16, -6.0f, 0.0f, -3.0f, 12.0f, 6.0f, 6.0f, 0.0f, 0.0f + f, 0.0f);
        ModClientUtils.addC(bodypd, "body_part_1", 0, 56, -6.5f, 0.0f, -3.5f, 13.0f, 6.0f, 7.0f, 0.0f, 6.0f, 0.0f);
        PartDefinition bodypart2pd = ModClientUtils.addC(bodypd, "body_part_2", 0, 72, -7.0f, 0.0f, -4.0f, 14.0f, 5.0f, 8.0f, 0.0f, 12.0f, 0.0f);
        ModClientUtils.addC(bodypart2pd, "body_part_3", 0, 88, -7.0f, 0.0f, -4.0f, 14.0f, 3.0f, 8.0f, 0.0f, 5.0f, 0.0f);
        PartDefinition rapd = ModClientUtils.addC(pd, "right_arm", 24, 32, -6.0f, -2.0f, -2.0f, 5.0f, 8.0f, 4.0f, -5.0f, 2.0f + f, 0.0f);
        PartDefinition lapd = ModClientUtils.addC(pd, "left_arm", 24, 32, 1.0f, -2.0f, -2.0f, 5.0f, 8.0f, 4.0f, 5.0f, 2.0f + f, 0.0f, true);
        PartDefinition rap1pd = ModClientUtils.addC(rapd, "right_arm_part_1", 42, 32, -6.5f, 0.0f, -2.5f, 6.0f, 6.0f, 5.0f, 0.0f, 6.0f, 0.0f);
        PartDefinition lap1pd = ModClientUtils.addC(lapd, "left_arm_part_1", 42, 32, 0.5f, 0.0f, -2.5f, 6.0f, 6.0f, 5.0f, 0.0f, 6.0f, 0.0f, true);
        ModClientUtils.addC(rap1pd, "right_arm_part_2", 40, 56, -2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, -6.25f, 2.9f, 0.0f);
        ModClientUtils.addC(lap1pd, "left_arm_part_2", 40, 56, 0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, 6.25f, 2.9f, 0.0f, true);
        PartDefinition rap3pd = ModClientUtils.addC(rapd, "right_arm_part_3", 40, 48, -6.5f, 0.0f, -3.0f, 6.0f, 2.0f, 6.0f, 0.5f, -2.5f, 0.0f, 0.5f);
        PartDefinition lap3pd = ModClientUtils.addC(lapd, "left_arm_part_3", 40, 48, 0.5f, 0.0f, -3.0f, 6.0f, 2.0f, 6.0f, -0.5f, -2.5f, 0.0f, true, 0.5f);
        ModClientUtils.addC(rap3pd, "right_arm_part_3a", 24, 48, -1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, -3.5f, -0.25f, 0.0f);
        ModClientUtils.addC(lap3pd, "left_arm_part_3a", 24, 48, -1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, 3.5f, -0.25f, 0.0f, true);
        ModClientUtils.addC(rap3pd, "right_arm_part_3b", 24, 48, -1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, -6.25f, 0.75f, 0.0f);
        ModClientUtils.addC(lap3pd, "left_arm_part_3b", 24, 48, -1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, 6.25f, 0.75f, 0.0f, true);
        PartDefinition rlpd = ModClientUtils.addC(pd, "right_leg", 0, 32, -2.5f, 0.0f, -2.0f, 5.0f, 6.0f, 4.0f, -3.5f, 17.0f + f, 0.0f);
        PartDefinition llpd = ModClientUtils.addC(pd, "left_leg", 0, 32, -2.5f, 0.0f, -2.0f, 5.0f, 6.0f, 4.0f, 3.5f, 17.0f + f, 0.0f, true);
        ModClientUtils.addC(rlpd, "right_leg_part", 0, 42, -3.0f, 0.0f, -2.5f, 6.0f, 6.0f, 5.0f, 0.0f, 6.0f, 0.0f);
        ModClientUtils.addC(llpd, "left_leg_part", 0, 42, -3.0f, 0.0f, -2.5f, 6.0f, 6.0f, 5.0f, 0.0f, 6.0f, 0.0f, true);
        return LayerDefinition.m_171565_((MeshDefinition)md, (int)64, (int)128);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.swingAmount = ((OgreEntity)entityIn).getAnimationScale(partialTick);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f;
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.f_102810_.f_104201_ = f = -5.0f;
        this.f_102808_.f_104201_ = f;
        this.f_102809_.f_104201_ = f;
        this.f_102811_.m_104227_(-5.0f, 2.0f + f, 0.0f);
        this.f_102812_.m_104227_(5.0f, 2.0f + f, 0.0f);
        this.f_102813_.f_104201_ = 17.0f + f;
        this.f_102814_.f_104201_ = 17.0f + f;
        this.f_102811_.f_104205_ = 0.10471976f;
        this.f_102812_.f_104205_ = -0.10471976f;
        this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.03f;
        this.f_102812_.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.03f;
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        if (this.swingAmount > 0.0f) {
            this.f_102811_.f_104203_ *= 1.0f - this.swingAmount;
            this.f_102812_.f_104203_ *= 1.0f - this.swingAmount;
            this.f_102811_.f_104203_ += -(this.swingAmount * 1.7951958f);
            this.f_102812_.f_104203_ += -(this.swingAmount * 1.7951958f);
        }
        this.rightArmPart3A.f_104205_ = -0.17453294f;
        this.leftArmPart3A.f_104205_ = 0.17453294f;
        this.rightArmPart3B.f_104205_ = -1.0471976f;
        this.leftArmPart3B.f_104205_ = 1.0471976f;
        this.horn2.f_104203_ = 0.0f;
        this.bodyPart1.f_104203_ = 0.0f;
        this.bodyPart3.f_104203_ = 0.0f;
        this.rightArmPart2.f_104203_ = 0.0f;
        this.leftArmPart2.f_104203_ = 0.0f;
        this.rightLegPart.f_104203_ = 0.0f;
        this.leftLegPart.f_104203_ = 0.0f;
    }
}

