/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.SavagefangEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SavagefangModel<T extends SavagefangEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart upperJaw;
    private final ModelPart upperFang;
    private final ModelPart lowerJaw;
    private final ModelPart lowerFang;
    private final ModelPart barbel0;
    private final ModelPart barbel1;
    private final ModelPart sideFin0;
    private final ModelPart sideFin1;
    private final ModelPart tailFinBase;
    private float animationAmount;

    public SavagefangModel(ModelPart modelPart) {
        this.root = modelPart;
        this.head = modelPart.m_171324_("head");
        this.upperJaw = this.head.m_171324_("upper_jaw");
        this.upperFang = this.upperJaw.m_171324_("upper_fang");
        this.lowerJaw = this.head.m_171324_("lower_jaw");
        this.lowerFang = this.lowerJaw.m_171324_("lower_fang");
        this.barbel0 = this.lowerJaw.m_171324_("barbel_0");
        this.barbel1 = this.lowerJaw.m_171324_("barbel_1");
        this.sideFin0 = modelPart.m_171324_("side_fin_0");
        this.sideFin1 = modelPart.m_171324_("side_fin_1");
        this.tailFinBase = modelPart.m_171324_("tail_fin_base");
    }

    public static LayerDefinition createBodyLayer() {
        float f = 21.0f;
        MeshDefinition md = new MeshDefinition();
        PartDefinition pd = md.m_171576_();
        ModClientUtils.addC(pd, "body", 0, 10, -2.5f, -4.0f, 0.0f, 5.0f, 8.0f, 4.0f, 0.0f, f, -1.0f);
        PartDefinition headpd = ModClientUtils.addC(pd, "head", 0, 0, -2.0f, -3.5f, -2.0f, 4.0f, 7.0f, 2.0f, 0.0f, f, -1.0f, 0.001f);
        PartDefinition upjawpd = ModClientUtils.addC(headpd, "upper_jaw", 12, 0, -2.0f, -3.0f, -3.0f, 4.0f, 3.0f, 3.0f, 0.0f, 0.0f, -1.5f);
        ModClientUtils.addC(upjawpd, "upper_jaw_part", 12, 6, -2.0f, -2.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, 0.0f, -3.0f);
        ModClientUtils.addC(upjawpd, "upper_fang", 26, 0, -2.0f, 0.0f, -4.0f, 4.0f, 1.0f, 4.0f, 0.0f, -0.5f, 0.0f, -0.001f);
        PartDefinition lowjawpd = ModClientUtils.addC(headpd, "lower_jaw", 24, 8, -2.5f, 0.0f, -4.75f, 5.0f, 2.0f, 5.0f, 0.0f, 0.0f, -1.75f);
        ModClientUtils.addC(lowjawpd, "lower_fang", 24, 16, -2.5f, -2.0f, -4.75f, 5.0f, 2.0f, 5.0f, 0.0f, 0.5f, 0.0f, -0.001f);
        ModClientUtils.addC(lowjawpd, "barbel_0", 48, 0, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 2.0f, -2.75f);
        ModClientUtils.addC(lowjawpd, "barbel_1", 48, 2, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 2.0f, -2.75f);
        PartDefinition nose1pd = ModClientUtils.addC(pd, "nose_1", 0, 22, -2.0f, -3.0f, 0.0f, 4.0f, 6.0f, 1.0f, 0.0f, f, 3.0f);
        ModClientUtils.addC(nose1pd, "nose_2", 10, 22, -2.0f, -3.0f, 0.0f, 4.0f, 5.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        ModClientUtils.addC(pd, "side_fin_0", 40, 32, -4.0f, 0.0f, -2.0f, 4.0f, 0.0f, 4.0f, -2.5f, f, 0.0f);
        ModClientUtils.addC(pd, "side_fin_1", 40, 40, 0.0f, 0.0f, -2.0f, 4.0f, 0.0f, 4.0f, 2.5f, f, 0.0f);
        PartDefinition tailfinbasepd = ModClientUtils.addC(pd, "tail_fin_base", 48, 8, -0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, 0.0f, f - 1.0f, 5.0f);
        ModClientUtils.addC(tailfinbasepd, "tail_fin", 48, 12, 0.0f, -3.5f, 0.0f, 0.0f, 8.0f, 5.0f, 0.0f, 0.0f, 1.0f);
        ModClientUtils.addC(pd, "top_fin", 0, 30, 0.0f, -2.0f, -4.0f, 0.0f, 3.0f, 8.0f, 0.0f, f - 4.0f, 2.0f);
        ModClientUtils.addC(pd, "bottom_fin", 24, 24, 0.0f, -1.0f, -2.0f, 0.0f, 3.0f, 4.0f, 0.0f, f + 4.0f, 3.0f);
        return LayerDefinition.m_171565_((MeshDefinition)md, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.animationAmount = Mth.m_14036_((float)((SavagefangEntity)entityIn).getAttackAnimationScale(partialTick), (float)0.0f, (float)1.0f);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f;
        if (!entityIn.m_20069_()) {
            f = 1.5f;
        }
        this.tailFinBase.f_104204_ = -f * 0.45f * Mth.m_14031_((float)(0.6f * ageInTicks));
        this.sideFin0.f_104205_ = -(0.62831855f + 0.15f * Mth.m_14089_((float)(0.6f * ageInTicks)));
        this.sideFin1.f_104205_ = -this.sideFin0.f_104205_;
        this.upperJaw.f_104203_ = -0.12f * Math.abs(Mth.m_14089_((float)(0.45f * ageInTicks))) * this.animationAmount;
        this.lowerJaw.f_104203_ = -0.10471976f;
        this.lowerJaw.f_104203_ += 0.9f * Math.abs(Mth.m_14089_((float)(0.45f * ageInTicks))) * this.animationAmount;
        this.upperFang.f_104201_ = -0.5f + 0.375f * this.animationAmount;
        this.lowerFang.f_104201_ = 0.5f - 0.375f * this.animationAmount;
        this.barbel0.f_104205_ = 0.20943952f + 0.12f * Mth.m_14089_((float)(0.12f * ageInTicks));
        this.barbel1.f_104205_ = -this.barbel0.f_104205_;
    }
}

