/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.SpiderNestEntity;
import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpiderNestModel<T extends SpiderNestEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart leg5;
    private final ModelPart leg6;
    private final ModelPart leg7;
    private final ModelPart leg8;
    private final ModelPart bodyPart3;
    private final ModelPart bodyPart4;
    private final ModelPart bodyPart5;
    private final ModelPart bodyPart6;
    private final ModelPart bodyPart7;
    private final ModelPart bodyPart8;
    private final ModelPart[] bodyPartsRightA = new ModelPart[4];
    private final ModelPart[] bodyPartsLeftA = new ModelPart[4];

    public SpiderNestModel(ModelPart modelPart) {
        this.root = modelPart;
        this.head = modelPart.m_171324_("head");
        this.body = modelPart.m_171324_("body");
        this.leg1 = modelPart.m_171324_("leg_1");
        this.leg2 = modelPart.m_171324_("leg_2");
        this.leg3 = modelPart.m_171324_("leg_3");
        this.leg4 = modelPart.m_171324_("leg_4");
        this.leg5 = modelPart.m_171324_("leg_5");
        this.leg6 = modelPart.m_171324_("leg_6");
        this.leg7 = modelPart.m_171324_("leg_7");
        this.leg8 = modelPart.m_171324_("leg_8");
        this.bodyPart3 = this.body.m_171324_("body_part_3");
        this.bodyPart4 = this.body.m_171324_("body_part_4");
        this.bodyPart5 = this.body.m_171324_("body_part_5");
        this.bodyPart6 = this.body.m_171324_("body_part_6");
        this.bodyPart7 = this.body.m_171324_("body_part_7");
        this.bodyPart8 = this.body.m_171324_("body_part_8");
        Arrays.setAll(this.bodyPartsRightA, p -> this.body.m_171324_("body_part_right_a" + p));
        Arrays.setAll(this.bodyPartsLeftA, p -> this.body.m_171324_("body_part_left_a" + p));
    }

    public static LayerDefinition createBodyLayer() {
        int k;
        float f = 8.0f;
        float f1 = 7.0f;
        float f2 = 8.5f;
        MeshDefinition md = new MeshDefinition();
        PartDefinition pd = md.m_171576_();
        ModClientUtils.addC(pd, "head", 0, 0, -4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 6.0f, 0.0f, 15.0f, -8.0f);
        PartDefinition bodypd = ModClientUtils.addC(pd, "body", 0, 16, -7.0f, -11.0f, -8.0f, 14.0f, 16.0f, 16.0f, 0.0f, 14.0f, 0.0f);
        ModClientUtils.addC(bodypd, "body_part_1", 0, 64, -8.0f, -8.0f, -7.0f, 16.0f, 16.0f, 14.0f, 0.0f, -3.0f, 0.0f);
        ModClientUtils.addC(bodypd, "body_part_2", 0, 96, -7.0f, -9.0f, -7.0f, 14.0f, 18.0f, 14.0f, 0.0f, -3.0f, 0.0f);
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(0, 48).m_171481_(-1.0f, -0.5f, -1.0f, 2.0f, f, 2.0f);
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171481_(-1.0f, -0.5f, -1.0f, 2.0f, f, 2.0f);
        PartDefinition l1pd = pd.m_171599_("leg_1", cubelistbuilder, PartPose.m_171419_((float)(-f2), (float)f1, (float)-6.0f));
        PartDefinition l2pd = pd.m_171599_("leg_2", cubelistbuilder1, PartPose.m_171419_((float)f2, (float)f1, (float)-6.0f));
        PartDefinition l3pd = pd.m_171599_("leg_3", cubelistbuilder, PartPose.m_171419_((float)(-f2), (float)f1, (float)-2.0f));
        PartDefinition l4pd = pd.m_171599_("leg_4", cubelistbuilder1, PartPose.m_171419_((float)f2, (float)f1, (float)-2.0f));
        PartDefinition l5pd = pd.m_171599_("leg_5", cubelistbuilder, PartPose.m_171419_((float)(-f2), (float)f1, (float)2.0f));
        PartDefinition l6pd = pd.m_171599_("leg_6", cubelistbuilder1, PartPose.m_171419_((float)f2, (float)f1, (float)2.0f));
        PartDefinition l7pd = pd.m_171599_("leg_7", cubelistbuilder, PartPose.m_171419_((float)(-f2), (float)f1, (float)6.0f));
        PartDefinition l8pd = pd.m_171599_("leg_8", cubelistbuilder1, PartPose.m_171419_((float)f2, (float)f1, (float)6.0f));
        CubeListBuilder cubelistbuilder2 = CubeListBuilder.m_171558_().m_171514_(8, 48).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(-0.25f));
        CubeListBuilder cubelistbuilder3 = CubeListBuilder.m_171558_().m_171514_(8, 48).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(-0.25f));
        PartPose pp = PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f);
        l1pd.m_171599_("leg_1_part_1", cubelistbuilder2, pp);
        l2pd.m_171599_("leg_2_part_1", cubelistbuilder3, pp);
        l3pd.m_171599_("leg_3_part_1", cubelistbuilder2, pp);
        l4pd.m_171599_("leg_4_part_1", cubelistbuilder3, pp);
        l5pd.m_171599_("leg_5_part_1", cubelistbuilder2, pp);
        l6pd.m_171599_("leg_6_part_1", cubelistbuilder3, pp);
        l7pd.m_171599_("leg_7_part_1", cubelistbuilder2, pp);
        l8pd.m_171599_("leg_8_part_1", cubelistbuilder3, pp);
        CubeListBuilder cubelistbuilder4 = CubeListBuilder.m_171558_().m_171514_(20, 48).m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 11.0f, 3.0f);
        CubeListBuilder cubelistbuilder5 = CubeListBuilder.m_171558_().m_171514_(20, 48).m_171480_().m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 11.0f, 3.0f);
        PartPose pp1 = PartPose.m_171419_((float)0.0f, (float)f, (float)0.0f);
        l1pd.m_171599_("leg_1_part_2", cubelistbuilder4, pp1);
        l2pd.m_171599_("leg_2_part_2", cubelistbuilder5, pp1);
        l3pd.m_171599_("leg_3_part_2", cubelistbuilder4, pp1);
        l4pd.m_171599_("leg_4_part_2", cubelistbuilder5, pp1);
        l5pd.m_171599_("leg_5_part_2", cubelistbuilder4, pp1);
        l6pd.m_171599_("leg_6_part_2", cubelistbuilder5, pp1);
        l7pd.m_171599_("leg_7_part_2", cubelistbuilder4, pp1);
        l8pd.m_171599_("leg_8_part_2", cubelistbuilder5, pp1);
        ModClientUtils.addC(bodypd, "body_part_3", 32, 48, -2.0f, -4.5f, -1.0f, 4.0f, 5.0f, 3.0f, -1.0f, -11.0f, -3.5f, true);
        ModClientUtils.addC(bodypd, "body_part_4", 32, 48, -2.0f, -4.5f, -1.0f, 4.0f, 5.0f, 3.0f, 3.0f, -11.5f, 3.5f);
        ModClientUtils.addC(bodypd, "body_part_5", 32, 48, -2.0f, -4.5f, -1.0f, 4.0f, 5.0f, 3.0f, -4.5f, -11.0f, 7.0f, true);
        ModClientUtils.addC(bodypd, "body_part_6", 48, 48, -2.0f, -7.5f, -1.0f, 4.0f, 8.0f, 3.0f, 1.0f, -6.0f, 8.0f, true);
        ModClientUtils.addC(bodypd, "body_part_7", 48, 48, -2.0f, -7.5f, -1.0f, 4.0f, 8.0f, 3.0f, -4.0f, 0.0f, 8.0f, true);
        ModClientUtils.addC(bodypd, "body_part_8", 48, 48, -2.0f, -7.5f, -1.0f, 4.0f, 8.0f, 3.0f, 4.5f, 2.0f, 8.0f);
        CubeListBuilder cubelistbuilder6 = CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-1.0f, -2.5f, -1.0f, 2.0f, 3.0f, 2.0f);
        CubeListBuilder cubelistbuilder7 = CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(-0.25f));
        CubeListBuilder cubelistbuilder8 = CubeListBuilder.m_171558_().m_171514_(32, 0).m_171480_().m_171481_(-1.0f, -2.5f, -1.0f, 2.0f, 3.0f, 2.0f);
        CubeListBuilder cubelistbuilder9 = CubeListBuilder.m_171558_().m_171514_(40, 0).m_171480_().m_171488_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(-0.25f));
        PartPose pp2 = PartPose.f_171404_;
        for (k = 0; k < 4; ++k) {
            PartPose pp3 = PartPose.m_171419_((float)7.5f, (float)(-9.0f - (float)k * 0.25f), (float)(-4.5f + (float)k * 3.0f));
            PartDefinition bprapd = bodypd.m_171599_("body_part_right_a" + k, cubelistbuilder6, pp3);
            bprapd.m_171599_("body_part_right_b" + k, cubelistbuilder7, pp2);
        }
        for (k = 0; k < 4; ++k) {
            PartPose pp4 = PartPose.m_171419_((float)-7.5f, (float)(-9.0f - (float)k * 0.25f), (float)(-4.5f + (float)k * 3.0f));
            PartDefinition bplapd = bodypd.m_171599_("body_part_left_a" + k, cubelistbuilder8, pp4);
            bplapd.m_171599_("body_part_left_b" + k, cubelistbuilder9, pp2);
        }
        return LayerDefinition.m_171565_((MeshDefinition)md, (int)64, (int)128);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int i;
        if (((SpiderNestEntity)entityIn).isCharging()) {
            this.head.f_104205_ = ageInTicks * 1.2f % 57.295776f * (entityIn.m_5737_() == HumanoidArm.RIGHT ? 1.0f : -1.0f);
            this.head.f_104204_ = 0.0f;
            this.head.f_104203_ = 0.0f;
        } else {
            this.head.f_104205_ = 0.0f;
            this.head.f_104204_ = netHeadYaw / 57.295776f;
            this.head.f_104203_ = headPitch / 57.295776f;
        }
        float f = 0.15707964f;
        float f1 = 0.06544985f;
        float f2 = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount;
        float f3 = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.7f * limbSwingAmount;
        float f4 = Mth.m_14089_((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.7f * limbSwingAmount;
        float f5 = Mth.m_14089_((float)(limbSwing * 0.6662f + 4.712389f)) * 0.7f * limbSwingAmount;
        float f6 = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + 0.0f)) * 0.1f) * limbSwingAmount;
        float f7 = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.1f) * limbSwingAmount;
        float f8 = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.1f) * limbSwingAmount;
        float f9 = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + 4.712389f)) * 0.1f) * limbSwingAmount;
        float f10 = 0.17453294f;
        float f11 = 0.31415927f;
        this.leg1.f_104203_ = -f - f2;
        this.leg2.f_104203_ = -f + f2;
        this.leg3.f_104203_ = -f1 - f3;
        this.leg4.f_104203_ = -f1 + f3;
        this.leg5.f_104203_ = f1 - f4;
        this.leg6.f_104203_ = f1 + f4;
        this.leg7.f_104203_ = f - f5;
        this.leg8.f_104203_ = f + f5;
        this.leg1.f_104205_ = f10 + f6;
        this.leg2.f_104205_ = -f10 - f6;
        this.leg3.f_104205_ = f11 + f7;
        this.leg4.f_104205_ = -f11 - f7;
        this.leg5.f_104205_ = f11 + f8;
        this.leg6.f_104205_ = -f11 - f8;
        this.leg7.f_104205_ = f10 + f9;
        this.leg8.f_104205_ = -f10 - f9;
        this.bodyPart3.f_104203_ = -0.34906587f;
        this.bodyPart4.f_104203_ = -0.34906587f;
        this.bodyPart5.f_104203_ = -0.34906587f;
        this.bodyPart3.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f - 0.28559935f)) * 0.12f;
        this.bodyPart4.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f + 1.2566371f)) * 0.12f;
        this.bodyPart5.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f - 0.69813174f)) * 0.12f;
        this.bodyPart3.f_104205_ = -0.08726647f;
        this.bodyPart4.f_104205_ = 0.10471976f;
        this.bodyPart5.f_104205_ = -0.06544985f;
        this.bodyPart3.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.045f - 0.28559935f)) * 0.033f;
        this.bodyPart4.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.045f + 1.2566371f)) * 0.033f;
        this.bodyPart5.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.045f - 0.69813174f)) * 0.033f;
        this.bodyPart6.f_104203_ = -0.31415927f;
        this.bodyPart7.f_104203_ = -0.31415927f;
        this.bodyPart8.f_104203_ = -0.31415927f;
        this.bodyPart6.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f - 0.5890486f)) * 0.12f;
        this.bodyPart7.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f - 1.3962635f)) * 0.12f;
        this.bodyPart8.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f + 1.5707964f)) * 0.12f;
        this.bodyPart6.f_104205_ = -0.05235988f;
        this.bodyPart7.f_104205_ = -0.08726647f;
        this.bodyPart8.f_104205_ = 0.06544985f;
        this.bodyPart6.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.045f - 0.5890486f)) * 0.033f;
        this.bodyPart7.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.045f - 1.3962635f)) * 0.033f;
        this.bodyPart8.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.045f + 1.5707964f)) * 0.033f;
        for (i = 0; i < this.bodyPartsRightA.length; ++i) {
            this.bodyPartsRightA[i].f_104203_ = -((float)Math.PI * (float)(i - 2) / 15.0f);
            this.bodyPartsRightA[i].f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.06f + (float)Math.PI * (float)i / 3.0f)) * 0.15f;
            this.bodyPartsRightA[i].f_104205_ = 0.69813174f;
            this.bodyPartsRightA[i].f_104205_ += Mth.m_14031_((float)(ageInTicks * 0.06f + (float)Math.PI * (float)(i + 4) / 3.0f)) * 0.3f;
        }
        for (i = 0; i < this.bodyPartsLeftA.length; ++i) {
            this.bodyPartsLeftA[i].f_104203_ = -((float)Math.PI * (float)(i - 2) / 15.0f);
            this.bodyPartsLeftA[i].f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.06f + (float)Math.PI * (float)i / 3.0f)) * 0.15f;
            this.bodyPartsLeftA[i].f_104205_ = -0.69813174f;
            this.bodyPartsLeftA[i].f_104205_ -= Mth.m_14031_((float)(ageInTicks * 0.06f + (float)Math.PI * (float)(i + 4) / 3.0f)) * 0.3f;
        }
    }
}

