/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.ModModelLayers;
import com.github.mechalopa.hmag.client.model.EnderExecutorModel;
import com.github.mechalopa.hmag.client.renderer.layers.EnderExecutorCarriedBlockLayer;
import com.github.mechalopa.hmag.client.renderer.layers.EnderExecutorEyesLayer;
import com.github.mechalopa.hmag.client.renderer.layers.ItemInHandLayer2;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.EnderExecutorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnderExecutorRenderer
extends MobRenderer<EnderExecutorEntity, EnderExecutorModel<EnderExecutorEntity>> {
    private static final ResourceLocation TEX = new ResourceLocation("hmag", "textures/entity/ender_executor.png");
    private static final ResourceLocation BEAM_TEX = new ResourceLocation("hmag", "textures/entity/ender_executor_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)BEAM_TEX);
    private final Random rand = new Random();

    public EnderExecutorRenderer(EntityRendererProvider.Context context) {
        super(context, new EnderExecutorModel(context.m_174023_(ModModelLayers.ENDER_EXECUTOR)), 0.5f);
        this.m_115326_(new EnderExecutorEyesLayer(this));
        this.m_115326_((RenderLayer)new ItemInHandLayer2(this, -1));
        this.m_115326_(new EnderExecutorCarriedBlockLayer((RenderLayerParent<EnderExecutorEntity, EnderExecutorModel<EnderExecutorEntity>>)this));
    }

    public boolean shouldRender(EnderExecutorEntity entity, Frustum camera, double camX, double camY, double camZ) {
        if (super.m_5523_((Mob)entity, camera, camX, camY, camZ)) {
            return true;
        }
        return ModClientUtils.shouldRenderBeamAttackMob((LivingEntity)entity, camera, camX, camY, camZ, entity);
    }

    public void render(EnderExecutorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        BlockState blockstate = entity.m_32530_();
        EnderExecutorModel endermanmodel = (EnderExecutorModel)this.m_7200_();
        endermanmodel.carrying = blockstate != null;
        endermanmodel.creepy = entity.m_32531_();
        LivingEntity target = entity.getActiveAttackTarget();
        endermanmodel.beamAttacking = entity.hasActiveAttackTarget() && target != null;
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        if (entity.m_6084_() && target != null) {
            float f = entity.getAttackAnimationScale(partialTicks);
            float f1 = (float)(entity.f_19853_.m_46467_() % 24000L) + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entity.m_20192_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)f3 + (double)entity.m_20206_() * 0.05, 0.0);
            Vec3 vec3 = ModClientUtils.getPosition(target, (double)target.m_20206_() * 0.5, partialTicks);
            Vec3 vec31 = ModClientUtils.getPosition((LivingEntity)entity, f3, partialTicks);
            Vec3 vec32 = vec3.m_82546_(vec31);
            float f4 = (float)(vec32.m_82553_() + 1.0);
            vec32 = vec32.m_82541_();
            float f5 = (float)Math.acos(vec32.f_82480_);
            float f6 = (float)Math.atan2(vec32.f_82481_, vec32.f_82479_);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((1.5707964f - f6) * 57.295776f));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f5 * 57.295776f));
            float f7 = 0.0f;
            float f8 = f * f;
            int i = 200 + (int)(f8 * 4.0f);
            int j = 235 - (int)(f8 * 141.0f);
            int k = 235 + (int)(f8 * 17.0f);
            float f11 = Mth.m_14089_((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = Mth.m_14031_((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = Mth.m_14089_((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = Mth.m_14031_((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = Mth.m_14089_((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = Mth.m_14031_((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = Mth.m_14089_((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = Mth.m_14031_((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = Mth.m_14089_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = Mth.m_14031_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = Mth.m_14089_((float)(f7 + 0.0f)) * 0.2f;
            float f22 = Mth.m_14031_((float)(f7 + 0.0f)) * 0.2f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            VertexConsumer vertexconsumer = buffer.m_6299_(BEAM_RENDER_TYPE);
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_85861_();
            Matrix3f matrix3f = posestack$pose.m_85864_();
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f19, f4, f20, i, j, k, 0.5f, f30);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f19, 0.0f, f20, i, j, k, 0.5f, f29);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f21, 0.0f, f22, i, j, k, 0.0f, f29);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f21, f4, f22, i, j, k, 0.0f, f30);
            float f31 = entity.f_19797_ % 2 == 0 ? 0.5f : 0.0f;
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f11, f4, f12, i, j, k, 0.5f, f31 + 0.5f);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f13, f4, f14, i, j, k, 1.0f, f31 + 0.5f);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f17, f4, f18, i, j, k, 1.0f, f31);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f15, f4, f16, i, j, k, 0.5f, f31);
            poseStack.m_85849_();
        }
    }

    public Vec3 getRenderOffset(EnderExecutorEntity entity, float partialTicks) {
        if (entity.m_32531_()) {
            return new Vec3(this.rand.nextGaussian() * 0.02, 0.0, this.rand.nextGaussian() * 0.02);
        }
        return super.m_7860_((Entity)entity, partialTicks);
    }

    public ResourceLocation getTextureLocation(EnderExecutorEntity entity) {
        return TEX;
    }
}

