/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.world.entity.projectile.MagicBulletEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagicBulletRenderer
extends EntityRenderer<MagicBulletEntity> {
    private static final ResourceLocation TEX0 = new ResourceLocation("hmag", "textures/entity/projectile/magic_bullet_0.png");
    private static final ResourceLocation TEX1 = new ResourceLocation("hmag", "textures/entity/projectile/magic_bullet_1.png");
    private static final ResourceLocation TEX2 = new ResourceLocation("hmag", "textures/entity/projectile/magic_bullet_2.png");

    public MagicBulletRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getBlockLightLevel(MagicBulletEntity entity, BlockPos pos) {
        switch (entity.getVariant()) {
            case 1: {
                return Mth.m_14045_((int)(super.m_6086_((Entity)entity, pos) + 7), (int)0, (int)15);
            }
        }
        return 15;
    }

    public void render(MagicBulletEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        poseStack.m_85845_(this.f_114476_.m_114470_());
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        float f = (float)entity.f_19797_ + partialTicks;
        float f1 = 0.5f + (entity.getVariant() == 2 ? Mth.m_14031_((float)(f * 0.8f)) * 0.03f : Mth.m_14031_((float)(f * 0.4f)) * 0.09f);
        poseStack.m_85841_(f1, f1, f1);
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_85861_();
        Matrix3f matrix3f = posestack$pose.m_85864_();
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 0, 0, 1);
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 0, 1, 1);
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 1, 1, 0);
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void drawVertex(VertexConsumer vertexConsumer, Matrix4f matrix, Matrix3f normals, int packedLightIn, float f, int i, int j, int k) {
        vertexConsumer.m_85982_(matrix, f - 0.5f, (float)i - 0.25f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)j, (float)k).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(MagicBulletEntity entity) {
        switch (entity.getVariant()) {
            case 1: {
                return TEX1;
            }
            case 2: {
                return TEX2;
            }
        }
        return TEX0;
    }
}

