/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer.layers;

import com.github.mechalopa.hmag.client.ModModelLayers;
import com.github.mechalopa.hmag.client.model.GhostModel;
import com.github.mechalopa.hmag.client.renderer.layers.AbstractClothingLayer;
import com.github.mechalopa.hmag.world.entity.GhostEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GhostClothingLayer
extends AbstractClothingLayer<GhostEntity, GhostModel<GhostEntity>> {
    private static final ResourceLocation TEX0 = new ResourceLocation("hmag", "textures/entity/ghost_skin_0.png");
    private static final ResourceLocation TEX1 = new ResourceLocation("hmag", "textures/entity/ghost_skin_1.png");
    private static final ResourceLocation TEX2 = new ResourceLocation("hmag", "textures/entity/ghost_skin_2.png");
    private static final ResourceLocation TEX3 = new ResourceLocation("hmag", "textures/entity/ghost_skin_3.png");
    private static final ResourceLocation TEX4 = new ResourceLocation("hmag", "textures/entity/ghost_skin_4.png");
    private final GhostModel<GhostEntity> model;

    public GhostClothingLayer(RenderLayerParent<GhostEntity, GhostModel<GhostEntity>> renderLayerParent, EntityModelSet modelSet) {
        super(renderLayerParent);
        this.model = new GhostModel(modelSet.m_171103_(ModModelLayers.GHOST));
    }

    @Override
    protected float getAlpha(GhostEntity entity) {
        return 0.625f;
    }

    @Override
    protected EntityModel<GhostEntity> getLayerModel() {
        return this.model;
    }

    @Override
    public ResourceLocation getLayerTexture(GhostEntity entity) {
        switch (entity.getVariant()) {
            case 1: {
                return TEX1;
            }
            case 2: {
                return TEX2;
            }
            case 3: {
                return TEX3;
            }
            case 4: {
                return TEX4;
            }
        }
        return TEX0;
    }
}

