/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.util;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ModUtils {
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final String LIVING_UPDATE_CHECKING_KEY = "hmag.checking";
    public static final String LIVING_UPDATE_CHECKED_KEY = "hmag.checked";
    public static final String LIVING_NOT_REPLACED_KEY = "hmag.notReplaced";
    public static final String WITH_SPAWN_PARTICLE_KEY = "hmag.withSpawnParticle";

    public static void burnInDay(@Nonnull LivingEntity livingEntityIn, Random rand, Boolean isSunBurnTick, int seconds) {
        ModUtils.burnInDay(livingEntityIn, rand, isSunBurnTick, true, seconds);
    }

    public static void burnInDay(@Nonnull LivingEntity livingEntityIn, Random rand, Boolean isSunBurnTick, Boolean shouldBurn, int seconds) {
        if (livingEntityIn != null && livingEntityIn.f_19853_ != null && !livingEntityIn.f_19853_.f_46443_ && livingEntityIn.m_6084_()) {
            boolean flag;
            boolean bl = flag = isSunBurnTick != false && shouldBurn != false && !livingEntityIn.m_20070_();
            if (flag) {
                ItemStack itemstack = livingEntityIn.m_6844_(EquipmentSlot.HEAD);
                if (!itemstack.m_41619_()) {
                    if (itemstack.m_41763_()) {
                        itemstack.m_41721_(itemstack.m_41773_() + rand.nextInt(2));
                        if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                            livingEntityIn.m_21166_(EquipmentSlot.HEAD);
                            livingEntityIn.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    livingEntityIn.m_20254_(seconds);
                }
            }
        }
    }

    public static boolean canReach(@Nonnull LivingEntity livingEntityIn, Vec3 vec3In, int countIn) {
        AABB axisalignedbb = livingEntityIn.m_142469_();
        for (int i = 1; i < countIn; ++i) {
            if (livingEntityIn.f_19853_.m_45756_((Entity)livingEntityIn, axisalignedbb = axisalignedbb.m_82383_(vec3In))) continue;
            return false;
        }
        return true;
    }

    public static boolean closerThan(Entity entity, BlockPos pos, int distance) {
        return pos.m_123314_((Vec3i)entity.m_142538_(), (double)distance);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor levelAccessor, BlockPos pos, Random randomIn) {
        if (levelAccessor.m_45517_(LightLayer.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        if (levelAccessor.m_45517_(LightLayer.BLOCK, pos) > 0) {
            return false;
        }
        int i = levelAccessor.m_6018_().m_46470_() ? levelAccessor.m_46849_(pos, 10) : levelAccessor.m_46803_(pos);
        return i <= randomIn.nextInt(8);
    }

    public static boolean isThornsDamage(DamageSource source) {
        return source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || source instanceof EntityDamageSource && ((EntityDamageSource)source).m_19403_();
    }

    public static boolean isStalagmiteDamage(DamageSource source) {
        return source == DamageSource.f_146703_ || source == DamageSource.f_146702_;
    }

    public static float rotlerp(float f, float f1, float f2, boolean flag) {
        float f3 = Mth.m_14177_((float)(f1 - f));
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        float f4 = f + f3;
        if (!flag) {
            return f4;
        }
        if (f4 < 0.0f) {
            f4 += 360.0f;
        } else if (f4 > 360.0f) {
            f4 -= 360.0f;
        }
        return f4;
    }

    public static float rotlerpRad(float f, float f1, float f2) {
        float f3 = (f2 - f1) % ((float)Math.PI * 2);
        if (f3 < (float)(-Math.PI)) {
            f3 += (float)Math.PI * 2;
        }
        if (f3 >= (float)Math.PI) {
            f3 -= (float)Math.PI * 2;
        }
        return f1 + f * f3;
    }

    public static float rotlerp2(float f, float f1, float f2) {
        while (f1 - f < -180.0f) {
            f -= 360.0f;
        }
        while (f1 - f >= 180.0f) {
            f += 360.0f;
        }
        return Mth.m_14179_((float)f2, (float)f, (float)f1);
    }

    public static boolean matchItemBothHands(LivingEntity livingEntity, Item item) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = livingEntity.m_21120_(hand);
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isBow(ItemStack stack) {
        if (!stack.m_41619_()) {
            return ModUtils.isBow(stack.m_41720_());
        }
        return false;
    }

    public static boolean isBow(Item item) {
        return item != null && (item == Items.f_42411_ || item instanceof BowItem);
    }

    public static boolean isCrossbow(ItemStack stack) {
        if (!stack.m_41619_()) {
            return ModUtils.isCrossbow(stack.m_41720_());
        }
        return false;
    }

    public static boolean isCrossbow(Item item) {
        return item != null && (item == Items.f_42717_ || item instanceof CrossbowItem);
    }

    public static boolean isTrident(ItemStack stack) {
        if (!stack.m_41619_()) {
            return ModUtils.isTrident(stack.m_41720_());
        }
        return false;
    }

    public static boolean isTrident(Item item) {
        return item != null && (item == Items.f_42713_ || item instanceof TridentItem);
    }

    public static ItemStack getPotionStack(Potion potion) {
        return ModUtils.getPotionStack(potion, Items.f_42589_);
    }

    public static ItemStack getPotionStack(Potion potion, Item containerItem) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)containerItem), (Potion)potion);
    }

    public static boolean checkBiomeList(Level worldIn, BlockPos pos, List<? extends String> list) {
        Holder biome;
        if (worldIn != null && (biome = worldIn.m_204166_(pos)) != null) {
            return ModUtils.checkList(((Biome)biome.m_203334_()).getRegistryName(), list);
        }
        return false;
    }

    public static boolean checkDimensionList(Level worldIn, List<? extends String> list) {
        if (worldIn != null) {
            return ModUtils.checkDimensionList((ResourceKey<Level>)worldIn.m_46472_(), list);
        }
        return false;
    }

    public static boolean checkDimensionList(ResourceKey<Level> key, List<? extends String> list) {
        if (key != null) {
            return ModUtils.checkList(key.m_135782_(), list);
        }
        return false;
    }

    public static boolean checkList(ResourceLocation r, List<? extends String> list) {
        return r != null && list != null && !list.isEmpty() && list.contains(r.toString());
    }
}

