/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModSpawnRules;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.entity.IModMob;
import com.github.mechalopa.hmag.world.entity.ai.goal.HurtByTargetGoal2;
import com.github.mechalopa.hmag.world.entity.projectile.MagicBulletEntity;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class DyssomniaEntity
extends FlyingMob
implements Enemy,
IModMob {
    private static final EntityDataAccessor<Byte> ATTACK_PHASE = SynchedEntityData.m_135353_(DyssomniaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ATTACKING_TIME = SynchedEntityData.m_135353_(DyssomniaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RETREATING = SynchedEntityData.m_135353_(DyssomniaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float xRotAnimation;
    private float xRotAnimationO;
    private int animationTick;
    private int animationTickO;

    public DyssomniaEntity(EntityType<? extends DyssomniaEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 25;
        this.f_21342_ = new DyssomniaMoveControl(this);
        this.f_21365_ = new DyssomniaLookControl((Mob)this);
    }

    protected BodyRotationControl m_7560_() {
        return new DyssomniaBodyRotationControl((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAroundGoal(this));
        if (ModConfigs.cachedServer.DYSSOMNIA_SUMMON_PHANTOM) {
            this.f_21345_.m_25352_(7, (Goal)new SummonGoal(this));
        }
        this.f_21345_.m_25352_(8, (Goal)new ShotAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal2((Mob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(180));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_PHASE, (Object)0);
        this.f_19804_.m_135372_(ATTACKING_TIME, (Object)-1);
        this.f_19804_.m_135372_(RETREATING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 32.0);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            this.xRotAnimationO = this.xRotAnimation;
            this.animationTickO = this.animationTick;
        }
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.m_142049_() * 3 + this.f_19797_) * 0.13f + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.m_142049_() * 3 + this.f_19797_ + 1) * 0.13f + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.nextFloat() * 0.05f, 0.95f + this.f_19796_.nextFloat() * 0.05f, false);
            }
            boolean flag = this.isActuallyRetreating();
            for (int i = 0; i < 3; ++i) {
                float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * ((float)i * 0.4f + 1.7f);
                float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * ((float)i * 0.4f + 1.7f);
                float f4 = 0.4f + f * ((float)i * 0.05f + 0.5f);
                if (flag && this.f_19797_ % 12 == i * 3) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
                    continue;
                }
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
            }
            if (this.getAttackingTime() >= 0) {
                if (this.getAttackPhase() == AttackPhase.SHOT) {
                    double d0 = 1.75;
                    double d1 = 1.5;
                    Vec3 vec3 = this.m_20252_(1.0f);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + vec3.f_82479_ * d0, this.m_20188_() - vec3.f_82480_ * d1, this.m_20189_() + vec3.f_82481_ * d0, 0.0, 0.0, 0.0);
                }
                if (this.animationTick < 30) {
                    ++this.animationTick;
                }
            } else if (this.animationTick > 0) {
                this.animationTick = Math.max(this.animationTick - 2, 0);
            }
            this.xRotAnimation = Mth.m_14036_((float)ModUtils.rotlerp(this.xRotAnimation, this.m_146909_(), 90.0f, false), (float)-180.0f, (float)180.0f);
        }
    }

    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_21525_()) {
            if (!this.isRetreating() && this.m_21527_()) {
                this.setRetreating(true);
            } else if (this.isRetreating() && this.isStopRetreatTick()) {
                this.setRetreating(false);
            }
        }
        super.m_8107_();
    }

    private boolean isStopRetreatTick() {
        float f;
        return this.f_19853_.m_46462_() && !this.f_19853_.f_46443_ && (f = this.m_6073_()) <= 0.5f && this.f_19796_.nextFloat() * 30.0f < (0.6f - f) * 2.0f;
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        if (potioneffectIn.m_19544_() == MobEffects.f_19610_) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(potioneffectIn);
    }

    private void summonPhantom(ServerLevel serverlevel, LivingEntity attacker, LivingEntity target, Random random, int count) {
        boolean flag = false;
        for (int i = 0; i < count; ++i) {
            double d1 = attacker.m_20185_() + (random.nextDouble() - random.nextDouble()) * 3.0;
            double d2 = attacker.m_20186_() + 0.5;
            double d3 = attacker.m_20189_() + (random.nextDouble() - random.nextDouble()) * 3.0;
            Phantom phantom = (Phantom)EntityType.f_20509_.m_20615_(attacker.f_19853_);
            phantom.m_7678_(d1, d2, d3, this.m_146908_() + (random.nextFloat() - 0.5f) * 12.0f, 0.0f);
            phantom.m_6518_((ServerLevelAccessor)serverlevel, attacker.f_19853_.m_6436_(attacker.m_142538_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
            serverlevel.m_47205_((Entity)phantom);
            phantom.getPersistentData().m_128379_("hmag.withSpawnParticle", true);
            if (!this.m_6060_()) continue;
            phantom.m_20254_(this.m_20094_() / 20 + 2);
            flag = true;
        }
        if (flag) {
            this.m_20095_();
        }
        attacker.f_19853_.m_46796_(2004, attacker.m_142538_(), 0);
        attacker.m_5496_((SoundEvent)ModSoundEvents.DYSSOMNIA_SUMMON.get(), 5.0f, 1.0f);
    }

    public static boolean checkDyssomniaSpawnRules(EntityType<DyssomniaEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random randomIn) {
        return ModSpawnRules.checkMobSpawnInLightRules(type, levelAccessor, spawnType, pos, randomIn) && (spawnType == MobSpawnType.SPAWNER || levelAccessor.m_45527_(pos) && randomIn.nextFloat() < levelAccessor.m_46940_());
    }

    public AttackPhase getAttackPhase() {
        return AttackPhase.byId(((Byte)this.f_19804_.m_135370_(ATTACK_PHASE)).byteValue());
    }

    private void setAttackPhase(AttackPhase phase) {
        this.f_19804_.m_135381_(ATTACK_PHASE, (Object)((byte)(phase.getId() & 0xFF)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackingTime() {
        return (Integer)this.f_19804_.m_135370_(ATTACKING_TIME);
    }

    private void setAttackingTime(int value) {
        this.f_19804_.m_135381_(ATTACKING_TIME, (Object)value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getXRotAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)(this.xRotAnimationO / 180.0f), (float)(this.xRotAnimation / 180.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)((float)this.animationTickO / 30.0f), (float)((float)this.animationTick / 30.0f));
    }

    public boolean isRetreating() {
        return (Boolean)this.f_19804_.m_135370_(RETREATING);
    }

    public void setRetreating(boolean flag) {
        this.f_19804_.m_135381_(RETREATING, (Object)flag);
    }

    public boolean isActuallyRetreating() {
        return this.isRetreating() && !this.m_21532_() && !this.m_8023_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRetreating(compound.m_128471_("isRetreating"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isRetreating", this.isRetreating());
    }

    protected boolean m_8028_() {
        return true;
    }

    public int m_5792_() {
        return 1;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.45f;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.DYSSOMNIA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.DYSSOMNIA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.DYSSOMNIA_DEATH.get();
    }

    protected float m_6121_() {
        return 2.0f;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected class DyssomniaMoveControl
    extends MoveControl {
        private final DyssomniaEntity parent;
        private int floatDuration;

        public DyssomniaMoveControl(DyssomniaEntity mob) {
            super((Mob)mob);
            this.parent = mob;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.parent.m_21187_().nextInt(5) + 5;
                Vec3 vec3 = new Vec3(this.f_24975_ - this.parent.m_20185_(), this.f_24976_ - this.parent.m_20186_(), this.f_24977_ - this.parent.m_20189_());
                double d0 = vec3.m_82553_();
                if (ModUtils.canReach((LivingEntity)this.parent, vec3 = vec3.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.parent.m_20256_(this.parent.m_20184_().m_82549_(vec3.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }
    }

    protected class DyssomniaLookControl
    extends LookControl {
        public DyssomniaLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
        }
    }

    protected class DyssomniaBodyRotationControl
    extends BodyRotationControl {
        public DyssomniaBodyRotationControl(Mob mob) {
            super(mob);
        }

        public void m_8121_() {
            DyssomniaEntity.this.f_20885_ = DyssomniaEntity.this.f_20883_;
            DyssomniaEntity.this.f_20883_ = DyssomniaEntity.this.m_146908_();
        }
    }

    private static class RandomFlyGoal
    extends Goal {
        private final DyssomniaEntity parent;

        public RandomFlyGoal(DyssomniaEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movecontrol = this.parent.m_21566_();
            if (!movecontrol.m_24995_()) {
                return true;
            }
            double d0 = movecontrol.m_25000_() - this.parent.m_20185_();
            double d3 = d0 * d0 + (d1 = movecontrol.m_25001_() - this.parent.m_20186_()) * d1 + (d2 = movecontrol.m_25002_() - this.parent.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Random random = this.parent.m_21187_();
            BlockPos blockpos = new BlockPos(this.parent.m_20185_(), (double)Math.round(this.parent.m_20186_()), this.parent.m_20189_());
            boolean flag = this.parent.isActuallyRetreating();
            double d0 = this.parent.m_20185_();
            double d1 = this.parent.m_20186_();
            double d2 = this.parent.m_20189_();
            if (flag && this.parent.f_19853_.m_45527_(blockpos) && blockpos.m_123342_() < this.parent.f_19853_.m_151558_() + 64) {
                d0 += (double)((random.nextFloat() * 2.0f - 1.0f) * 8.0f);
                d1 += (double)(random.nextFloat() * 4.0f + 8.0f);
                d2 += (double)((random.nextFloat() * 2.0f - 1.0f) * 8.0f);
            } else {
                LivingEntity target;
                double distance;
                boolean flag1 = false;
                if (this.parent.m_5448_() != null && (distance = (target = this.parent.m_5448_()).m_20280_((Entity)this.parent)) < 4096.0) {
                    Vec3 vec3 = target.m_20299_(1.0f);
                    float f = random.nextFloat() * 2.0f;
                    float f1 = 4.0f + random.nextFloat() * 4.0f;
                    d0 = vec3.f_82479_ + (double)(Mth.m_14089_((float)(f * (float)Math.PI)) * f1);
                    d1 = vec3.f_82480_ + 2.0 + random.nextDouble() * 2.0;
                    d2 = vec3.f_82481_ + (double)(Mth.m_14031_((float)(f * (float)Math.PI)) * f1);
                    flag1 = true;
                }
                if (!flag1) {
                    Level level = this.parent.f_19853_;
                    BlockPos.MutableBlockPos blockpos$mutable = blockpos.m_122032_();
                    boolean flag2 = false;
                    int i = 0;
                    while (level.m_46859_((BlockPos)blockpos$mutable) && blockpos$mutable.m_123342_() > level.m_141937_()) {
                        blockpos$mutable.m_122173_(Direction.DOWN);
                        if (++i < 16) continue;
                        flag2 = true;
                        break;
                    }
                    d0 += (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    d1 += (double)(flag2 ? random.nextFloat() * -8.0f : (random.nextFloat() * 2.0f - 1.0f) * 8.0f);
                    d2 += (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                }
            }
            this.parent.m_21566_().m_6849_(d0, d1, d2, flag ? 0.75 : 0.25);
        }
    }

    private static class LookAroundGoal
    extends Goal {
        private final DyssomniaEntity parent;

        public LookAroundGoal(DyssomniaEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.parent.m_5448_() == null || this.parent.isActuallyRetreating() && this.parent.getAttackPhase() == AttackPhase.WAIT) {
                Vec3 vec3 = this.parent.m_20184_().m_82541_();
                double d0 = vec3.f_82479_;
                double d1 = vec3.f_82481_;
                double d2 = Math.sqrt(d0 * d0 + d1 * d1);
                this.parent.m_146922_(-((float)Mth.m_14136_((double)d0, (double)d1)) * 57.295776f);
                this.parent.f_20883_ = this.parent.m_146908_();
                this.parent.m_146926_(Mth.m_14036_((float)((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d2) * 57.2957763671875)), (float)-45.0f, (float)45.0f));
            } else {
                LivingEntity target = this.parent.m_5448_();
                if (target.m_20280_((Entity)this.parent) < 4096.0) {
                    double d0 = target.m_20185_() - this.parent.m_20185_();
                    double d1 = target.m_20186_() + (double)target.m_20192_();
                    double d2 = target.m_20189_() - this.parent.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    this.parent.m_146922_(-((float)Mth.m_14136_((double)d0, (double)d2)) * 57.295776f);
                    this.parent.f_20883_ = this.parent.m_146908_();
                    this.parent.m_146926_(Mth.m_14036_((float)(-((float)(Mth.m_14136_((double)(this.parent.m_20186_() - d1), (double)d3) * 57.2957763671875))), (float)-45.0f, (float)45.0f));
                }
            }
        }
    }

    private static class SummonGoal
    extends Goal {
        private final DyssomniaEntity parent;
        public int attackTimer;
        private final TargetingConditions phantomCountTargeting = TargetingConditions.m_148353_().m_26883_(32.0).m_148355_().m_26893_();

        public SummonGoal(DyssomniaEntity mob) {
            this.parent = mob;
        }

        public boolean m_8036_() {
            if (!this.parent.isRetreating() && this.parent.m_5448_() != null && this.parent.m_5448_() instanceof Player && this.parent.getAttackPhase() == AttackPhase.WAIT && (this.parent.m_21187_().nextInt(6) == 0 || this.parent.m_6060_()) && this.parent.m_20280_((Entity)this.parent.m_5448_()) < 256.0) {
                return this.parent.f_19853_.m_45971_(Phantom.class, this.phantomCountTargeting, (LivingEntity)this.parent, this.parent.m_142469_().m_82400_(32.0)).size() < 1;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.parent.m_5448_() != null && this.parent.m_5448_() instanceof Player && this.parent.getAttackPhase() == AttackPhase.SUMMON;
        }

        public void m_8056_() {
            this.attackTimer = -30;
            this.parent.setAttackPhase(AttackPhase.SUMMON);
        }

        public void m_8041_() {
            this.parent.setAttackingTime(-1);
            this.parent.setAttackPhase(AttackPhase.WAIT);
        }

        public void m_8037_() {
            LivingEntity target = this.parent.m_5448_();
            double d0 = 32.0;
            if ((target.m_20280_((Entity)this.parent) < d0 * d0 || this.attackTimer > 10) && this.parent.m_142582_((Entity)target)) {
                Level level = this.parent.f_19853_;
                ++this.attackTimer;
                if (this.attackTimer == 20) {
                    this.parent.summonPhantom((ServerLevel)level, (LivingEntity)this.parent, target, this.parent.m_21187_(), 1 + this.parent.m_21187_().nextInt(this.parent.f_19853_.m_46791_() == Difficulty.HARD ? 3 : 2));
                    this.parent.setAttackPhase(AttackPhase.WAIT);
                }
            } else {
                --this.attackTimer;
                if (this.attackTimer <= -40) {
                    this.parent.setAttackPhase(AttackPhase.WAIT);
                }
            }
            this.parent.setAttackingTime(this.attackTimer < 0 ? -1 : this.attackTimer);
        }
    }

    private static class ShotAttackGoal
    extends Goal {
        private final DyssomniaEntity parent;
        public int attackTimer;

        public ShotAttackGoal(DyssomniaEntity mob) {
            this.parent = mob;
        }

        public boolean m_8036_() {
            return this.parent.m_5448_() != null && this.parent.getAttackPhase() == AttackPhase.WAIT && this.parent.m_20280_((Entity)this.parent.m_5448_()) < 576.0;
        }

        public boolean m_8045_() {
            return this.parent.m_5448_() != null && this.parent.getAttackPhase() == AttackPhase.SHOT;
        }

        public void m_8056_() {
            this.attackTimer = -50;
            this.parent.setAttackPhase(AttackPhase.SHOT);
        }

        public void m_8041_() {
            this.parent.setAttackingTime(-1);
            this.parent.setAttackPhase(AttackPhase.WAIT);
        }

        public void m_8037_() {
            LivingEntity target = this.parent.m_5448_();
            double d0 = 32.0;
            if ((target.m_20280_((Entity)this.parent) < d0 * d0 || this.attackTimer > 10) && this.parent.m_142582_((Entity)target)) {
                Level level = this.parent.f_19853_;
                ++this.attackTimer;
                if (this.attackTimer == 30) {
                    double d1 = 1.75;
                    double d2 = 1.5;
                    Vec3 vec3 = this.parent.m_20252_(1.0f);
                    double d3 = target.m_20185_() - (this.parent.m_20185_() + vec3.f_82479_ * d1);
                    double d4 = target.m_20227_(0.5) - (this.parent.m_20188_() - vec3.f_82480_ * d2);
                    double d5 = target.m_20189_() - (this.parent.m_20189_() + vec3.f_82481_ * d1);
                    if (!this.parent.m_20067_()) {
                        level.m_5898_((Player)null, 1024, this.parent.m_142538_(), 0);
                    }
                    double d6 = Math.sqrt(d3 * d3 + d5 * d5) * (double)0.02f;
                    MagicBulletEntity bullet = new MagicBulletEntity(level, (LivingEntity)this.parent, d3 + this.parent.m_21187_().nextGaussian() * d6, d4, d5 + this.parent.m_21187_().nextGaussian() * d6);
                    bullet.m_6034_(this.parent.m_20185_() + vec3.f_82479_ * d1, this.parent.m_20188_() - vec3.f_82480_ * d2, this.parent.m_20189_() + vec3.f_82481_ * d1);
                    bullet.setDamage(5.0f);
                    bullet.setEffectLevel((byte)1);
                    bullet.setVariant(1);
                    level.m_7967_((Entity)bullet);
                    this.parent.setAttackPhase(AttackPhase.WAIT);
                }
            } else {
                --this.attackTimer;
                if (this.attackTimer <= -60) {
                    this.parent.setAttackPhase(AttackPhase.WAIT);
                }
            }
            this.parent.setAttackingTime(this.attackTimer < 0 ? -1 : this.attackTimer);
        }
    }

    public static enum AttackPhase {
        WAIT(0),
        SUMMON(1),
        SHOT(2);

        private final int id;
        private static final AttackPhase[] BY_ID;

        private AttackPhase(int idIn) {
            this.id = idIn;
        }

        public int getId() {
            return this.id;
        }

        public static AttackPhase byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (AttackPhase[])Arrays.stream(AttackPhase.values()).sorted(Comparator.comparingInt(AttackPhase::getId)).toArray(AttackPhase[]::new);
        }
    }
}

