/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.entity.IModMob;
import com.github.mechalopa.hmag.world.entity.ai.goal.MeleeAttackGoal2;
import com.github.mechalopa.hmag.world.entity.ai.goal.RangedAttackGoal2;
import com.github.mechalopa.hmag.world.entity.projectile.MagmaBulletEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class FortressKeeperEntity
extends Monster
implements IModMob,
RangedAttackMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(FortressKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private float attackAnimation;
    private float attackAnimationO;
    private float attackHandChangeAnimation;
    private float attackHandChangeAnimationO;

    public FortressKeeperEntity(EntityType<? extends FortressKeeperEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal2((PathfinderMob)this, 1.2, false, 0.6666667f, 4.0f));
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 0.75);
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            this.attackAnimationO = this.attackAnimation;
            this.attackHandChangeAnimationO = this.attackHandChangeAnimation;
        }
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.attackAnimation = this.isRangedAttacking() ? Math.min(1.0f, this.attackAnimation + 0.15f) : Math.max(0.0f, this.attackAnimation - 0.08f);
            this.attackHandChangeAnimation = this.isOffHandRangedAttack() ? Math.min(1.0f, this.attackHandChangeAnimation + 0.05f) : Math.max(0.0f, this.attackHandChangeAnimation - 0.05f);
        }
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_ && this.f_19797_ % 16 == 0 && !this.m_20145_() && !this.m_20072_() && this.f_20921_ <= 0.2f) {
            double d0 = this.m_20186_() + 2.625;
            if (this.attackAnimation <= 0.0f || this.attackHandChangeAnimation >= 1.0f ^ !this.m_21526_()) {
                float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * (0.75f + (this.m_21187_().nextFloat() - 0.5f) * 0.75f);
                float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * (0.75f + (this.m_21187_().nextFloat() - 0.5f) * 0.75f);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)f, d0 - this.m_21187_().nextDouble() * (double)0.1f, this.m_20189_() + (double)f1, 0.0, 0.0, 0.0);
            }
            if (this.attackAnimation <= 0.0f || this.attackHandChangeAnimation <= 0.0f ^ !this.m_21526_()) {
                float f2 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * (0.75f + (this.m_21187_().nextFloat() - 0.5f) * 0.75f);
                float f3 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * (0.75f + (this.m_21187_().nextFloat() - 0.5f) * 0.75f);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() - (double)f2, d0 - this.m_21187_().nextDouble() * (double)0.1f, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 0));
                }
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19360_() || source.m_19387_() || source.m_19384_() || ModUtils.isThornsDamage(source)) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * 0.5625f;
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * 0.5625f;
        if (this.isOffHandRangedAttack() ^ !this.m_21526_()) {
            f *= -1.0f;
            f1 *= -1.0f;
        }
        Vec3 vec3 = this.m_20252_(1.0f);
        f = (float)((double)f + vec3.f_82479_ * 1.25);
        f1 = (float)((double)f1 + vec3.f_82481_ * 1.25);
        double d0 = target.m_20185_() - (this.m_20185_() + (double)f);
        double d1 = target.m_20186_() + (double)target.m_20192_() * 0.5 - (this.m_20186_() + 0.75);
        double d2 = target.m_20189_() - (this.m_20189_() + (double)f1);
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        MagmaBulletEntity bulletentity = new MagmaBulletEntity(this.f_19853_, (LivingEntity)this, d0 + this.m_21187_().nextGaussian() * (d3 * (double)0.01f), d1 + d3 * (double)0.08f, d2 + this.m_21187_().nextGaussian() * (d3 * (double)0.01f));
        bulletentity.m_6034_(bulletentity.m_20185_() + (double)f, this.m_20186_() + 0.75, bulletentity.m_20189_() + (double)f1);
        bulletentity.setDamage(4.0f);
        this.f_19853_.m_7967_((Entity)bulletentity);
        for (int i = 0; i < 8; ++i) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, bulletentity.m_20185_(), bulletentity.m_20186_(), bulletentity.m_20189_(), 1, this.m_21187_().nextGaussian() * 0.05, 0.005, this.m_21187_().nextGaussian() * 0.05, 0.0);
        }
        if (!this.m_20072_()) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123756_, bulletentity.m_20185_(), bulletentity.m_20186_(), bulletentity.m_20189_(), 8, 0.0, 0.0, 0.0, 0.0);
        }
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12417_, this.m_5720_(), 2.0f, (this.m_21187_().nextFloat() - this.m_21187_().nextFloat()) * 0.2f + 1.0f);
        }
        if (this.m_21187_().nextInt(3) == 0) {
            this.setOffHandRangedAttack(!this.isOffHandRangedAttack());
        }
    }

    public int m_5792_() {
        return 2;
    }

    public int m_8132_() {
        return 30;
    }

    public int m_8085_() {
        return 30;
    }

    public double m_6049_() {
        return -0.1;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.74f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
            this.attackAnimation = 0.0f;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean isRangedAttacking() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setRangedAttacking(boolean flag) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isOffHandRangedAttack() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 2) != 0;
    }

    public void setOffHandRangedAttack(boolean flag) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setOffHandRangedAttack(compound.m_128471_("isOffHandRangedAttack"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isOffHandRangedAttack", this.isOffHandRangedAttack());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)this.attackAnimationO, (float)this.attackAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackHandChangeAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)this.attackHandChangeAnimationO, (float)this.attackHandChangeAnimation);
    }

    public float m_6073_() {
        return 1.0f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.DOLL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.DOLL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.DOLL_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12161_, 0.5f, 0.25f);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class RangedAttackGoal
    extends RangedAttackGoal2 {
        public RangedAttackGoal(RangedAttackMob mob) {
            super(mob, 0.9, 40, 60, 9.0f, 4.0f, false);
        }

        public void m_8056_() {
            super.m_8056_();
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            FortressKeeperEntity.this.setRangedAttacking(false);
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            FortressKeeperEntity attacker = FortressKeeperEntity.this;
            if (this.getAttackTime() >= 0 && this.getAttackTime() <= 20) {
                if (!attacker.isRangedAttacking()) {
                    attacker.setRangedAttacking(true);
                }
            } else if (attacker.isRangedAttacking() && (attacker.m_20275_(this.getTarget().m_20185_(), this.getTarget().m_20186_(), this.getTarget().m_20189_()) > 256.0 || !attacker.m_21574_().m_148306_((Entity)this.getTarget()))) {
                attacker.setRangedAttacking(false);
            }
        }
    }
}

