/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.IModMob;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class GlaryadEntity
extends Monster
implements NeutralMob,
IModMob {
    private static final UniformInt FIRST_ANGER_SOUND_DELAY = TimeUtil.m_145020_((int)0, (int)1);
    private int playFirstAngerSoundIn;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private static final UniformInt ALERT_INTERVAL = TimeUtil.m_145020_((int)4, (int)6);
    private int ticksUntilNextAlert;

    public GlaryadEntity(EntityType<? extends GlaryadEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 12;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(4, (Goal)new GlaryadTemptGoal(this, 1.0, Ingredient.m_204132_(ModTags.GLARYAD_TEMPT_ITEMS)));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, arg_0 -> ((GlaryadEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected void m_8024_() {
        if (this.m_21660_()) {
            this.maybePlayFirstAngerSound();
        }
        this.m_21666_((ServerLevel)this.f_19853_, true);
        if (this.m_5448_() != null) {
            this.maybeAlertOthers();
        }
        if (this.m_21660_()) {
            this.f_20889_ = this.f_19797_;
        }
        super.m_8024_();
        if (this.m_6084_() && ModConfigs.cachedServer.GLARYAD_REGEN && this.m_20071_() && !this.m_21023_(MobEffects.f_19605_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
        }
    }

    protected void m_7562_() {
        float f = this.m_6073_();
        if (f <= 0.5f) {
            this.f_20891_ += 2;
        }
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        return levelReader.m_46863_(pos) - 0.5f;
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    private void maybePlayFirstAngerSound() {
        if (this.playFirstAngerSoundIn > 0) {
            --this.playFirstAngerSoundIn;
            if (this.playFirstAngerSoundIn == 0) {
                this.playAngerSound();
                this.f_19853_.m_7605_((Entity)this, (byte)13);
            }
        }
    }

    private void maybeAlertOthers() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.alertOthers();
            }
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_142270_(this.f_19796_);
        }
    }

    private void alertOthers() {
        double d0 = this.m_21133_(Attributes.f_22277_);
        AABB aabb = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(d0, 10.0, d0);
        this.f_19853_.m_6443_(GlaryadEntity.class, aabb, EntitySelector.f_20408_).stream().filter(p -> p != this).filter(p -> p.m_5448_() == null).filter(p -> !p.m_7307_((Entity)this.m_5448_())).forEach(p -> p.m_6710_(this.m_5448_()));
    }

    private void playAngerSound() {
        this.m_5496_(SoundEvents.f_144068_, this.m_6121_(), this.m_6100_());
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        if (this.m_5448_() == null && livingEntity != null) {
            this.playFirstAngerSoundIn = FIRST_ANGER_SOUND_DELAY.m_142270_(this.f_19796_);
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_142270_(this.f_19796_);
        }
        if (livingEntity instanceof Player) {
            this.m_6598_((Player)livingEntity);
        }
        super.m_6710_(livingEntity);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19384_()) {
            amount *= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6935_(Player player) {
        return this.m_21674_((LivingEntity)player);
    }

    public boolean m_5545_(LevelAccessor levelAccessor, MobSpawnType spawnType) {
        return true;
    }

    public static boolean checkGlaryadSpawnRules(EntityType<? extends GlaryadEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Monster.m_33023_(type, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random) && (spawnType == MobSpawnType.SPAWNER || levelAccessor.m_8055_(pos.m_7495_()).m_204336_(ModTags.GLARYADS_SPAWNABLE_ON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 13) {
            for (int i = 0; i < 5; ++i) {
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_147285_(this.f_19853_, compound);
    }

    public int m_5792_() {
        return 3;
    }

    public double m_6049_() {
        return -0.45;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.74f;
    }

    public float m_6073_() {
        return Mth.m_14036_((float)(super.m_6073_() + 0.4f), (float)0.0f, (float)1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class GlaryadTemptGoal
    extends TemptGoal {
        public GlaryadTemptGoal(GlaryadEntity mob, double speed, Ingredient ingredient) {
            super((PathfinderMob)mob, speed, ingredient, false);
        }

        public boolean m_8036_() {
            return !GlaryadEntity.this.m_21660_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !GlaryadEntity.this.m_21660_() && super.m_8045_();
        }
    }
}

