/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.world.entity.IModMob;
import com.github.mechalopa.hmag.world.entity.ai.goal.LeapAtTargetGoal2;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class HarpyEntity
extends Monster
implements IModMob {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(HarpyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int animationTick;
    private int animationTickO;

    public HarpyEntity(EntityType<? extends HarpyEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 1.5f;
        this.f_21364_ = 12;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal2((Mob)this, 0.39f, 0.45f, 7.0f, 24));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(120));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.295).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22277_, 20.0);
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            this.animationTickO = this.animationTick;
        }
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (!(this.m_20096_() || this.m_20072_() || this.m_20159_())) {
                if (this.animationTick < 10) {
                    this.animationTick = Math.min(this.animationTick + 2, 10);
                }
            } else if (this.animationTick > 0) {
                this.animationTick = Math.max(this.animationTick - 5, 0);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, spawnType, spawnDataIn, dataTag);
        if (this.m_21187_().nextFloat() < 0.001f) {
            this.setVariant(6);
        } else {
            ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)((Biome)worldIn.m_204166_(this.m_142538_()).m_203334_()).getRegistryName());
            if (biomeKey != null) {
                if (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                    this.setVariant(this.m_21187_().nextInt(4) == 0 ? this.m_21187_().nextInt(3) + 2 : 5);
                } else if (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                    this.setVariant(this.m_21187_().nextInt(5) == 0 ? 3 : (this.m_21187_().nextInt(3) == 0 ? 0 : this.m_21187_().nextInt(2) + 1));
                } else if (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                    this.setVariant(this.m_21187_().nextInt(5) == 0 ? 5 : (this.m_21187_().nextInt(3) == 0 ? 1 : (this.m_21187_().nextBoolean() ? 0 : 2)));
                } else if (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                    this.setVariant(this.m_21187_().nextInt(6) == 0 ? 4 : this.m_21187_().nextInt(3));
                } else if (BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                    this.setVariant(this.m_21187_().nextInt(3) == 0 ? (this.m_21187_().nextBoolean() ? 1 : 4) : 3);
                } else {
                    this.setVariant(this.m_21187_().nextBoolean() ? 0 : 3);
                }
            } else {
                this.setVariant(this.m_21187_().nextBoolean() ? 0 : 3);
            }
        }
        return spawnDataIn;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID);
    }

    private void setVariant(int typeIn) {
        if (typeIn < 0 || typeIn >= 7) {
            typeIn = this.m_21187_().nextInt(6);
        }
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)typeIn);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public int m_5792_() {
        return 3;
    }

    public double m_6049_() {
        return -0.45;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.74f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)((float)this.animationTickO / 10.0f), (float)((float)this.animationTick / 10.0f));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class RandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        private boolean isLeaped;

        public RandomStrollGoal(HarpyEntity mob) {
            super((PathfinderMob)mob, 1.0);
            this.isLeaped = false;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public void m_8056_() {
            super.m_8056_();
            this.isLeaped = false;
        }

        public void m_8041_() {
            super.m_8041_();
            this.isLeaped = false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && (!this.isLeaped || !this.f_25725_.m_20096_());
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos pos = this.f_25725_.m_21573_().m_26567_();
            if (pos != null) {
                double d0;
                if (!this.isLeaped && this.f_25725_.m_20096_() && this.f_25725_.m_21187_().nextInt(32) == 0 && Math.abs((double)pos.m_123342_() - this.f_25725_.m_20186_()) <= 1.5 && (d0 = this.f_25725_.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5)) <= 36.0 && d0 > 4.0) {
                    Vec3 vec3 = this.f_25725_.m_20184_();
                    Vec3 vec31 = new Vec3((double)pos.m_123341_() + 0.5 - this.f_25725_.m_20185_(), 0.0, (double)pos.m_123343_() + 0.5 - this.f_25725_.m_20189_());
                    if (vec31.m_82556_() > 1.0E-7) {
                        vec31 = vec31.m_82541_().m_82490_(0.4 + (double)(this.f_25725_.m_21187_().nextFloat() * 0.1f)).m_82549_(vec3.m_82490_(0.2));
                    }
                    this.f_25725_.m_20334_(vec31.f_82479_, 0.4 + (double)(this.f_25725_.m_21187_().nextFloat() * 0.05f), vec31.f_82481_);
                    this.isLeaped = true;
                }
                if (this.isLeaped) {
                    this.f_25725_.m_21563_().m_24950_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 30.0f, 30.0f);
                }
            }
        }
    }
}

