/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.world.entity.IModMob;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.network.NetworkHooks;

public class KashaEntity
extends Monster
implements IModMob {
    private static final UUID ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("7DDA541D-ABAA-BBF4-D099-AAC57D64ADA9");
    private static final AttributeModifier ATTACK_DAMAGE_MODIFIER = new AttributeModifier(ATTACK_DAMAGE_MODIFIER_UUID, "Soul variant attack damage bonus", 1.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(KashaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public KashaEntity(EntityType<? extends KashaEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_19793_ = 2.0f;
        this.f_21364_ = 12;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(4, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        if (ModConfigs.cachedServer.KASHA_ATTACK_CHICKENS) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, false));
        }
        if (ModConfigs.cachedServer.KASHA_ATTACK_BABY_HOGLINS) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Hoglin.class, 10, false, false, p -> p.m_6162_()));
        }
        if (ModConfigs.cachedServer.KASHA_ATTACK_VILLAGERS) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (ModConfigs.cachedServer.KASHA_ATTACK_BABY_TURTLES) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, false, false, Turtle.f_30122_));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.325).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            if (this.f_19797_ % 10 == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_() + 0.25, this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            if (this.f_19797_ % 2 == 0) {
                this.f_19853_.m_7106_((ParticleOptions)(this.getVariant() == Variant.SOUL ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), this.m_20208_(0.75), this.m_20187_() - 0.1, this.m_20262_(0.75), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 5;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    entityIn.m_20254_(i);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6126_() {
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, spawnType, spawnDataIn, dataTag);
        if (this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_204336_(BlockTags.f_13085_)) {
            this.setVariant(Variant.SOUL);
        } else {
            this.setVariant(Variant.NORMAL);
        }
        return spawnDataIn;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    private void setVariant(Variant variant) {
        if (!this.f_19853_.f_46443_) {
            this.m_21051_(Attributes.f_22281_).m_22130_(ATTACK_DAMAGE_MODIFIER);
            if (variant == Variant.SOUL) {
                this.m_21051_(Attributes.f_22281_).m_22125_(ATTACK_DAMAGE_MODIFIER);
            }
        }
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.getId());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().getId());
    }

    public int m_5792_() {
        return 3;
    }

    public float m_6073_() {
        return 1.0f;
    }

    public double m_6049_() {
        return 0.14;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.KASHA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.KASHA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.KASHA_DEATH.get();
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Variant {
        NORMAL(0),
        SOUL(1);

        private final int id;
        private static final Variant[] BY_ID;

        private Variant(int idIn) {
            this.id = idIn;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

