/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.entity.IModMob;
import com.github.mechalopa.hmag.world.entity.ai.goal.MeleeAttackGoal2;
import com.mojang.datafixers.DataFixUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class SavagefangEntity
extends Monster
implements IModMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(SavagefangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private SavagefangEntity leader;
    private int schoolSize = 1;
    private int leapCooldown;
    private float xRotAnimation;
    private float xRotAnimationO;
    private float attackAnimation;
    private float attackAnimationO;

    public SavagefangEntity(EntityType<? extends SavagefangEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SavagefangMoveControl(this);
        this.f_21365_ = new SavagefangLookControl(this);
        this.f_21364_ = 3;
        this.leapCooldown = 0;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new LeapGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SwimGoal(this, 1.0, 20));
        this.f_21345_.m_25352_(5, (Goal)new FollowSchoolLeaderGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, (Predicate)new TargetPredicate(this)).m_26146_(30));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 3.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19312_, 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_8119_() {
        List list;
        if (this.f_19853_.f_46443_) {
            if (this.isLaunched()) {
                this.xRotAnimation = 0.0f;
            }
            this.attackAnimationO = this.attackAnimation;
            this.xRotAnimationO = this.xRotAnimation;
        }
        super.m_8119_();
        if (this.hasFollowers() && this.f_19853_.f_46441_.nextInt(200) == 1 && (list = this.f_19853_.m_45976_(this.getClass(), this.m_142469_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
        if (this.f_19853_.f_46443_) {
            if (!this.isLaunched()) {
                this.xRotAnimation = Mth.m_14036_((float)ModUtils.rotlerp(this.xRotAnimation, this.m_146909_(), 90.0f, false), (float)-180.0f, (float)180.0f);
            }
            this.attackAnimation = this.isAttacking() ? Math.min(1.0f, this.attackAnimation + 0.25f) : Math.max(0.0f, this.attackAnimation - 0.08f);
        }
    }

    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null && this.m_5448_().m_6084_() && !this.isLaunched()) {
                if (!this.isAttacking()) {
                    this.setAttacking(true);
                }
                if (this.leapCooldown > 0) {
                    --this.leapCooldown;
                }
            } else {
                if (this.isAttacking()) {
                    this.setAttacking(false);
                }
                this.leapCooldown = 0;
            }
        }
        if (!this.m_20069_()) {
            if (this.m_20096_() && this.f_19863_) {
                float f = this.isLaunched() ? 0.2f : 0.4f;
                this.m_20256_(this.m_20184_().m_82520_((double)((this.m_21187_().nextFloat() * 2.0f - 1.0f) * f), this.isLaunched() ? (double)0.4f : (double)0.6f, (double)((this.m_21187_().nextFloat() * 2.0f - 1.0f) * f)));
                this.f_19861_ = false;
                this.f_19812_ = true;
                this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
                if (!(this.m_21525_() || this.m_21187_().nextInt(8) != 0 && this.m_20146_() > 100)) {
                    this.setLaunched(true);
                }
            }
        } else if (this.isLaunched()) {
            this.setLaunched(false);
        }
        super.m_8107_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (super.m_6469_(source, amount)) {
            if (!(this.f_19853_.f_46443_ || this.m_21525_() || this.m_20069_() || this.isLaunched())) {
                this.setLaunched(true);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if ((spawnDataIn = super.m_6518_(worldIn, difficultyIn, spawnType, spawnDataIn, dataTag)) == null) {
            spawnDataIn = new SchoolSpawnGroupData(this);
        } else {
            this.startFollowing(((SchoolSpawnGroupData)spawnDataIn).leader);
        }
        this.leapCooldown = 0;
        return spawnDataIn;
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.01f, vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(vec3);
        }
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        return levelReader.m_6425_(pos).m_205070_(FluidTags.f_13131_) ? 10.0f + levelReader.m_46863_(pos) - 0.5f : super.m_5610_(pos, levelReader);
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.65f;
    }

    public void setLeapCooldown(int value) {
        this.leapCooldown = value;
    }

    public int getLeapCooldown() {
        return this.leapCooldown;
    }

    public boolean isLaunched() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setLaunched(boolean flag) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isAttacking() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 2) != 0;
    }

    public void setAttacking(boolean flag) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLaunched(compound.m_128471_("isLaunched"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isLaunched", this.isLaunched());
    }

    public int m_5792_() {
        return 8;
    }

    public static boolean checkSavagefangSpawnRules(EntityType<? extends SavagefangEntity> type, ServerLevelAccessor worldIn, MobSpawnType spawnType, BlockPos pos, Random randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && SavagefangEntity.m_33008_((ServerLevelAccessor)worldIn, (BlockPos)pos, (Random)randomIn) && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_) && (spawnType == MobSpawnType.SPAWNER || pos.m_123342_() >= worldIn.m_5736_() - 10 && worldIn.m_46861_(pos) && randomIn.nextDouble() < ModConfigs.cachedServer.SAVAGEFANG_SPAWN_CHANCE);
    }

    public int getMaxSchoolSize() {
        return 5;
    }

    protected boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public SavagefangEntity startFollowing(SavagefangEntity mob) {
        this.leader = mob;
        mob.addFollower();
        return mob;
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower() && this.m_5448_() == null) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends SavagefangEntity> stream) {
        stream.limit(this.getMaxSchoolSize() - this.schoolSize).filter(p -> p != this).forEach(p -> p.startFollowing(this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getXRotAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)(this.xRotAnimationO / 180.0f), (float)(this.xRotAnimation / 180.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)this.attackAnimationO, (float)this.attackAnimation);
    }

    public int m_8100_() {
        return 120;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11761_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 15) {
            Vec3 vec3 = this.m_20252_(0.0f);
            for (int i = 0; i < 12; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5) - vec3.f_82479_ * 1.0, this.m_20187_() - vec3.f_82480_ * 1.0, this.m_20262_(0.5) - vec3.f_82481_ * 1.0, 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(id);
        }
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected static class SavagefangMoveControl
    extends MoveControl {
        private final SavagefangEntity mob;

        public SavagefangMoveControl(SavagefangEntity mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void m_8126_() {
            if (this.mob.m_204029_(FluidTags.f_13131_)) {
                this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.mob.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.mob.m_21133_(Attributes.f_22279_));
                this.mob.m_7910_(Mth.m_14179_((float)0.125f, (float)this.mob.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.mob.m_20185_();
                double d1 = this.f_24976_ - this.mob.m_20186_();
                double d2 = this.f_24977_ - this.mob.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                if (d1 != 0.0) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, (double)this.mob.m_6113_() * (d1 / d3) * 0.01, 0.0));
                }
                if (d3 >= (double)2.5E-7f) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.mob.m_146922_(this.m_24991_(this.mob.m_146908_(), f1, this.mob.m_5448_() != null ? 90.0f : 30.0f));
                    this.mob.m_5618_(this.mob.m_146908_());
                }
            } else {
                this.mob.m_7910_(Mth.m_14179_((float)0.125f, (float)this.mob.m_6113_(), (float)0.0f));
            }
        }
    }

    protected class SavagefangLookControl
    extends LookControl {
        private final SavagefangEntity mob;

        public SavagefangLookControl(SavagefangEntity mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void m_8128_() {
            if (!this.mob.isLaunched()) {
                Vec3 vec3 = this.mob.m_20184_();
                if (vec3.m_82556_() > 0.001) {
                    vec3 = vec3.m_82541_();
                    double d0 = vec3.f_82479_;
                    double d1 = vec3.f_82481_;
                    double d2 = Math.sqrt(d0 * d0 + d1 * d1);
                    this.mob.m_146926_(Mth.m_14036_((float)((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d2) * 57.2957763671875)), (float)-60.0f, (float)60.0f));
                } else {
                    this.mob.m_146926_(0.0f);
                }
            } else {
                this.mob.m_146926_(0.0f);
            }
            this.mob.m_5616_(this.mob.m_146908_());
        }
    }

    private static class LeapGoal
    extends Goal {
        private final SavagefangEntity mob;
        private LivingEntity target;

        public LeapGoal(SavagefangEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20160_() || this.mob.getLeapCooldown() > 0 || this.mob.isLaunched()) {
                return false;
            }
            this.target = this.mob.m_5448_();
            if (this.target == null) {
                return false;
            }
            double d0 = this.mob.m_20280_((Entity)this.target);
            if (!(d0 < 4.0) && !(d0 > 16.0)) {
                if (!this.mob.m_20072_()) {
                    return false;
                }
                return this.mob.m_21187_().nextInt(4) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return false;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            this.mob.setLeapCooldown(15 + this.mob.m_21187_().nextInt(15));
            Vec3 vec3 = this.mob.m_20184_();
            Vec3 vec31 = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_());
            if (vec31.m_82556_() > 1.0E-7) {
                vec31 = vec31.m_82541_().m_82490_(0.25 + (double)(this.mob.m_21187_().nextFloat() * 0.05f)).m_82549_(vec3.m_82490_(0.5));
            }
            if (!this.target.m_20072_() || this.target.m_20186_() + 1.0 > this.mob.m_20188_() && this.mob.f_19853_.m_46859_(new BlockPos((double)this.mob.m_142538_().m_123341_(), (double)this.mob.m_142538_().m_123342_() + 1.0, (double)this.mob.m_142538_().m_123343_()))) {
                this.mob.m_20334_(vec31.f_82479_, 0.4 + (double)(this.mob.m_21187_().nextFloat() * 0.2f), vec31.f_82481_);
            } else {
                this.mob.m_20334_(vec31.f_82479_ * 1.2, 0.05, vec31.f_82481_ * 1.2);
            }
            this.mob.m_21573_().m_26573_();
            FluidState fluidstate = this.mob.f_19853_.m_6425_(this.mob.m_142538_());
            if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                this.mob.m_5496_(SoundEvents.f_11805_, 0.9f, 1.2f);
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)15);
            }
        }
    }

    private class AttackGoal
    extends MeleeAttackGoal2 {
        private final SavagefangEntity mob;

        public AttackGoal(SavagefangEntity mob) {
            super((PathfinderMob)mob, 1.5, false, 0.7f);
            this.mob = mob;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isLaunched();
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isLaunched();
        }

        protected int m_25566_() {
            return this.m_183277_(10);
        }
    }

    private static class SwimGoal
    extends RandomSwimmingGoal {
        private final SavagefangEntity mob;

        public SwimGoal(SavagefangEntity mob, double speed, int interval) {
            super((PathfinderMob)mob, speed, interval);
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.canRandomSwim() && super.m_8036_();
        }
    }

    private static class FollowSchoolLeaderGoal
    extends Goal {
        private final SavagefangEntity mob;
        private int timeToRecalcPath;
        private int nextStartTick;

        public FollowSchoolLeaderGoal(SavagefangEntity mob) {
            this.mob = mob;
            this.nextStartTick = this.nextStartTick(mob);
        }

        protected int nextStartTick(SavagefangEntity mob) {
            return 200 + mob.m_21187_().nextInt(200) % 20;
        }

        public boolean m_8036_() {
            if (this.mob.m_5448_() != null) {
                return false;
            }
            if (this.mob.hasFollowers()) {
                return false;
            }
            if (this.mob.isFollower()) {
                return true;
            }
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick(this.mob);
            Predicate<SavagefangEntity> predicate = p -> p.canBeFollowed() || !p.isFollower();
            List list = this.mob.f_19853_.m_6443_(this.mob.getClass(), this.mob.m_142469_().m_82377_(8.0, 8.0, 8.0), predicate);
            SavagefangEntity monsterentity = (SavagefangEntity)DataFixUtils.orElse(list.stream().filter(SavagefangEntity::canBeFollowed).findAny(), (Object)this.mob);
            monsterentity.addFollowers(list.stream().filter(p -> !p.isFollower()));
            return this.mob.isFollower();
        }

        public boolean m_8045_() {
            return this.mob.m_5448_() == null && this.mob.isFollower() && this.mob.inRangeOfLeader();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.mob.stopFollowing();
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 30;
                this.mob.pathToLeader();
            }
        }
    }

    private static class TargetPredicate
    implements Predicate<LivingEntity> {
        private final SavagefangEntity parent;

        public TargetPredicate(SavagefangEntity mob) {
            this.parent = mob;
        }

        @Override
        public boolean test(@Nullable LivingEntity livingEntityIn) {
            if (this.parent.isLaunched() || livingEntityIn.m_6095_().m_204039_(ModTags.SAVAGEFANG_TARGET_BLACKLIST) || livingEntityIn instanceof SavagefangEntity) {
                return false;
            }
            if (livingEntityIn instanceof Player || livingEntityIn.m_6336_() != MobType.f_21644_ && !livingEntityIn.m_6040_() && livingEntityIn instanceof Animal && ModConfigs.cachedServer.SAVAGEFANG_ATTACK_ANIMALS || livingEntityIn instanceof AbstractVillager && ModConfigs.cachedServer.SAVAGEFANG_ATTACK_VILLAGERS || livingEntityIn.m_6336_() == MobType.f_21643_ && ModConfigs.cachedServer.SAVAGEFANG_ATTACK_ILLAGERS) {
                return livingEntityIn.m_20280_((Entity)this.parent) <= 16.0 || livingEntityIn.m_20072_() && livingEntityIn.m_20280_((Entity)this.parent) <= 81.0;
            }
            if (!(livingEntityIn instanceof FlyingMob) && ModConfigs.cachedServer.SAVAGEFANG_ATTACK_DAMAGED_MOBS) {
                return livingEntityIn.m_20072_() && livingEntityIn.m_20280_((Entity)this.parent) <= 81.0 && (livingEntityIn.m_21223_() < 10.0f && livingEntityIn.m_21223_() < livingEntityIn.m_21233_() || livingEntityIn.m_21223_() < livingEntityIn.m_21233_() * 0.25f);
            }
            return false;
        }
    }

    public static class SchoolSpawnGroupData
    implements SpawnGroupData {
        public final SavagefangEntity leader;

        public SchoolSpawnGroupData(SavagefangEntity mob) {
            this.leader = mob;
        }
    }
}

