/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.world.entity.IModMob;
import com.github.mechalopa.hmag.world.entity.MagicalSlimeEntity;
import com.github.mechalopa.hmag.world.entity.ai.goal.LeapAtTargetGoal2;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class SlimeGirlEntity
extends Monster
implements IModMob {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(SlimeGirlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround;

    public SlimeGirlEntity(EntityType<? extends SlimeGirlEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 15;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.19).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public void m_8119_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.m_8119_();
        boolean flag = false;
        if (this.m_20096_() && !this.wasOnGround) {
            if (this.f_19853_.f_46443_) {
                this.spawnParticle(12);
            }
            this.targetSquish = -0.5f;
            flag = true;
        } else if (!this.f_19861_ && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        if (this.f_19853_.f_46443_ && !flag && this.f_19797_ % 8 == 0 && this.m_21187_().nextInt(3) == 0) {
            this.spawnParticle(1);
        }
        this.wasOnGround = this.m_20096_();
        this.targetSquish *= 0.6f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticle(int count) {
        for (int j = 0; j < count; ++j) {
            float f = this.m_21187_().nextFloat() * ((float)Math.PI * 2);
            float f1 = this.m_21187_().nextFloat() * 0.5f + 0.5f;
            float f2 = Mth.m_14031_((float)f) * 0.6f * f1;
            float f3 = Mth.m_14089_((float)f) * 0.6f * f1;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_6084_() && ModConfigs.cachedServer.SLIME_GIRL_REGEN && this.m_20071_() && !this.m_21023_(MobEffects.f_19605_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.m_21187_().nextFloat() - this.m_21187_().nextFloat()) * 0.2f + 1.0f);
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.f_46443_ && ModConfigs.cachedServer.MAGICAL_SLIME_SPAWNS_ON_SLIME_GIRL_DEATH && this.m_21224_()) {
            Component component = this.m_7770_();
            boolean flag = this.m_21525_();
            int i = 2;
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.m_21187_().nextInt(3);
            for (int l = 0; l < k; ++l) {
                float f1 = ((float)(l % 2) - 0.5f) * f;
                float f2 = ((float)(l / 2) - 0.5f) * f;
                MagicalSlimeEntity slime = (MagicalSlimeEntity)((EntityType)ModEntityTypes.MAGICAL_SLIME.get()).m_20615_(this.f_19853_);
                if (this.m_21532_()) {
                    slime.m_21530_();
                }
                slime.m_6593_(component);
                slime.m_21557_(flag);
                slime.m_20331_(this.m_20147_());
                slime.m_7839_(j, true);
                if (this.m_21187_().nextInt(8) != 0) {
                    slime.setVariant(this.getVariant());
                }
                slime.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 0.5, this.m_20189_() + (double)f2, this.m_21187_().nextFloat() * 360.0f, 0.0f);
                this.f_19853_.m_7967_((Entity)slime);
            }
        }
        super.m_142687_(reason);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19387_() || source == DamageSource.f_19315_) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, spawnType, spawnDataIn, dataTag);
        this.setVariant(this.m_21187_().nextInt(ColorVariant.values().length));
        return spawnDataIn;
    }

    public int m_5792_() {
        return 2;
    }

    public double m_6049_() {
        return -0.45;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.74f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getColor() {
        return ColorVariant.byId(this.getVariant()).getColors();
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID);
    }

    private void setVariant(int typeIn) {
        if (typeIn < 0 || typeIn >= ColorVariant.values().length) {
            typeIn = this.m_21187_().nextInt(ColorVariant.values().length);
        }
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)typeIn);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("wasOnGround", this.wasOnGround);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.wasOnGround = compound.m_128471_("wasOnGround");
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12388_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12386_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12393_, 0.15f, 1.0f);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class LeapGoal
    extends LeapAtTargetGoal2 {
        private final Mob mob;

        public LeapGoal(Mob mob) {
            super(mob, 0.25f, 0.3f, 6.0f, 6);
            this.mob = mob;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.mob.m_5496_(SoundEvents.f_12387_, 1.0f, ((this.mob.m_21187_().nextFloat() - this.mob.m_21187_().nextFloat()) * 0.2f + 1.0f) * 1.4f);
        }
    }

    public static enum ColorVariant {
        PINK1(0, 16678066),
        PINK2(1, 16608633),
        PINK3(2, 16143733),
        PINK4(3, 16732339),
        LIGHT_PINK1(4, 16225469),
        LIGHT_PINK2(5, 0xFF999D),
        DARK_PINK1(6, 16005289),
        DARK_PINK2(7, 14830776),
        PURPLE1(8, 13393626),
        PURPLE2(9, 13269976),
        LAVENDER(10, 12360685),
        WHITE1(11, 16766945),
        RED1(12, 0xF77272),
        RED2(13, 16605268),
        SLIME(14, 9489279),
        MINT(15, 7077059),
        BLACK(16, 0x3C3838),
        SLATEBLUE(17, 6970061),
        WHITE2(18, 16768685),
        DARK_RED1(19, 0x8B0000),
        DARK_RED2(20, 14423100),
        ORANGE(21, 16747520),
        BROWN(22, 9127187),
        GOLD(23, 16766720),
        DARK_KHAKI(24, 12433259),
        GREEN_YELLOW(25, 11403055),
        GREEN1(26, 7048739),
        GREEN2(27, 3050327),
        GREEN3(28, 6452328),
        BLUE(29, 8900331),
        TURQUOISE(30, 4251856),
        GRAY(31, 0x778899);

        private final int id;
        private final float[] colors;
        private static final ColorVariant[] BY_ID;

        private ColorVariant(int idIn, int colorIn) {
            this.id = idIn;
            int i = (colorIn & 0xFF0000) >> 16;
            int j = (colorIn & 0xFF00) >> 8;
            int k = (colorIn & 0xFF) >> 0;
            this.colors = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        }

        public int getId() {
            return this.id;
        }

        public float[] getColors() {
            return this.colors;
        }

        public static ColorVariant byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (ColorVariant[])Arrays.stream(ColorVariant.values()).sorted(Comparator.comparingInt(ColorVariant::getId)).toArray(ColorVariant[]::new);
        }
    }
}

